# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/03_df.ipynb (unless otherwise specified).

__all__ = ['PandasDisplay']

# Cell
import pandas as pd

class PandasDisplay:
    """
    Temporary pandas display config "with" hook
    with PandasDisplay(max_colwidth = 0,max_rows=100):
        display(df)
    """
    def __init__(self,**kwargs):

        self.kwargs = kwargs
        self.cache = dict()

    def __enter__(self):
        for k,v in self.kwargs.items():
            self.cache[k] = pd.get_option(f"display.{k}")
            pd.set_option(f"display.{k}",v)
        return self

    def __exit__(self, type, value, tb):
        for k,v in self.cache.items():
            pd.set_option(f"display.{k}",v)