import unittest

import numpy as np
import matplotlib.pylab as plt

from brainbox.population import cca


class TestBunch(unittest.TestCase):

    def test_plotting(self):
        """
        This test is just to document current use in libraries in case of refactoring
        """
        corrs = np.array([.6, .2, .1, .001])
        errs = np.array([.1, .05, .04, .0005])
        fig, ax1 = plt.subplots(1, 1, figsize=(5, 5))
        cca.plot_correlations(corrs, errs, ax=ax1, color='blue')
        cca.plot_correlations(corrs * .1, errs, ax=ax1, color='orange')

    # Shuffle data
    # ...
    # fig, ax1 = plt.subplots(1,1,figsize(10,10))
    # plot_correlations(corrs, ... , ax=ax1, color='blue')
    # plot_correlations(shuffled_coors, ..., ax=ax1, color='red')
    # plt.show()


if __name__ == "__main__":
    unittest.main(exit=False)
