<div align="center">
  <img src="https://plexflo-opensource.s3.amazonaws.com/Plexflo_logo.png">
</div>

[![Python](https://shields.io/pypi/pyversions/plexflo)](https://badge.fury.io/py/tensorflow)
[![PyPI version](https://badge.fury.io/py/plexflo.svg)](https://badge.fury.io/py/plexflo)

**Documentation** |
------------------- |
[![Documentation](https://img.shields.io/badge/docs-passing-brightgree)](https://docs.plexflo.com/docs/datastream-library) |

## Plexflo

Plexflo offers a comprehensive ecosystem of tools and libraries that lets you build Deep Learning powered applications for effective management of grid with accurate forecasting and analytics.

## Non-Intrusive Load Monitoring

Non-Intrusive Load Monitoring (NILM) is the process of deducing/identifying appliances and their energy consumption in a household. With NILM, we enable energy disaggregation – Process of decomposing power consumptions levels at appliance level from the aggregate consumption at house level.

## Plexflo's Open Source library

We have built an Open-Source library <em>datastream</em> that aids researchers and engineers to try our Deep Learning models for detection of EVs (Electric Vehicles) charging events from smart home meter data.

## Installation

```
$ pip install plexflo
```
To update plexflo to the latest version, add `--upgrade` flag to the above
commands.

## Trying out our library

For examples an how to use the library, see the [Official guide](https://docs.plexflo.com/docs/datastream-library).

## Contribution Guidelines

If you want to contribute to Plexflo, be sure to review the
[contribution guidelines](CONTRIBUTING.md). This project adheres to Plexflo's
[code of conduct](CODE_OF_CONDUCT.md). By participating, you are expected to
uphold this code.

## Resources

* [About Us](https://www.plexflo.com/aboutus)
* [Blog](https://www.plexflo.com/blog)
* [Whitepapers](https://www.plexflo.com/whitepapers)
* [Contact Us](https://www.plexflo.com/contact-us)

## License
[MIT License](LICENSE)
