import * as cloudfront from '@aws-cdk/aws-cloudfront';
import * as s3 from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
import { Domain } from '../api';
import { PackageStats } from '../backend/package-stats';
import { Monitoring } from '../monitoring';
import { WebappConfigProps } from './config';
/**
 * @experimental
 */
export interface PackageLinkConfig {
    /**
     * (experimental) The name of the link, appears before the ":" on the website.
     *
     * @experimental
     */
    readonly linkLabel: string;
    /**
     * (experimental) The location of the value inside the constructHub.packageLinks key of a module's package.json.
     *
     * @experimental
     */
    readonly configKey: string;
    /**
     * (experimental) optional text to display as the hyperlink text.
     *
     * @default the url of the link
     * @experimental
     */
    readonly linkText?: string;
    /**
     * (experimental) allowList of domains for this link.
     *
     * @default all domains allowed
     * @experimental
     */
    readonly allowedDomains?: string[];
}
/**
 * (experimental) Configuration for packages to feature on the home page.
 *
 * @experimental
 */
export interface FeaturedPackages {
    /**
     * (experimental) Grouped sections of packages on the homepage.
     *
     * @experimental
     */
    readonly sections: FeaturedPackagesSection[];
}
/**
 * (experimental) Customization options for one section of the home page.
 *
 * @experimental
 */
export interface FeaturedPackagesSection {
    /**
     * (experimental) The name of the section (displayed as a header).
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) Show the N most recently updated packages in this section.
     *
     * Cannot be used with `showPackages`.
     *
     * @experimental
     */
    readonly showLastUpdated?: number;
    /**
     * (experimental) Show an explicit list of packages.
     *
     * Cannot be used with `showLastUpdated`.
     *
     * @experimental
     */
    readonly showPackages?: FeaturedPackagesDetail[];
}
/**
 * (experimental) Customization options for a specific package on the home page.
 *
 * @experimental
 */
export interface FeaturedPackagesDetail {
    /**
     * (experimental) The name of the package.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) An additional comment to include with the package.
     *
     * @experimental
     */
    readonly comment?: string;
}
export interface WebAppProps extends WebappConfigProps {
    /**
     * Connect to a domain.
     * @default - uses the default CloudFront domain.
     */
    readonly domain?: Domain;
    /**
     * Monitoring system.
     */
    readonly monitoring: Monitoring;
    /**
     * The bucket containing package data.
     */
    readonly packageData: s3.Bucket;
    /**
     * Manages the `stats.json` file object.
     */
    readonly packageStats?: PackageStats;
}
export declare class WebApp extends Construct {
    readonly bucket: s3.Bucket;
    readonly distribution: cloudfront.Distribution;
    constructor(scope: Construct, id: string, props: WebAppProps);
}
