"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebappConfig = void 0;
const fs_1 = require("fs");
const os_1 = require("os");
const path_1 = require("path");
class WebappConfig {
    constructor(props) {
        this.props = props;
        this.dir = fs_1.mkdtempSync(path_1.join(os_1.tmpdir(), 'chwebapp'));
        this.path = path_1.join(this.dir, 'config.json');
        fs_1.writeFileSync(this.path, JSON.stringify(this.frontendConfig));
    }
    get frontendConfig() {
        var _a;
        return {
            packageLinks: this.packageLinks,
            packageTags: this.packageTags,
            featuredPackages: this.featuredPackages,
            packageStats: (_a = this.props.showPackageStats) !== null && _a !== void 0 ? _a : true,
        };
    }
    get packageLinks() {
        var _a;
        const packageLinks = (_a = this.props.packageLinks) !== null && _a !== void 0 ? _a : [];
        // remove allowed domains from frontend config
        return packageLinks.map(({ allowedDomains, ...rest }) => rest);
    }
    get packageTags() {
        var _a;
        const packageTags = (_a = this.props.packageTags) !== null && _a !== void 0 ? _a : [];
        // remove conditional logic from frontend config
        return packageTags.map(({ condition, ...rest }) => rest);
    }
    get featuredPackages() {
        var _a;
        const config = (_a = this.props.featuredPackages) !== null && _a !== void 0 ? _a : {
            sections: [
                {
                    name: 'Recently updated',
                    showLastUpdated: 10,
                },
            ],
        };
        for (const section of config.sections) {
            if ((section.showPackages !== undefined && section.showLastUpdated !== undefined) ||
                (section.showPackages === undefined && section.showLastUpdated === undefined)) {
                throw new Error('Exactly one of \'showPackages\' and \'showPackages\' should be provided.');
            }
        }
        return config;
    }
}
exports.WebappConfig = WebappConfig;
//# sourceMappingURL=data:application/json;base64,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