import type { Context, SQSEvent } from 'aws-lambda';
/**
 * This function is invoked by the `npm-js-follower.lambda`  with a `PackageVersion` object, or by
 * an SQS trigger feeding from this function's Dead-Letter Queue (for re-trying purposes).
 *
 * The payload contains information about a discovered new package version. This handler will
 * check the package is not deny-listed, download the tarball from the payload's `tarballUrl`, store
 * it in the staging bucket, then send a message to the ConstructHub ingestion SQS queue in order to
 * trigger ingestion of this package.
 */
export declare function handler(event: PackageVersion | SQSEvent, context: Context): Promise<void>;
export interface PackageVersion {
    readonly name: string;
    readonly version: string;
    readonly modified: string;
    readonly tarballUrl: string;
    readonly integrity: string;
    readonly seq: string;
}
