/// <reference types="node" />
import type { IngestionInput } from './ingestion-input.lambda-shared';
/**
 * Computes an integrity checksum for the provided `IngestionInput`.
 *
 * @param input   the `IngestionInput` for which to make a checksum.
 * @param tarball the content of the `.tgz` npm package
 * @param alg     the hash algorithm to use (e.g: 'sha384')
 *
 * @returns the computed checksum.
 */
export declare function integrity(input: Input, tarball: Buffer, alg?: string): IngestionInput;
interface Input extends Omit<IngestionInput, 'integrity'> {
    readonly integrity?: string;
}
export {};
