"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const backend_1 = require("./backend");
const backend_dashboard_1 = require("./backend-dashboard");
const inventory_1 = require("./backend/inventory");
const license_list_1 = require("./backend/license-list");
const orchestration_1 = require("./backend/orchestration");
const constants_1 = require("./backend/shared/constants");
const repository_1 = require("./codeartifact/repository");
const monitoring_1 = require("./monitoring");
const package_sources_1 = require("./package-sources");
const spdx_license_1 = require("./spdx-license");
const webapp_1 = require("./webapp");
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
class ConstructHub extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d, _e, _f, _g;
        super(scope, id);
        const monitoring = new monitoring_1.Monitoring(this, 'Monitoring', {
            alarmActions: props.alarmActions,
        });
        const packageData = new s3.Bucket(this, 'PackageData', {
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            enforceSSL: true,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                // Abort multi-part uploads after 1 day
                { abortIncompleteMultipartUploadAfter: core_1.Duration.days(1) },
                // Transition non-current object versions to IA after 1 month
                { noncurrentVersionTransitions: [{ storageClass: s3.StorageClass.INFREQUENT_ACCESS, transitionAfter: core_1.Duration.days(31) }] },
                // Permanently delete non-current object versions after 3 months
                { noncurrentVersionExpiration: core_1.Duration.days(90), expiredObjectDeleteMarker: true },
                // Permanently delete non-current versions of catalog.json earlier
                { noncurrentVersionExpiration: core_1.Duration.days(7), prefix: constants_1.CATALOG_KEY },
            ],
            versioned: true,
        });
        const codeArtifact = new repository_1.Repository(this, 'CodeArtifact', {
            description: 'Proxy to npmjs.com for ConstructHub',
            domainName: (_b = props.codeArtifactDomain) === null || _b === void 0 ? void 0 : _b.name,
            domainExists: props.codeArtifactDomain != null,
            upstreams: (_c = props.codeArtifactDomain) === null || _c === void 0 ? void 0 : _c.upstreams,
        });
        const vpc = ((_d = props.isolateLambdas) !== null && _d !== void 0 ? _d : true)
            ? new ec2.Vpc(this, 'Lambda-VPC', {
                enableDnsHostnames: true,
                enableDnsSupport: true,
                natGateways: 0,
                // Pre-allocating PUBLIC / PRIVATE / INTERNAL subnets, regardless of use, so we don't create
                // a whole new VPC if we ever need to introduce subnets of these types.
                subnetConfiguration: [
                    // If there is a PRIVATE subnet, there must also have a PUBLIC subnet (for NAT gateways).
                    { name: 'Public', subnetType: ec2.SubnetType.PUBLIC, reserved: true },
                    { name: 'Private', subnetType: ec2.SubnetType.PRIVATE, reserved: true },
                    { name: 'Isolated', subnetType: ec2.SubnetType.ISOLATED },
                ],
            })
            : undefined;
        // We'll only use VPC endpoints if we are configured to run in an ISOLATED subnet.
        const vpcEndpoints = vpc && {
            codeArtifactApi: vpc.addInterfaceEndpoint('CodeArtifact.API', {
                privateDnsEnabled: false,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.api'),
                subnets: { subnetType: ec2.SubnetType.ISOLATED },
            }),
            codeArtifact: vpc.addInterfaceEndpoint('CodeArtifact', {
                privateDnsEnabled: true,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.repositories'),
                subnets: { subnetType: ec2.SubnetType.ISOLATED },
            }),
            s3: vpc.addGatewayEndpoint('S3', {
                service: ec2.GatewayVpcEndpointAwsService.S3,
                subnets: [{ subnetType: ec2.SubnetType.ISOLATED }],
            }),
        };
        // The S3 access is necessary for the CodeArtifact VPC endpoint to be used.
        vpcEndpoints === null || vpcEndpoints === void 0 ? void 0 : vpcEndpoints.s3.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['s3:GetObject'],
            resources: [`${codeArtifact.s3BucketArn}/*`],
            principals: [new aws_iam_1.AnyPrincipal()],
            sid: 'Allow-CodeArtifact-Bucket',
        }));
        const denyList = new backend_1.DenyList(this, 'DenyList', {
            rules: (_e = props.denyList) !== null && _e !== void 0 ? _e : [],
            packageDataBucket: packageData,
            packageDataKeyPrefix: constants_1.STORAGE_KEY_PREFIX,
            monitoring: monitoring,
        });
        const orchestration = new orchestration_1.Orchestration(this, 'Orchestration', {
            bucket: packageData,
            codeArtifact,
            denyList,
            monitoring,
            vpc,
            vpcEndpoints,
            vpcSubnets: { subnetType: ec2.SubnetType.ISOLATED },
        });
        // rebuild the catalog when the deny list changes.
        denyList.prune.onChangeInvoke(orchestration.catalogBuilder);
        this.ingestion = new backend_1.Ingestion(this, 'Ingestion', { bucket: packageData, orchestration, monitoring });
        const licenseList = new license_list_1.LicenseList(this, 'LicenseList', {
            licenses: (_f = props.allowedLicenses) !== null && _f !== void 0 ? _f : [...spdx_license_1.SpdxLicense.apache(), ...spdx_license_1.SpdxLicense.bsd(), ...spdx_license_1.SpdxLicense.mit()],
        });
        const inventory = new inventory_1.Inventory(this, 'InventoryCanary', { bucket: packageData, monitoring });
        const sources = new core_1.Construct(this, 'Sources');
        const packageSources = ((_g = props.packageSources) !== null && _g !== void 0 ? _g : [new package_sources_1.NpmJs()])
            .map(source => source.bind(sources, {
            denyList,
            ingestion: this.ingestion,
            licenseList,
            monitoring,
            queue: this.ingestion.queue,
            repository: codeArtifact,
        }));
        new backend_dashboard_1.BackendDashboard(this, 'BackendDashboard', {
            packageData,
            dashboardName: props.backendDashboardName,
            packageSources,
            ingestion: this.ingestion,
            inventory,
            orchestration,
            denyList,
        });
        new webapp_1.WebApp(this, 'WebApp', {
            domain: props.domain,
            monitoring,
            packageData,
        });
    }
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal() {
        return this.ingestion.grantPrincipal;
    }
    /**
     * @experimental
     */
    get ingestionQueue() {
        return this.ingestion.queue;
    }
}
exports.ConstructHub = ConstructHub;
_a = JSII_RTTI_SYMBOL_1;
ConstructHub[_a] = { fqn: "construct-hub.ConstructHub", version: "0.1.177" };
//# sourceMappingURL=data:application/json;base64,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