"use strict";
/* istanbul ignore file */
Object.defineProperty(exports, "__esModule", { value: true });
exports.safeMock = void 0;
/**
 * Creates a value of the given type, from a partial value thereof. Attempting
 * to use a property that was not part of the partial value, and is not a
 * "standard" feature (such as toJSON, assymmetricMatch, ...) results in a test
 * failure.
 *
 * @param name the name of the mock object.
 * @param partial the partial value to base the mock object on.
 *
 * @returns a new mock instance of T.
 */
function safeMock(mockName, partial) {
    partial[MOCK_NAME] = mockName;
    return new Proxy(partial, PROXY_HANDLER);
}
exports.safeMock = safeMock;
const MOCK_NAME = Symbol('$mock-name$');
const ALWAYS_PASS_THROUGH = new Set([
    'asymmetricMatch',
    'then',
    'toJSON',
]);
const PROXY_HANDLER = {
    get: (target, name) => {
        if (name in target || typeof name !== 'string' || ALWAYS_PASS_THROUGH.has(name)) {
            return target[name];
        }
        // Throw if we try to use a property or method that was not mocked.
        throw new TypeError(`Attempted to use un-mocked property ${name} on ${target[MOCK_NAME]}`);
    },
};
//# sourceMappingURL=data:application/json;base64,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