/**
 * Creates a value of the given type, from a partial value thereof. Attempting
 * to use a property that was not part of the partial value, and is not a
 * "standard" feature (such as toJSON, assymmetricMatch, ...) results in a test
 * failure.
 *
 * @param name the name of the mock object.
 * @param partial the partial value to base the mock object on.
 *
 * @returns a new mock instance of T.
 */
export declare function safeMock<T extends object>(mockName: string, partial: Partial<T>): T;
