"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevStack = void 0;
const process = require("process");
const core_1 = require("@aws-cdk/core");
const __1 = require("../..");
class DevStack extends core_1.Stack {
    constructor(scope, id, { isolateLambdas = !!process.env.ISOLATE_LAMBDAS } = {}) {
        super(scope, id, {
            env: {
                account: process.env.CDK_DEFAULT_ACCOUNT,
                region: process.env.CDK_DEFAULT_REGION,
            },
        });
        new __1.ConstructHub(this, 'ConstructHub', {
            denyList: [
                { packageName: '@aws-cdk/cdk', reason: 'This package has been deprecated in favor of @aws-cdk/core' },
                { packageName: 'cdk-foo-bar', reason: 'Dummy package' },
                { packageName: 'cdk-lambda-subminute', version: '0.1.31', reason: 'test' },
                { packageName: 'cdk-ecr-image-scan-notify', version: '0.0.192', reason: 'test number 2' },
            ],
            backendDashboardName: 'construct-hub-backend',
            isolateLambdas,
        });
    }
}
exports.DevStack = DevStack;
//# sourceMappingURL=data:application/json;base64,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