"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const aws_certificatemanager_1 = require("@aws-cdk/aws-certificatemanager");
const aws_route53_1 = require("@aws-cdk/aws-route53");
const core_1 = require("@aws-cdk/core");
const construct_hub_1 = require("../construct-hub");
const dummyAlarmAction = {
    highSeverity: 'arn:aws:sns:us-east-1:123456789012:mystack-mytopic-NZJ5JSMVGFIE',
};
test('minimal usage', () => {
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'Test');
    new construct_hub_1.ConstructHub(stack, 'ConstructHub', {
        alarmActions: dummyAlarmAction,
    });
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
test('piggy-backing on an existing CodeArtifact domain', () => {
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'Test');
    new construct_hub_1.ConstructHub(stack, 'ConstructHub', {
        alarmActions: dummyAlarmAction,
        codeArtifactDomain: {
            name: 'existing-domain-name',
            upstreams: ['repo-1', 'repo-2'],
        },
    });
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
test('with non-isolated lambdas', () => {
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'Test');
    new construct_hub_1.ConstructHub(stack, 'ConstructHub', {
        alarmActions: dummyAlarmAction,
        isolateLambdas: false,
    });
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
test('with domain', () => {
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'Test');
    const zone = aws_route53_1.PublicHostedZone.fromHostedZoneAttributes(stack, 'Zone', {
        hostedZoneId: 'ZONEID',
        zoneName: 'my.construct.hub',
    });
    const cert = new aws_certificatemanager_1.DnsValidatedCertificate(stack, 'Cert', { hostedZone: zone, domainName: zone.zoneName });
    new construct_hub_1.ConstructHub(stack, 'ConstructHub', {
        domain: {
            zone, cert,
        },
        alarmActions: dummyAlarmAction,
    });
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
//# sourceMappingURL=data:application/json;base64,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