# coding: utf-8

"""
    Corpus Processing Service (CPS) API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from deepsearch.cps.apis.public.api_client import ApiClient
from deepsearch.cps.apis.public.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ProjectApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_project_default_values(self, proj_key, **kwargs):  # noqa: E501
        """get_project_default_values  # noqa: E501

        List project's default values  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_default_values(proj_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ProjectDefaultValues
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_project_default_values_with_http_info(proj_key, **kwargs)  # noqa: E501

    def get_project_default_values_with_http_info(self, proj_key, **kwargs):  # noqa: E501
        """get_project_default_values  # noqa: E501

        List project's default values  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_default_values_with_http_info(proj_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ProjectDefaultValues, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_default_values" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `get_project_default_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/default_values', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProjectDefaultValues',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def provision_project_packages(self, proj_key, **kwargs):  # noqa: E501
        """provision_project_packages  # noqa: E501

        Install packages on a project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.provision_project_packages(proj_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param ProjectPackageInstalationManifest body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.provision_project_packages_with_http_info(proj_key, **kwargs)  # noqa: E501

    def provision_project_packages_with_http_info(self, proj_key, **kwargs):  # noqa: E501
        """provision_project_packages  # noqa: E501

        Install packages on a project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.provision_project_packages_with_http_info(proj_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param ProjectPackageInstalationManifest body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Task, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method provision_project_packages" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `provision_project_packages`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/packages', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Task',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_project_default_values(self, proj_key, default_values, **kwargs):  # noqa: E501
        """update_project_default_values  # noqa: E501

        List project's default values  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_default_values(proj_key, default_values, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param ProjectDefaultValues default_values: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_project_default_values_with_http_info(proj_key, default_values, **kwargs)  # noqa: E501

    def update_project_default_values_with_http_info(self, proj_key, default_values, **kwargs):  # noqa: E501
        """update_project_default_values  # noqa: E501

        List project's default values  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_default_values_with_http_info(proj_key, default_values, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param ProjectDefaultValues default_values: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'default_values'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_default_values" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `update_project_default_values`")  # noqa: E501
        # verify the required parameter 'default_values' is set
        if self.api_client.client_side_validation and ('default_values' not in local_var_params or  # noqa: E501
                                                        local_var_params['default_values'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `default_values` when calling `update_project_default_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'default_values' in local_var_params:
            body_params = local_var_params['default_values']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/default_values', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
