# coding: utf-8

"""
    Corpus Processing Service (CPS) API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from deepsearch.cps.apis.public.api_client import ApiClient
from deepsearch.cps.apis.public.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ElasticApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_elastic_domains(self, **kwargs):  # noqa: E501
        """get_elastic_domains  # noqa: E501

        List system elastic domains.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_elastic_domains(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_elastic_domains_with_http_info(**kwargs)  # noqa: E501

    def get_elastic_domains_with_http_info(self, **kwargs):  # noqa: E501
        """get_elastic_domains  # noqa: E501

        List system elastic domains.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_elastic_domains_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_elastic_domains" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/elastic/domains', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_elastic_query_max_size(self, **kwargs):  # noqa: E501
        """get_elastic_query_max_size  # noqa: E501

        Get the system maximum workable elastic query size.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_elastic_query_max_size(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_elastic_query_max_size_with_http_info(**kwargs)  # noqa: E501

    def get_elastic_query_max_size_with_http_info(self, **kwargs):  # noqa: E501
        """get_elastic_query_max_size  # noqa: E501

        Get the system maximum workable elastic query size.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_elastic_query_max_size_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse200, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_elastic_query_max_size" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/elastic/query_max_size', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_index_search_results(self, elastic_instance, elastic_index, parameters, **kwargs):  # noqa: E501
        """get_index_search_results  # noqa: E501

        List elastic index search results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_index_search_results(elastic_instance, elastic_index, parameters, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str elastic_instance: (required)
        :param str elastic_index: (required)
        :param dict(str, object) parameters: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ElasticIndexSearchResults
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_index_search_results_with_http_info(elastic_instance, elastic_index, parameters, **kwargs)  # noqa: E501

    def get_index_search_results_with_http_info(self, elastic_instance, elastic_index, parameters, **kwargs):  # noqa: E501
        """get_index_search_results  # noqa: E501

        List elastic index search results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_index_search_results_with_http_info(elastic_instance, elastic_index, parameters, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str elastic_instance: (required)
        :param str elastic_index: (required)
        :param dict(str, object) parameters: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ElasticIndexSearchResults, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'elastic_instance',
            'elastic_index',
            'parameters'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_index_search_results" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'elastic_instance' is set
        if self.api_client.client_side_validation and ('elastic_instance' not in local_var_params or  # noqa: E501
                                                        local_var_params['elastic_instance'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `elastic_instance` when calling `get_index_search_results`")  # noqa: E501
        # verify the required parameter 'elastic_index' is set
        if self.api_client.client_side_validation and ('elastic_index' not in local_var_params or  # noqa: E501
                                                        local_var_params['elastic_index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `elastic_index` when calling `get_index_search_results`")  # noqa: E501
        # verify the required parameter 'parameters' is set
        if self.api_client.client_side_validation and ('parameters' not in local_var_params or  # noqa: E501
                                                        local_var_params['parameters'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `parameters` when calling `get_index_search_results`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'elastic_instance' in local_var_params:
            path_params['elastic_instance'] = local_var_params['elastic_instance']  # noqa: E501
        if 'elastic_index' in local_var_params:
            path_params['elastic_index'] = local_var_params['elastic_index']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'parameters' in local_var_params:
            body_params = local_var_params['parameters']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/elastic/{elastic_instance}/{elastic_index}/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ElasticIndexSearchResults',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_kibana_saved_queries(self, elastic_instance, elastic_index, **kwargs):  # noqa: E501
        """get_kibana_saved_queries  # noqa: E501

        List Kibana saved queries.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kibana_saved_queries(elastic_instance, elastic_index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str elastic_instance: (required)
        :param str elastic_index: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[KibanaSavedQueriesResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_kibana_saved_queries_with_http_info(elastic_instance, elastic_index, **kwargs)  # noqa: E501

    def get_kibana_saved_queries_with_http_info(self, elastic_instance, elastic_index, **kwargs):  # noqa: E501
        """get_kibana_saved_queries  # noqa: E501

        List Kibana saved queries.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kibana_saved_queries_with_http_info(elastic_instance, elastic_index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str elastic_instance: (required)
        :param str elastic_index: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[KibanaSavedQueriesResult], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'elastic_instance',
            'elastic_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_kibana_saved_queries" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'elastic_instance' is set
        if self.api_client.client_side_validation and ('elastic_instance' not in local_var_params or  # noqa: E501
                                                        local_var_params['elastic_instance'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `elastic_instance` when calling `get_kibana_saved_queries`")  # noqa: E501
        # verify the required parameter 'elastic_index' is set
        if self.api_client.client_side_validation and ('elastic_index' not in local_var_params or  # noqa: E501
                                                        local_var_params['elastic_index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `elastic_index` when calling `get_kibana_saved_queries`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'elastic_instance' in local_var_params:
            path_params['elastic_instance'] = local_var_params['elastic_instance']  # noqa: E501
        if 'elastic_index' in local_var_params:
            path_params['elastic_index'] = local_var_params['elastic_index']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/elastic/{elastic_instance}/{elastic_index}/saved_queries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[KibanaSavedQueriesResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_indices_from_elastic_instance(self, index_type, index_domain, **kwargs):  # noqa: E501
        """list_indices_from_elastic_instance  # noqa: E501

        List of indices for elastic instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_indices_from_elastic_instance(index_type, index_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str index_type: (required)
        :param str index_domain: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DataCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_indices_from_elastic_instance_with_http_info(index_type, index_domain, **kwargs)  # noqa: E501

    def list_indices_from_elastic_instance_with_http_info(self, index_type, index_domain, **kwargs):  # noqa: E501
        """list_indices_from_elastic_instance  # noqa: E501

        List of indices for elastic instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_indices_from_elastic_instance_with_http_info(index_type, index_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str index_type: (required)
        :param str index_domain: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DataCollection], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'index_type',
            'index_domain'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_indices_from_elastic_instance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'index_type' is set
        if self.api_client.client_side_validation and ('index_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['index_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `index_type` when calling `list_indices_from_elastic_instance`")  # noqa: E501
        # verify the required parameter 'index_domain' is set
        if self.api_client.client_side_validation and ('index_domain' not in local_var_params or  # noqa: E501
                                                        local_var_params['index_domain'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `index_domain` when calling `list_indices_from_elastic_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'index_type' in local_var_params:
            path_params['index_type'] = local_var_params['index_type']  # noqa: E501
        if 'index_domain' in local_var_params:
            path_params['index_domain'] = local_var_params['index_domain']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/elastic/indices/{index_type}/{index_domain}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DataCollection]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
