# coding: utf-8

"""
    Corpus Processing Service (CPS) API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from deepsearch.cps.apis.public.api_client import ApiClient
from deepsearch.cps.apis.public.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DictionariesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def clone_project_dictionary(self, proj_key, dict_key, body, **kwargs):  # noqa: E501
        """clone_project_dictionary  # noqa: E501

        Clone an existing dictionary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone_project_dictionary(proj_key, dict_key, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param CloneDictionaryOptions body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DictionaryCloneResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.clone_project_dictionary_with_http_info(proj_key, dict_key, body, **kwargs)  # noqa: E501

    def clone_project_dictionary_with_http_info(self, proj_key, dict_key, body, **kwargs):  # noqa: E501
        """clone_project_dictionary  # noqa: E501

        Clone an existing dictionary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone_project_dictionary_with_http_info(proj_key, dict_key, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param CloneDictionaryOptions body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DictionaryCloneResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'dict_key',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clone_project_dictionary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `clone_project_dictionary`")  # noqa: E501
        # verify the required parameter 'dict_key' is set
        if self.api_client.client_side_validation and ('dict_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['dict_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dict_key` when calling `clone_project_dictionary`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `clone_project_dictionary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501
        if 'dict_key' in local_var_params:
            path_params['dict_key'] = local_var_params['dict_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/dictionaries/{dict_key}/actions/clone', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DictionaryCloneResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def clone_public_dictionary(self, dict_key, body, **kwargs):  # noqa: E501
        """clone_public_dictionary  # noqa: E501

        Clone an existing public dictionary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone_public_dictionary(dict_key, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str dict_key: (required)
        :param ClonePublicDictionaryOptions body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DictionaryCloneResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.clone_public_dictionary_with_http_info(dict_key, body, **kwargs)  # noqa: E501

    def clone_public_dictionary_with_http_info(self, dict_key, body, **kwargs):  # noqa: E501
        """clone_public_dictionary  # noqa: E501

        Clone an existing public dictionary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone_public_dictionary_with_http_info(dict_key, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str dict_key: (required)
        :param ClonePublicDictionaryOptions body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DictionaryCloneResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'dict_key',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clone_public_dictionary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'dict_key' is set
        if self.api_client.client_side_validation and ('dict_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['dict_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dict_key` when calling `clone_public_dictionary`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `clone_public_dictionary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dict_key' in local_var_params:
            path_params['dict_key'] = local_var_params['dict_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/public/dictionaries/{dict_key}/actions/clone', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DictionaryCloneResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_project_dictionary(self, proj_key, body, **kwargs):  # noqa: E501
        """create_project_dictionary  # noqa: E501

        Create an empty dictionary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_dictionary(proj_key, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param CreateDictionaryOptions body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Dictionary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_project_dictionary_with_http_info(proj_key, body, **kwargs)  # noqa: E501

    def create_project_dictionary_with_http_info(self, proj_key, body, **kwargs):  # noqa: E501
        """create_project_dictionary  # noqa: E501

        Create an empty dictionary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_dictionary_with_http_info(proj_key, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param CreateDictionaryOptions body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Dictionary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_dictionary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `create_project_dictionary`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `create_project_dictionary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/dictionaries', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dictionary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_project_dictionary_collection(self, proj_key, dict_key, body, **kwargs):  # noqa: E501
        """create_project_dictionary_collection  # noqa: E501

        Create a collection in a dictionary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_dictionary_collection(proj_key, dict_key, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param CreateCollectionInDictionaryOptions body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_project_dictionary_collection_with_http_info(proj_key, dict_key, body, **kwargs)  # noqa: E501

    def create_project_dictionary_collection_with_http_info(self, proj_key, dict_key, body, **kwargs):  # noqa: E501
        """create_project_dictionary_collection  # noqa: E501

        Create a collection in a dictionary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_dictionary_collection_with_http_info(proj_key, dict_key, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param CreateCollectionInDictionaryOptions body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'dict_key',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_dictionary_collection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `create_project_dictionary_collection`")  # noqa: E501
        # verify the required parameter 'dict_key' is set
        if self.api_client.client_side_validation and ('dict_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['dict_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dict_key` when calling `create_project_dictionary_collection`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `create_project_dictionary_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501
        if 'dict_key' in local_var_params:
            path_params['dict_key'] = local_var_params['dict_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/dictionaries/{dict_key}/collections', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_project_dictionary_delete_token(self, proj_key, dict_key, **kwargs):  # noqa: E501
        """create_project_dictionary_delete_token  # noqa: E501

        Get a token used to confirm the deletion of a dictionary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_dictionary_delete_token(proj_key, dict_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_project_dictionary_delete_token_with_http_info(proj_key, dict_key, **kwargs)  # noqa: E501

    def create_project_dictionary_delete_token_with_http_info(self, proj_key, dict_key, **kwargs):  # noqa: E501
        """create_project_dictionary_delete_token  # noqa: E501

        Get a token used to confirm the deletion of a dictionary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_dictionary_delete_token_with_http_info(proj_key, dict_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TokenResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'dict_key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_dictionary_delete_token" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `create_project_dictionary_delete_token`")  # noqa: E501
        # verify the required parameter 'dict_key' is set
        if self.api_client.client_side_validation and ('dict_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['dict_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dict_key` when calling `create_project_dictionary_delete_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501
        if 'dict_key' in local_var_params:
            path_params['dict_key'] = local_var_params['dict_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/dictionaries/{dict_key}/delete_token', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TokenResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_project_dictionary(self, proj_key, dict_key, confirmation_token, **kwargs):  # noqa: E501
        """delete_project_dictionary  # noqa: E501

        Delete a single dictionary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_dictionary(proj_key, dict_key, confirmation_token, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param str confirmation_token: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_project_dictionary_with_http_info(proj_key, dict_key, confirmation_token, **kwargs)  # noqa: E501

    def delete_project_dictionary_with_http_info(self, proj_key, dict_key, confirmation_token, **kwargs):  # noqa: E501
        """delete_project_dictionary  # noqa: E501

        Delete a single dictionary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_dictionary_with_http_info(proj_key, dict_key, confirmation_token, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param str confirmation_token: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'dict_key',
            'confirmation_token'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project_dictionary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `delete_project_dictionary`")  # noqa: E501
        # verify the required parameter 'dict_key' is set
        if self.api_client.client_side_validation and ('dict_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['dict_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dict_key` when calling `delete_project_dictionary`")  # noqa: E501
        # verify the required parameter 'confirmation_token' is set
        if self.api_client.client_side_validation and ('confirmation_token' not in local_var_params or  # noqa: E501
                                                        local_var_params['confirmation_token'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `confirmation_token` when calling `delete_project_dictionary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501
        if 'dict_key' in local_var_params:
            path_params['dict_key'] = local_var_params['dict_key']  # noqa: E501

        query_params = []
        if 'confirmation_token' in local_var_params and local_var_params['confirmation_token'] is not None:  # noqa: E501
            query_params.append(('confirmation_token', local_var_params['confirmation_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/dictionaries/{dict_key}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_project_dictionary_collection(self, proj_key, dict_key, collection_name, **kwargs):  # noqa: E501
        """delete_project_dictionary_collection  # noqa: E501

        Delete a single dictionary's collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_dictionary_collection(proj_key, dict_key, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param str collection_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_project_dictionary_collection_with_http_info(proj_key, dict_key, collection_name, **kwargs)  # noqa: E501

    def delete_project_dictionary_collection_with_http_info(self, proj_key, dict_key, collection_name, **kwargs):  # noqa: E501
        """delete_project_dictionary_collection  # noqa: E501

        Delete a single dictionary's collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_dictionary_collection_with_http_info(proj_key, dict_key, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param str collection_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'dict_key',
            'collection_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project_dictionary_collection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `delete_project_dictionary_collection`")  # noqa: E501
        # verify the required parameter 'dict_key' is set
        if self.api_client.client_side_validation and ('dict_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['dict_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dict_key` when calling `delete_project_dictionary_collection`")  # noqa: E501
        # verify the required parameter 'collection_name' is set
        if self.api_client.client_side_validation and ('collection_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['collection_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `collection_name` when calling `delete_project_dictionary_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501
        if 'dict_key' in local_var_params:
            path_params['dict_key'] = local_var_params['dict_key']  # noqa: E501
        if 'collection_name' in local_var_params:
            path_params['collection_name'] = local_var_params['collection_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/dictionaries/{dict_key}/collections/{collection_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_project_dictionary_collection_data(self, proj_key, dict_key, collection_name, **kwargs):  # noqa: E501
        """export_project_dictionary_collection_data  # noqa: E501

        Export the contents of a dictionary's collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_project_dictionary_collection_data(proj_key, dict_key, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param str collection_name: (required)
        :param str file_format:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.export_project_dictionary_collection_data_with_http_info(proj_key, dict_key, collection_name, **kwargs)  # noqa: E501

    def export_project_dictionary_collection_data_with_http_info(self, proj_key, dict_key, collection_name, **kwargs):  # noqa: E501
        """export_project_dictionary_collection_data  # noqa: E501

        Export the contents of a dictionary's collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_project_dictionary_collection_data_with_http_info(proj_key, dict_key, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param str collection_name: (required)
        :param str file_format:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'dict_key',
            'collection_name',
            'file_format'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_project_dictionary_collection_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `export_project_dictionary_collection_data`")  # noqa: E501
        # verify the required parameter 'dict_key' is set
        if self.api_client.client_side_validation and ('dict_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['dict_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dict_key` when calling `export_project_dictionary_collection_data`")  # noqa: E501
        # verify the required parameter 'collection_name' is set
        if self.api_client.client_side_validation and ('collection_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['collection_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `collection_name` when calling `export_project_dictionary_collection_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501
        if 'dict_key' in local_var_params:
            path_params['dict_key'] = local_var_params['dict_key']  # noqa: E501
        if 'collection_name' in local_var_params:
            path_params['collection_name'] = local_var_params['collection_name']  # noqa: E501

        query_params = []
        if 'file_format' in local_var_params and local_var_params['file_format'] is not None:  # noqa: E501
            query_params.append(('file_format', local_var_params['file_format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/dictionaries/{dict_key}/collections/{collection_name}/actions/export', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_project_dictionary_data(self, proj_key, dict_key, **kwargs):  # noqa: E501
        """export_project_dictionary_data  # noqa: E501

        Export the contents of a dictionary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_project_dictionary_data(proj_key, dict_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.export_project_dictionary_data_with_http_info(proj_key, dict_key, **kwargs)  # noqa: E501

    def export_project_dictionary_data_with_http_info(self, proj_key, dict_key, **kwargs):  # noqa: E501
        """export_project_dictionary_data  # noqa: E501

        Export the contents of a dictionary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_project_dictionary_data_with_http_info(proj_key, dict_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'dict_key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_project_dictionary_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `export_project_dictionary_data`")  # noqa: E501
        # verify the required parameter 'dict_key' is set
        if self.api_client.client_side_validation and ('dict_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['dict_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dict_key` when calling `export_project_dictionary_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501
        if 'dict_key' in local_var_params:
            path_params['dict_key'] = local_var_params['dict_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/dictionaries/{dict_key}/actions/export', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_dictionary(self, proj_key, dict_key, **kwargs):  # noqa: E501
        """get_project_dictionary  # noqa: E501

        Get a single dictionary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_dictionary(proj_key, dict_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param bool include_collections:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Dictionary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_project_dictionary_with_http_info(proj_key, dict_key, **kwargs)  # noqa: E501

    def get_project_dictionary_with_http_info(self, proj_key, dict_key, **kwargs):  # noqa: E501
        """get_project_dictionary  # noqa: E501

        Get a single dictionary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_dictionary_with_http_info(proj_key, dict_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param bool include_collections:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Dictionary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'dict_key',
            'include_collections'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_dictionary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `get_project_dictionary`")  # noqa: E501
        # verify the required parameter 'dict_key' is set
        if self.api_client.client_side_validation and ('dict_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['dict_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dict_key` when calling `get_project_dictionary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501
        if 'dict_key' in local_var_params:
            path_params['dict_key'] = local_var_params['dict_key']  # noqa: E501

        query_params = []
        if 'include_collections' in local_var_params and local_var_params['include_collections'] is not None:  # noqa: E501
            query_params.append(('include_collections', local_var_params['include_collections']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/dictionaries/{dict_key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dictionary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_dictionary_collection_data(self, proj_key, dict_key, collection_name, **kwargs):  # noqa: E501
        """get_project_dictionary_collection_data  # noqa: E501

        Get a preview of the data in a dictionary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_dictionary_collection_data(proj_key, dict_key, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param str collection_name: (required)
        :param str after:
        :param int limit:
        :param str response_format:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_project_dictionary_collection_data_with_http_info(proj_key, dict_key, collection_name, **kwargs)  # noqa: E501

    def get_project_dictionary_collection_data_with_http_info(self, proj_key, dict_key, collection_name, **kwargs):  # noqa: E501
        """get_project_dictionary_collection_data  # noqa: E501

        Get a preview of the data in a dictionary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_dictionary_collection_data_with_http_info(proj_key, dict_key, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param str collection_name: (required)
        :param str after:
        :param int limit:
        :param str response_format:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'dict_key',
            'collection_name',
            'after',
            'limit',
            'response_format'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_dictionary_collection_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `get_project_dictionary_collection_data`")  # noqa: E501
        # verify the required parameter 'dict_key' is set
        if self.api_client.client_side_validation and ('dict_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['dict_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dict_key` when calling `get_project_dictionary_collection_data`")  # noqa: E501
        # verify the required parameter 'collection_name' is set
        if self.api_client.client_side_validation and ('collection_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['collection_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `collection_name` when calling `get_project_dictionary_collection_data`")  # noqa: E501

        if self.api_client.client_side_validation and 'after' in local_var_params and not re.search(r'[a-zA-Z0-9]{24}', local_var_params['after']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `after` when calling `get_project_dictionary_collection_data`, must conform to the pattern `/[a-zA-Z0-9]{24}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_project_dictionary_collection_data`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501
        if 'dict_key' in local_var_params:
            path_params['dict_key'] = local_var_params['dict_key']  # noqa: E501
        if 'collection_name' in local_var_params:
            path_params['collection_name'] = local_var_params['collection_name']  # noqa: E501

        query_params = []
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'response_format' in local_var_params and local_var_params['response_format'] is not None:  # noqa: E501
            query_params.append(('response_format', local_var_params['response_format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/dictionaries/{dict_key}/collections/{collection_name}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_public_dictionary(self, dict_key, **kwargs):  # noqa: E501
        """get_public_dictionary  # noqa: E501

        Get a single dictionary that was made public  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_public_dictionary(dict_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str dict_key: (required)
        :param bool include_collections:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Dictionary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_public_dictionary_with_http_info(dict_key, **kwargs)  # noqa: E501

    def get_public_dictionary_with_http_info(self, dict_key, **kwargs):  # noqa: E501
        """get_public_dictionary  # noqa: E501

        Get a single dictionary that was made public  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_public_dictionary_with_http_info(dict_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str dict_key: (required)
        :param bool include_collections:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Dictionary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'dict_key',
            'include_collections'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_dictionary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'dict_key' is set
        if self.api_client.client_side_validation and ('dict_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['dict_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dict_key` when calling `get_public_dictionary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dict_key' in local_var_params:
            path_params['dict_key'] = local_var_params['dict_key']  # noqa: E501

        query_params = []
        if 'include_collections' in local_var_params and local_var_params['include_collections'] is not None:  # noqa: E501
            query_params.append(('include_collections', local_var_params['include_collections']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/public/dictionaries/{dict_key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dictionary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_project_dictionary_from_mongo(self, proj_key, body, **kwargs):  # noqa: E501
        """import_project_dictionary_from_mongo  # noqa: E501

        Create a dictionary from a mongo database  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_project_dictionary_from_mongo(proj_key, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param DictionaryImportOptions body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DictionaryImportResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.import_project_dictionary_from_mongo_with_http_info(proj_key, body, **kwargs)  # noqa: E501

    def import_project_dictionary_from_mongo_with_http_info(self, proj_key, body, **kwargs):  # noqa: E501
        """import_project_dictionary_from_mongo  # noqa: E501

        Create a dictionary from a mongo database  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_project_dictionary_from_mongo_with_http_info(proj_key, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param DictionaryImportOptions body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DictionaryImportResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_project_dictionary_from_mongo" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `import_project_dictionary_from_mongo`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `import_project_dictionary_from_mongo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/dictionaries/from_mongo', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DictionaryImportResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_project_dictionaries(self, proj_key, **kwargs):  # noqa: E501
        """list_project_dictionaries  # noqa: E501

        List dictionaries for a project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_project_dictionaries(proj_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str query:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Dictionary]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_project_dictionaries_with_http_info(proj_key, **kwargs)  # noqa: E501

    def list_project_dictionaries_with_http_info(self, proj_key, **kwargs):  # noqa: E501
        """list_project_dictionaries  # noqa: E501

        List dictionaries for a project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_project_dictionaries_with_http_info(proj_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str query:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Dictionary], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'query'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_dictionaries" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `list_project_dictionaries`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501

        query_params = []
        if 'query' in local_var_params and local_var_params['query'] is not None:  # noqa: E501
            query_params.append(('query', local_var_params['query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/dictionaries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Dictionary]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_project_dictionary_collections(self, proj_key, dict_key, **kwargs):  # noqa: E501
        """list_project_dictionary_collections  # noqa: E501

        Get the collections of a dictionary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_project_dictionary_collections(proj_key, dict_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DictionaryCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_project_dictionary_collections_with_http_info(proj_key, dict_key, **kwargs)  # noqa: E501

    def list_project_dictionary_collections_with_http_info(self, proj_key, dict_key, **kwargs):  # noqa: E501
        """list_project_dictionary_collections  # noqa: E501

        Get the collections of a dictionary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_project_dictionary_collections_with_http_info(proj_key, dict_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DictionaryCollection], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'dict_key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_dictionary_collections" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `list_project_dictionary_collections`")  # noqa: E501
        # verify the required parameter 'dict_key' is set
        if self.api_client.client_side_validation and ('dict_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['dict_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dict_key` when calling `list_project_dictionary_collections`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501
        if 'dict_key' in local_var_params:
            path_params['dict_key'] = local_var_params['dict_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/dictionaries/{dict_key}/collections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DictionaryCollection]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_public_dictionaries(self, **kwargs):  # noqa: E501
        """list_public_dictionaries  # noqa: E501

        List public dictionaries  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_public_dictionaries(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str query:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Dictionary]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_public_dictionaries_with_http_info(**kwargs)  # noqa: E501

    def list_public_dictionaries_with_http_info(self, **kwargs):  # noqa: E501
        """list_public_dictionaries  # noqa: E501

        List public dictionaries  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_public_dictionaries_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str query:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Dictionary], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'query'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_public_dictionaries" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'query' in local_var_params and local_var_params['query'] is not None:  # noqa: E501
            query_params.append(('query', local_var_params['query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/public/dictionaries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Dictionary]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_public_dictionary_collections(self, dict_key, **kwargs):  # noqa: E501
        """list_public_dictionary_collections  # noqa: E501

        Get the collections of a dictionary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_public_dictionary_collections(dict_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str dict_key: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DictionaryCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_public_dictionary_collections_with_http_info(dict_key, **kwargs)  # noqa: E501

    def list_public_dictionary_collections_with_http_info(self, dict_key, **kwargs):  # noqa: E501
        """list_public_dictionary_collections  # noqa: E501

        Get the collections of a dictionary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_public_dictionary_collections_with_http_info(dict_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str dict_key: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DictionaryCollection], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'dict_key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_public_dictionary_collections" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'dict_key' is set
        if self.api_client.client_side_validation and ('dict_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['dict_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dict_key` when calling `list_public_dictionary_collections`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dict_key' in local_var_params:
            path_params['dict_key'] = local_var_params['dict_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/public/dictionaries/{dict_key}/collections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DictionaryCollection]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_project_dictionary(self, proj_key, dict_key, options, **kwargs):  # noqa: E501
        """update_project_dictionary  # noqa: E501

        Update the metadata of a dictionary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_dictionary(proj_key, dict_key, options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param PatchDictionaryOptions options: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Dictionary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_project_dictionary_with_http_info(proj_key, dict_key, options, **kwargs)  # noqa: E501

    def update_project_dictionary_with_http_info(self, proj_key, dict_key, options, **kwargs):  # noqa: E501
        """update_project_dictionary  # noqa: E501

        Update the metadata of a dictionary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_dictionary_with_http_info(proj_key, dict_key, options, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param PatchDictionaryOptions options: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Dictionary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'dict_key',
            'options'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_dictionary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `update_project_dictionary`")  # noqa: E501
        # verify the required parameter 'dict_key' is set
        if self.api_client.client_side_validation and ('dict_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['dict_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dict_key` when calling `update_project_dictionary`")  # noqa: E501
        # verify the required parameter 'options' is set
        if self.api_client.client_side_validation and ('options' not in local_var_params or  # noqa: E501
                                                        local_var_params['options'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `options` when calling `update_project_dictionary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501
        if 'dict_key' in local_var_params:
            path_params['dict_key'] = local_var_params['dict_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'options' in local_var_params:
            body_params = local_var_params['options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/dictionaries/{dict_key}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dictionary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_project_dictionary_collection_data(self, proj_key, dict_key, collection_name, body, **kwargs):  # noqa: E501
        """update_project_dictionary_collection_data  # noqa: E501

        Update the data in a dictionary's collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_dictionary_collection_data(proj_key, dict_key, collection_name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param str collection_name: (required)
        :param list[DictionaryCollectionPatch] body: A subset of JSON Patch operation list. Only `add`, `replace`, and `remove` is supported. See http://jsonpatch.com/ for more details.  (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_project_dictionary_collection_data_with_http_info(proj_key, dict_key, collection_name, body, **kwargs)  # noqa: E501

    def update_project_dictionary_collection_data_with_http_info(self, proj_key, dict_key, collection_name, body, **kwargs):  # noqa: E501
        """update_project_dictionary_collection_data  # noqa: E501

        Update the data in a dictionary's collection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_dictionary_collection_data_with_http_info(proj_key, dict_key, collection_name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param str collection_name: (required)
        :param list[DictionaryCollectionPatch] body: A subset of JSON Patch operation list. Only `add`, `replace`, and `remove` is supported. See http://jsonpatch.com/ for more details.  (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'dict_key',
            'collection_name',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_dictionary_collection_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `update_project_dictionary_collection_data`")  # noqa: E501
        # verify the required parameter 'dict_key' is set
        if self.api_client.client_side_validation and ('dict_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['dict_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dict_key` when calling `update_project_dictionary_collection_data`")  # noqa: E501
        # verify the required parameter 'collection_name' is set
        if self.api_client.client_side_validation and ('collection_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['collection_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `collection_name` when calling `update_project_dictionary_collection_data`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `update_project_dictionary_collection_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501
        if 'dict_key' in local_var_params:
            path_params['dict_key'] = local_var_params['dict_key']  # noqa: E501
        if 'collection_name' in local_var_params:
            path_params['collection_name'] = local_var_params['collection_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/dictionaries/{dict_key}/collections/{collection_name}/data', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_project_dictionary_collection_data(self, proj_key, dict_key, collection_name, file, **kwargs):  # noqa: E501
        """upload_project_dictionary_collection_data  # noqa: E501

        Upload data to a dictionary collection. The collection will be created if it doesn't exist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_project_dictionary_collection_data(proj_key, dict_key, collection_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param str collection_name: (required)
        :param file file: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.upload_project_dictionary_collection_data_with_http_info(proj_key, dict_key, collection_name, file, **kwargs)  # noqa: E501

    def upload_project_dictionary_collection_data_with_http_info(self, proj_key, dict_key, collection_name, file, **kwargs):  # noqa: E501
        """upload_project_dictionary_collection_data  # noqa: E501

        Upload data to a dictionary collection. The collection will be created if it doesn't exist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_project_dictionary_collection_data_with_http_info(proj_key, dict_key, collection_name, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param str collection_name: (required)
        :param file file: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Task, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'dict_key',
            'collection_name',
            'file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_project_dictionary_collection_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `upload_project_dictionary_collection_data`")  # noqa: E501
        # verify the required parameter 'dict_key' is set
        if self.api_client.client_side_validation and ('dict_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['dict_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dict_key` when calling `upload_project_dictionary_collection_data`")  # noqa: E501
        # verify the required parameter 'collection_name' is set
        if self.api_client.client_side_validation and ('collection_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['collection_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `collection_name` when calling `upload_project_dictionary_collection_data`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `upload_project_dictionary_collection_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501
        if 'dict_key' in local_var_params:
            path_params['dict_key'] = local_var_params['dict_key']  # noqa: E501
        if 'collection_name' in local_var_params:
            path_params['collection_name'] = local_var_params['collection_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/dictionaries/{dict_key}/collections/{collection_name}/actions/upload', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Task',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_project_dictionary_data(self, proj_key, dict_key, file, **kwargs):  # noqa: E501
        """upload_project_dictionary_data  # noqa: E501

        Upload data to a dictionary. The collection name(s) will be inferred from the file name(s).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_project_dictionary_data(proj_key, dict_key, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param file file: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.upload_project_dictionary_data_with_http_info(proj_key, dict_key, file, **kwargs)  # noqa: E501

    def upload_project_dictionary_data_with_http_info(self, proj_key, dict_key, file, **kwargs):  # noqa: E501
        """upload_project_dictionary_data  # noqa: E501

        Upload data to a dictionary. The collection name(s) will be inferred from the file name(s).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_project_dictionary_data_with_http_info(proj_key, dict_key, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str proj_key: (required)
        :param str dict_key: (required)
        :param file file: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Task, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'proj_key',
            'dict_key',
            'file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_project_dictionary_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'proj_key' is set
        if self.api_client.client_side_validation and ('proj_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['proj_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `proj_key` when calling `upload_project_dictionary_data`")  # noqa: E501
        # verify the required parameter 'dict_key' is set
        if self.api_client.client_side_validation and ('dict_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['dict_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dict_key` when calling `upload_project_dictionary_data`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `upload_project_dictionary_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'proj_key' in local_var_params:
            path_params['proj_key'] = local_var_params['proj_key']  # noqa: E501
        if 'dict_key' in local_var_params:
            path_params['dict_key'] = local_var_params['dict_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/project/{proj_key}/dictionaries/{dict_key}/actions/upload', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Task',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
