from validator import utils


def test_utils_01_represents_int():
    assert utils.RepresentsInt("10")
    assert utils.RepresentsInt("0")
    assert utils.RepresentsInt("-10")
    assert utils.RepresentsInt("1123")
    assert utils.RepresentsInt("99999")
    assert utils.RepresentsInt("-99999")
    assert utils.RepresentsInt("+99999")
    assert utils.RepresentsInt("123456789")

    assert utils.RepresentsInt(10)
    assert utils.RepresentsInt(0)
    assert utils.RepresentsInt(-10)
    assert utils.RepresentsInt(1123)
    assert utils.RepresentsInt(99999)
    assert utils.RepresentsInt(-99999)
    assert utils.RepresentsInt(+99999)
    assert utils.RepresentsInt(123456789)

    assert not utils.RepresentsInt("10.0")
    assert not utils.RepresentsInt("0.0")
    assert not utils.RepresentsInt("-10.0")
    assert not utils.RepresentsInt("1.")
    assert not utils.RepresentsInt("asd")
    assert not utils.RepresentsInt("number")
    assert not utils.RepresentsInt("3+6j")
    assert not utils.RepresentsInt("-")
    assert not utils.RepresentsInt("+")

    assert not utils.RepresentsInt(10.0)
    assert not utils.RepresentsInt(0.0)
    assert not utils.RepresentsInt(-10.0)
    assert not utils.RepresentsInt(1.0)
    assert not utils.RepresentsInt(3 + 6j)
    assert not utils.RepresentsInt([])
    assert not utils.RepresentsInt({})
    assert not utils.RepresentsInt(())


def test_utils_02_represents_float():
    assert utils.RepresentsFloat("10")
    assert utils.RepresentsFloat("0")
    assert utils.RepresentsFloat("-10")
    assert utils.RepresentsFloat("1123")
    assert utils.RepresentsFloat("99999")
    assert utils.RepresentsFloat("-99999")
    assert utils.RepresentsFloat("+99999")
    assert utils.RepresentsFloat("123456789")
    assert utils.RepresentsFloat("10.0")
    assert utils.RepresentsFloat("0.0")
    assert utils.RepresentsFloat("-10.0")
    assert utils.RepresentsFloat("1.")

    assert utils.RepresentsFloat(10)
    assert utils.RepresentsFloat(0)
    assert utils.RepresentsFloat(-10)
    assert utils.RepresentsFloat(1123)
    assert utils.RepresentsFloat(99999)
    assert utils.RepresentsFloat(-99999)
    assert utils.RepresentsFloat(+99999)
    assert utils.RepresentsFloat(123456789)
    assert utils.RepresentsFloat(10.0)
    assert utils.RepresentsFloat(0.0)
    assert utils.RepresentsFloat(-10.0)
    assert utils.RepresentsFloat(1.0)

    assert not utils.RepresentsFloat("asd")
    assert not utils.RepresentsFloat("number")
    assert not utils.RepresentsFloat("3+6j")
    assert not utils.RepresentsFloat("-")
    assert not utils.RepresentsFloat("+")

    assert not utils.RepresentsFloat(3 + 6j)
    assert not utils.RepresentsFloat([])
    assert not utils.RepresentsFloat({})
    assert not utils.RepresentsFloat(())


def test_utils_03_represents_complex():
    assert utils.RepresentsComplex("10")
    assert utils.RepresentsComplex("0")
    assert utils.RepresentsComplex("-10")
    assert utils.RepresentsComplex("1123")
    assert utils.RepresentsComplex("99999")
    assert utils.RepresentsComplex("-99999")
    assert utils.RepresentsComplex("+99999")
    assert utils.RepresentsComplex("123456789")
    assert utils.RepresentsComplex("10.0")
    assert utils.RepresentsComplex("0.0")
    assert utils.RepresentsComplex("-10.0")
    assert utils.RepresentsComplex("1.")
    assert utils.RepresentsComplex("3+6j")
    assert utils.RepresentsComplex("6j")

    assert utils.RepresentsComplex(10)
    assert utils.RepresentsComplex(0)
    assert utils.RepresentsComplex(-10)
    assert utils.RepresentsComplex(1123)
    assert utils.RepresentsComplex(99999)
    assert utils.RepresentsComplex(-99999)
    assert utils.RepresentsComplex(+99999)
    assert utils.RepresentsComplex(123456789)
    assert utils.RepresentsComplex(10.0)
    assert utils.RepresentsComplex(0.0)
    assert utils.RepresentsComplex(-10.0)
    assert utils.RepresentsComplex(1.0)
    assert utils.RepresentsComplex(3 + 6j)
    assert utils.RepresentsComplex(6j)

    assert not utils.RepresentsComplex("asd")
    assert not utils.RepresentsComplex("number")
    assert not utils.RepresentsComplex("-")
    assert not utils.RepresentsComplex("+")

    assert not utils.RepresentsComplex([])
    assert not utils.RepresentsComplex({})
    assert not utils.RepresentsComplex(())
