"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonLayerVersion = void 0;
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const bundling_1 = require("./bundling");
/**
 * (experimental) A lambda layer version.
 *
 * @experimental
 */
class PythonLayerVersion extends lambda.LayerVersion {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b;
        const compatibleRuntimes = (_a = props.compatibleRuntimes) !== null && _a !== void 0 ? _a : [lambda.Runtime.PYTHON_3_7];
        // Ensure that all compatible runtimes are python
        for (const runtime of compatibleRuntimes) {
            if (runtime && runtime.family !== lambda.RuntimeFamily.PYTHON) {
                throw new Error('Only `PYTHON` runtimes are supported.');
            }
        }
        // Entry and defaults
        const entry = path.resolve(props.entry);
        // Pick the first compatibleRuntime to use for bundling or PYTHON_3_7
        const runtime = (_b = compatibleRuntimes[0]) !== null && _b !== void 0 ? _b : lambda.Runtime.PYTHON_3_7;
        super(scope, id, {
            ...props,
            compatibleRuntimes,
            code: bundling_1.bundle({
                entry,
                runtime,
                outputPathSuffix: 'python',
            }),
        });
    }
}
exports.PythonLayerVersion = PythonLayerVersion;
//# sourceMappingURL=data:application/json;base64,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