import * as lambda from '@aws-cdk/aws-lambda';
import * as cdk from '@aws-cdk/core';
/**
 * (experimental) Properties for a PythonFunction.
 *
 * @experimental
 */
export interface PythonFunctionProps extends lambda.FunctionOptions {
    /**
     * (experimental) The path to the root directory of the function.
     *
     * @experimental
     */
    readonly entry: string;
    /**
     * (experimental) The path (relative to entry) to the index file containing the exported handler.
     *
     * @default index.py
     * @experimental
     */
    readonly index?: string;
    /**
     * (experimental) The name of the exported handler in the index file.
     *
     * @default handler
     * @experimental
     */
    readonly handler?: string;
    /**
     * (experimental) The runtime environment.
     *
     * Only runtimes of the Python family are
     * supported.
     *
     * @default lambda.Runtime.PYTHON_3_7
     * @experimental
     */
    readonly runtime?: lambda.Runtime;
}
/**
 * (experimental) A Python Lambda function.
 *
 * @experimental
 */
export declare class PythonFunction extends lambda.Function {
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props: PythonFunctionProps);
}
