# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class RebuildInstanceRequest(JDCloudRequest):
    """
    云主机使用指定镜像重置云主机系统<br>
云主机的状态必须为<b>stopped</b>状态。<br>
若不指定镜像ID，默认使用当前主机的原镜像重置系统。<br>
云主机系统盘类型必须与待更换镜像支持的系统盘类型保持一致，若当前云主机系统盘为local类型，则更换镜像的系统盘类型必须为loaclDisk类型；同理，若当前云主机系统盘为cloud类型，则更换镜像的系统盘类型必须为cloudDisk类型。可查询<a href="http://docs.jdcloud.com/virtual-machines/api/describeimages">DescribeImages</a>接口获得指定地域的镜像信息。<br>
指定的镜像必须能够支持当前主机的实例规格(instanceType)，否则会返回错误。可查询<a href="http://docs.jdcloud.com/virtual-machines/api/describeimageconstraints">DescribeImageConstraints</a>接口获得指定镜像支持的系统盘类型信息。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(RebuildInstanceRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:rebuildInstance', 'POST', header, version)
        self.parameters = parameters


class RebuildInstanceParameters(object):

    def __init__(self, regionId, instanceId, ):
        """
        :param regionId: 地域ID
        :param instanceId: 云主机ID
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.password = None
        self.imageId = None
        self.keyNames = None
        self.hostname = None
        self.metadata = None
        self.userdata = None

    def setPassword(self, password):
        """
        :param password: (Optional) 云主机密码，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。
        """
        self.password = password

    def setImageId(self, imageId):
        """
        :param imageId: (Optional) 镜像ID。可查询<a href="http://docs.jdcloud.com/virtual-machines/api/describeimages">DescribeImages</a>接口获得指定地域的镜像信息。
        """
        self.imageId = imageId

    def setKeyNames(self, keyNames):
        """
        :param keyNames: (Optional) 密钥对名称；当前只支持一个。仅Linux系统支持指定。
        """
        self.keyNames = keyNames

    def setHostname(self, hostname):
        """
        :param hostname: (Optional) 云主机hostname，若不指定hostname，则hostname默认使用云主机重置前的hostname
Windows Server系统：长度为2-15个字符，允许大小写字母、数字或连字符（-）。不能以连字符（-）开头或结尾，不能连续使用连字符（-），也不能全部使用数字。不支持点号（.）。
Linux系统：长度为2-64个字符，允许支持多个点号，点之间为一段，每段允许使用大小写字母、数字或连字符（-），但不能连续使用点号（.）或连字符（-），不能以点号（.）或连字符（-）开头或结尾。

        """
        self.hostname = hostname

    def setMetadata(self, metadata):
        """
        :param metadata: (Optional) 用户自定义元数据信息，key-value键值对总数量不超过40对，其中有效键值对数量不超过20，无效键值对数量不超过20对。不区分大小写。
若不指定metadata，则metadata默认使用云主机重置前的metadata。
注意：key不要以连字符(-)结尾，否则此key不生效。

        """
        self.metadata = metadata

    def setUserdata(self, userdata):
        """
        :param userdata: (Optional) 元数据信息，目前只支持传入一个key为"launch-script"，表示首次启动脚本。value为base64格式。
若不指定userdata，则userdata默认使用云主机重置前的userdata。
launch-script：linux系统支持bash和python，编码前须分别以 #!/bin/bash 和 #!/usr/bin/env python 作为内容首行;
launch-script：windows系统支持bat和powershell，编码前须分别以 <cmd></cmd> 和 <powershell></powershell> 作为内容首、尾行。

        """
        self.userdata = userdata

