# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateTargetGroupRequest(JDCloudRequest):
    """
    创建一个虚拟服务器组
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateTargetGroupRequest, self).__init__(
            '/regions/{regionId}/targetGroups/', 'POST', header, version)
        self.parameters = parameters


class CreateTargetGroupParameters(object):

    def __init__(self, regionId, targetGroupName, loadBalancerId, ):
        """
        :param regionId: Region ID
        :param targetGroupName: 虚拟服务器组名称,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符
        :param loadBalancerId: 负载均衡的Id
        """

        self.regionId = regionId
        self.targetGroupName = targetGroupName
        self.loadBalancerId = loadBalancerId
        self.description = None
        self.type = None

    def setDescription(self, description):
        """
        :param description: (Optional) 描述,允许输入UTF-8编码下的全部字符，不超过256字符
        """
        self.description = description

    def setType(self, type):
        """
        :param type: (Optional) 类型，取值为instance或ip
        """
        self.type = type

