# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeIpsRequest(JDCloudRequest):
    """
    查询公网IP列表
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeIpsRequest, self).__init__(
            '/idcs/{idc}/ips', 'GET', header, version)
        self.parameters = parameters


class DescribeIpsParameters(object):

    def __init__(self, idc, ):
        """
        :param idc: IDC机房ID
        """

        self.idc = idc
        self.pageNumber = None
        self.pageSize = None
        self.all = None
        self.lineType = None
        self.status = None
        self.cidrAddr = None
        self.filters = None
        self.sorts = None

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 页码, 默认为1
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 分页大小，默认为20
        """
        self.pageSize = pageSize

    def setAll(self, all):
        """
        :param all: (Optional) 是否查询全部，默认分页
        """
        self.all = all

    def setLineType(self, lineType):
        """
        :param lineType: (Optional) 线路类型 dynamicBGP:动态BGP thirdLineBGP:三线BGP telecom:电信单线 unicom:联通单线 mobile:移动单线
        """
        self.lineType = lineType

    def setStatus(self, status):
        """
        :param status: (Optional) 状态 normal:正常 abnormal:异常
        """
        self.status = status

    def setCidrAddr(self, cidrAddr):
        """
        :param cidrAddr: (Optional) IP地址段
        """
        self.cidrAddr = cidrAddr

    def setFilters(self, filters):
        """
        :param filters: (Optional) ipId - 公网IP实例ID，精确匹配，支持多个

        """
        self.filters = filters

    def setSorts(self, sorts):
        """
        :param sorts: (Optional) null
        """
        self.sorts = sorts

