# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class UpdateProbeTaskRequest(JDCloudRequest):
    """
    修改可用性监控任务
    """

    def __init__(self, parameters, header=None, version="v2"):
        super(UpdateProbeTaskRequest, self).__init__(
            '/probeTask/{probeTaskID}', 'PATCH', header, version)
        self.parameters = parameters


class UpdateProbeTaskParameters(object):

    def __init__(self, probeTaskID, probes):
        """
        :param probeTaskID: 探测任务的task_id
        :param probes: 探测源（发起对探测目标探测的云主机，需安装相应的agent才能探测）
        """

        self.probeTaskID = probeTaskID
        self.httpBody = None
        self.httpCookie = None
        self.httpHeader = None
        self.httpType = None
        self.name = None
        self.probes = probes

    def setHttpBody(self, httpBody):
        """
        :param httpBody: (Optional) http body：选择探测类型为1=http时有效，最长不超过1024字节
        """
        self.httpBody = httpBody

    def setHttpCookie(self, httpCookie):
        """
        :param httpCookie: (Optional) http cookie：选择探测类型为1=http时有效，最大允许20个key、value对，最长不超过1024字节
        """
        self.httpCookie = httpCookie

    def setHttpHeader(self, httpHeader):
        """
        :param httpHeader: (Optional) http header：选择探测类型为1=http时有效，最大允许20个key、value对，最长不超过1024字节
        """
        self.httpHeader = httpHeader

    def setHttpType(self, httpType):
        """
        :param httpType: (Optional) http探测方法,可选值：1:get、2:post、3:head
        """
        self.httpType = httpType

    def setName(self, name):
        """
        :param name: (Optional) task名称，不允许重复，长度不超过32字符，只允许中英文、数字、下划线_、中划线-, [0-9][a-z] [A-Z] [- _ ]
        """
        self.name = name

