# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeAliasIpsRequest(JDCloudRequest):
    """
    查询别名IP列表
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeAliasIpsRequest, self).__init__(
            '/regions/{regionId}/aliasIps', 'GET', header, version)
        self.parameters = parameters


class DescribeAliasIpsParameters(object):

    def __init__(self, regionId, ):
        """
        :param regionId: 地域ID，可调用接口（describeRegions）获取云物理服务器支持的地域
        """

        self.regionId = regionId
        self.pageNumber = None
        self.pageSize = None
        self.subnetId = None
        self.instanceId = None
        self.cidr = None
        self.filters = None

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 页码；默认为1
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 分页大小；默认为20；取值范围[20, 100]
        """
        self.pageSize = pageSize

    def setSubnetId(self, subnetId):
        """
        :param subnetId: (Optional) 子网ID
        """
        self.subnetId = subnetId

    def setInstanceId(self, instanceId):
        """
        :param instanceId: (Optional) 实例ID
        """
        self.instanceId = instanceId

    def setCidr(self, cidr):
        """
        :param cidr: (Optional) CIDR段，模糊搜索
        """
        self.cidr = cidr

    def setFilters(self, filters):
        """
        :param filters: (Optional) aliasIpId - 别名IP id<br/>

        """
        self.filters = filters

