/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.locale;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.javarosa.core.util.OrderedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizationUtils {
    private static final Logger logger = LoggerFactory.getLogger(LocalizationUtils.class);

    public static OrderedMap<String, String> parseLocaleInput(InputStream is) throws IOException {
        OrderedMap<String, String> locale = new OrderedMap<String, String>();
        int chunk = 100;
        InputStreamReader isr = new InputStreamReader(is, "UTF-8");
        boolean done = false;
        char[] cbuf = new char[chunk];
        int offset = 0;
        int curline = 0;
        String line = "";
        block0: while (!done) {
            int read = isr.read(cbuf, offset, chunk - offset);
            if (read == -1) {
                done = true;
                if (line.length() == 0) break;
                LocalizationUtils.parseAndAdd(locale, line, curline);
                break;
            }
            String stringchunk = String.valueOf(cbuf, offset, read);
            int index = 0;
            while (index != -1) {
                int nindex = stringchunk.indexOf(10, index);
                if (nindex == -1) {
                    nindex = stringchunk.indexOf(13, index);
                }
                if (nindex == -1) {
                    line = line + stringchunk.substring(index);
                    continue block0;
                }
                line = line + stringchunk.substring(index, nindex);
                LocalizationUtils.parseAndAdd(locale, line, ++curline);
                line = "";
                index = nindex + 1;
            }
        }
        is.close();
        return locale;
    }

    private static void parseAndAdd(OrderedMap<String, String> locale, String line, int curline) {
        line = line.trim();
        while (line.indexOf("#") != -1) {
            line = line.substring(0, line.indexOf("#"));
        }
        if (line.indexOf(61) == -1) {
            if (!line.trim().equals("")) {
                logger.info("Invalid line (#{}) read: {}", (Object)curline, (Object)line);
            }
        } else if (line.indexOf(61) != line.length() - 1) {
            String value = line.substring(line.indexOf(61) + 1, line.length());
            locale.put(line.substring(0, line.indexOf(61)), value);
        } else {
            logger.info("Invalid line (#{}) read: '{}'. No value follows the '='.", (Object)curline, (Object)line);
        }
    }
}

