/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services;

import java.util.ArrayList;
import java.util.List;
import org.javarosa.core.util.externalizable.CannotCreateObjectException;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class PrototypeManager {
    private static List<String> prototypes;
    private static PrototypeFactory staticDefault;

    public static void registerPrototype(String className) {
        PrototypeManager.getPrototypes().add(className);
        try {
            PrototypeFactory.getInstance(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new CannotCreateObjectException(className + ": not found");
        }
        PrototypeManager.rebuild();
    }

    public static void registerPrototypes(String[] classNames) {
        for (String className : classNames) {
            PrototypeManager.registerPrototype(className);
        }
    }

    public static List<String> getPrototypes() {
        if (prototypes == null) {
            prototypes = new ArrayList<String>();
        }
        return prototypes;
    }

    public static PrototypeFactory getDefault() {
        if (staticDefault == null) {
            PrototypeManager.rebuild();
        }
        return staticDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rebuild() {
        if (staticDefault == null) {
            staticDefault = new PrototypeFactory(PrototypeManager.getPrototypes());
            return;
        }
        PrototypeFactory prototypeFactory = staticDefault;
        synchronized (prototypeFactory) {
            staticDefault = new PrototypeFactory(PrototypeManager.getPrototypes());
        }
    }
}

