/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.utils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.javarosa.core.services.locale.Localization;
import org.javarosa.core.util.MathUtils;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;

public class DateUtils {
    private static final int MONTH_OFFSET = 1;
    public static final int FORMAT_ISO8601 = 1;
    public static final int FORMAT_HUMAN_READABLE_SHORT = 2;
    public static final int FORMAT_HUMAN_READABLE_DAYS_FROM_TODAY = 5;
    public static final int FORMAT_TIMESTAMP_SUFFIX = 7;
    public static final int FORMAT_TIMESTAMP_HTTP = 9;
    public static final long DAY_IN_MS = 86400000L;

    public static DateFields getFields(Date d) {
        return DateUtils.getFields(d, null);
    }

    public static DateFields getFields(Date d, String timezone) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(d);
        if (timezone != null) {
            cd.setTimeZone(TimeZone.getTimeZone(timezone));
        }
        DateFields fields = new DateFields();
        fields.year = cd.get(1);
        fields.month = cd.get(2) + 1;
        fields.day = cd.get(5);
        fields.hour = cd.get(11);
        fields.minute = cd.get(12);
        fields.second = cd.get(13);
        fields.secTicks = cd.get(14);
        fields.dow = cd.get(7);
        fields.week = cd.get(3);
        return fields;
    }

    public static Date getDate(DateFields f) {
        return DateUtils.getDate(f, null);
    }

    public static Date getDate(DateFields f, String timezone) {
        LocalDateTime ldt = DateUtils.getLocalDateTime(f);
        return timezone == null ? ldt.toDate() : ldt.toDate(TimeZone.getTimeZone(timezone));
    }

    private static LocalDateTime getLocalDateTime(DateFields f) {
        return new LocalDateTime(f.year, f.month, f.day, f.hour, f.minute, f.second, f.secTicks);
    }

    public static String formatDateTime(Date d, int format) {
        String delim;
        if (d == null) {
            return "";
        }
        DateFields fields = DateUtils.getFields(d, format == 9 ? "UTC" : null);
        switch (format) {
            case 1: {
                delim = "T";
                break;
            }
            case 7: {
                delim = "";
                break;
            }
            case 9: {
                delim = " ";
                break;
            }
            default: {
                delim = " ";
            }
        }
        return DateUtils.formatDate(fields, format) + delim + DateUtils.formatTime(fields, format);
    }

    public static String formatDate(Date d, int format) {
        return d == null ? "" : DateUtils.formatDate(DateUtils.getFields(d, format == 9 ? "UTC" : null), format);
    }

    public static String formatTime(Date d, int format) {
        return d == null ? "" : DateUtils.formatTime(DateUtils.getFields(d, format == 9 ? "UTC" : null), format);
    }

    private static String formatDate(DateFields f, int format) {
        switch (format) {
            case 1: {
                return DateUtils.formatDateISO8601(f);
            }
            case 2: {
                return DateUtils.formatDateColloquial(f);
            }
            case 5: {
                return DateUtils.formatDaysFromToday(f);
            }
            case 7: {
                return DateUtils.formatDateSuffix(f);
            }
            case 9: {
                return DateUtils.formatDateHttp(f);
            }
        }
        return null;
    }

    private static String formatTime(DateFields f, int format) {
        switch (format) {
            case 1: {
                return DateUtils.formatTimeISO8601(f);
            }
            case 2: {
                return DateUtils.formatTimeColloquial(f);
            }
            case 7: {
                return DateUtils.formatTimeSuffix(f);
            }
            case 9: {
                return DateUtils.formatTimeHttp(f);
            }
        }
        return null;
    }

    private static String formatDateHttp(DateFields f) {
        return DateUtils.format(f, "%a, %d %b %Y");
    }

    private static String formatTimeHttp(DateFields f) {
        return DateUtils.format(f, "%H:%M:%S GMT");
    }

    private static String formatDateISO8601(DateFields f) {
        return f.year + "-" + DateUtils.intPad(f.month, 2) + "-" + DateUtils.intPad(f.day, 2);
    }

    private static String formatDateColloquial(DateFields f) {
        String year = Integer.valueOf(f.year).toString();
        if (year.length() == 4) {
            year = year.substring(2, 4);
        }
        return DateUtils.intPad(f.day, 2) + "/" + DateUtils.intPad(f.month, 2) + "/" + year;
    }

    private static String formatDateSuffix(DateFields f) {
        return f.year + DateUtils.intPad(f.month, 2) + DateUtils.intPad(f.day, 2);
    }

    private static String formatTimeISO8601(DateFields f) {
        String time = DateUtils.intPad(f.hour, 2) + ":" + DateUtils.intPad(f.minute, 2) + ":" + DateUtils.intPad(f.second, 2) + "." + DateUtils.intPad(f.secTicks, 3);
        int milliday = ((f.hour * 60 + f.minute) * 60 + f.second) * 1000 + f.secTicks;
        int offset = TimeZone.getDefault().getOffset(1, f.year, f.month - 1, f.day, f.dow, milliday);
        if (offset == 0) {
            time = time + "Z";
        } else {
            String offsetSign = offset > 0 ? "+" : "-";
            int value = Math.abs(offset) / 1000 / 60;
            String hrs = DateUtils.intPad(value / 60, 2);
            String mins = ":" + DateUtils.intPad(value % 60, 2);
            time = time + offsetSign + hrs + mins;
        }
        return time;
    }

    private static String formatTimeColloquial(DateFields f) {
        return DateUtils.intPad(f.hour, 2) + ":" + DateUtils.intPad(f.minute, 2);
    }

    private static String formatTimeSuffix(DateFields f) {
        return DateUtils.intPad(f.hour, 2) + DateUtils.intPad(f.minute, 2) + DateUtils.intPad(f.second, 2);
    }

    public static String format(Date d, String format) {
        return DateUtils.format(DateUtils.getFields(d), format);
    }

    public static String format(DateFields f, String format) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < format.length(); ++i) {
            char c = format.charAt(i);
            if (c == '%') {
                if (++i >= format.length()) {
                    throw new RuntimeException("date format string ends with %");
                }
                c = format.charAt(i);
                if (c == '%') {
                    sb.append("%");
                    continue;
                }
                if (c == 'Y') {
                    sb.append(DateUtils.intPad(f.year, 4));
                    continue;
                }
                if (c == 'y') {
                    sb.append(DateUtils.intPad(f.year, 4).substring(2));
                    continue;
                }
                if (c == 'm') {
                    sb.append(DateUtils.intPad(f.month, 2));
                    continue;
                }
                if (c == 'n') {
                    sb.append(f.month);
                    continue;
                }
                if (c == 'b') {
                    sb.append(DateUtils.getLocalDateTime(f).toString(DateTimeFormat.forPattern("MMM")));
                    continue;
                }
                if (c == 'd') {
                    sb.append(DateUtils.intPad(f.day, 2));
                    continue;
                }
                if (c == 'e') {
                    sb.append(f.day);
                    continue;
                }
                if (c == 'H') {
                    sb.append(DateUtils.intPad(f.hour, 2));
                    continue;
                }
                if (c == 'h') {
                    sb.append(f.hour);
                    continue;
                }
                if (c == 'M') {
                    sb.append(DateUtils.intPad(f.minute, 2));
                    continue;
                }
                if (c == 'S') {
                    sb.append(DateUtils.intPad(f.second, 2));
                    continue;
                }
                if (c == '3') {
                    sb.append(DateUtils.intPad(f.secTicks, 3));
                    continue;
                }
                if (c == 'a') {
                    sb.append(DateUtils.getLocalDateTime(f).toString(DateTimeFormat.forPattern("EEE")));
                    continue;
                }
                if (c == 'W') {
                    sb.append(f.week);
                    continue;
                }
                if (c == 'Z' || c == 'A' || c == 'B') {
                    throw new RuntimeException("unsupported escape in date format string [%" + c + "]");
                }
                throw new RuntimeException("unrecognized escape in date format string [%" + c + "]");
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static Date parseDateTime(String str) {
        DateFields fields = new DateFields();
        int i = str.indexOf("T");
        if (i != -1 ? !DateUtils.parseDate(str.substring(0, i), fields) || !DateUtils.parseTime(str.substring(i + 1), fields) : !DateUtils.parseDate(str, fields)) {
            return null;
        }
        return DateUtils.getDate(fields);
    }

    public static Date parseDate(String str) {
        DateFields fields = new DateFields();
        if (!DateUtils.parseDate(str, fields)) {
            return null;
        }
        return DateUtils.getDate(fields);
    }

    public static Date parseTime(String str) {
        DateFields fields = DateUtils.getFields(new Date());
        fields.second = 0;
        fields.secTicks = 0;
        if (!DateUtils.parseTime(str, fields)) {
            return null;
        }
        return DateUtils.getDate(fields);
    }

    public static Date parseTimeWithFixedDate(String str, DateFields fields) {
        if (!DateUtils.parseTime(str, fields)) {
            return null;
        }
        return DateUtils.getDate(fields);
    }

    private static boolean parseDate(String dateStr, DateFields f) {
        List<String> pieces = DateUtils.split(dateStr, "-", false);
        if (pieces.size() != 3) {
            return false;
        }
        try {
            f.year = Integer.parseInt(pieces.get(0));
            f.month = Integer.parseInt(pieces.get(1));
            f.day = Integer.parseInt(pieces.get(2));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return f.check();
    }

    private static boolean parseTime(String timeStr, DateFields f) {
        DateFields timeOffset = null;
        if (timeStr.charAt(timeStr.length() - 1) == 'Z') {
            timeStr = timeStr.substring(0, timeStr.length() - 1);
            timeOffset = new DateFields();
        } else if (timeStr.indexOf("+") != -1 || timeStr.indexOf("-") != -1) {
            String offset;
            timeOffset = new DateFields();
            List<String> pieces = DateUtils.split(timeStr, "+", false);
            int offsetSign = -1;
            if (pieces.size() <= 1) {
                pieces = DateUtils.split(timeStr, "-", false);
                offsetSign = 1;
            }
            timeStr = pieces.get(0);
            String hours = offset = pieces.get(1);
            if (offset.indexOf(":") != -1) {
                List<String> tzPieces = DateUtils.split(offset, ":", false);
                hours = tzPieces.get(0);
                int mins = Integer.parseInt(tzPieces.get(1));
                timeOffset.minute = mins * offsetSign;
            }
            timeOffset.hour = Integer.parseInt(hours) * offsetSign;
        }
        if (!DateUtils.parseRawTime(timeStr, f)) {
            return false;
        }
        if (!f.check()) {
            return false;
        }
        if (timeOffset == null) {
            return true;
        }
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        long msecOffset = (long)((60 * timeOffset.hour + timeOffset.minute) * 60) * 1000L;
        c.setTime(new Date(DateUtils.getDate(f, "UTC").getTime() + msecOffset));
        c.setTimeZone(TimeZone.getDefault());
        long four = c.get(10);
        DateFields adjusted = DateUtils.getFields(c.getTime());
        f.year = adjusted.year;
        f.month = adjusted.month;
        f.day = adjusted.day;
        f.dow = adjusted.dow;
        f.hour = adjusted.hour;
        f.minute = adjusted.minute;
        f.second = adjusted.second;
        f.secTicks = adjusted.secTicks;
        return f.check();
    }

    private static boolean parseRawTime(String timeStr, DateFields f) {
        List<String> pieces = DateUtils.split(timeStr, ":", false);
        if (pieces.size() != 2 && pieces.size() != 3) {
            return false;
        }
        try {
            f.hour = Integer.parseInt(pieces.get(0));
            f.minute = Integer.parseInt(pieces.get(1));
            if (pieces.size() == 3) {
                char c;
                int i;
                String secStr = pieces.get(2);
                for (i = 0; i < secStr.length() && (Character.isDigit(c = secStr.charAt(i)) || c == '.'); ++i) {
                }
                int idxDec = (secStr = secStr.substring(0, i)).indexOf(46);
                if (idxDec == -1) {
                    f.second = secStr.length() == 0 ? 0 : Integer.parseInt(secStr);
                    f.secTicks = 0;
                } else {
                    String secPart = secStr.substring(0, idxDec);
                    f.second = secPart.length() == 0 ? 0 : Integer.parseInt(secPart);
                    String secTickStr = secStr.substring(idxDec + 1);
                    f.secTicks = secTickStr.length() > 0 ? Integer.parseInt(secTickStr) : 0;
                }
                double fsec = Double.parseDouble(secStr);
                f.second = (int)fsec;
                f.secTicks = (int)(1000.0 * fsec - 1000.0 * (double)f.second);
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return f.check();
    }

    public static Date getDate(int year, int month, int day) {
        DateFields f = new DateFields();
        f.year = year;
        f.month = month;
        f.day = day;
        return f.check() ? DateUtils.getDate(f) : null;
    }

    public static Date roundDate(Date d) {
        if (d == null) {
            return null;
        }
        DateFields f = DateUtils.getFields(d);
        return DateUtils.getDate(f.year, f.month, f.day);
    }

    public static Date today() {
        return DateUtils.roundDate(new Date());
    }

    public static double decimalTimeOfLocalDay(Date d) {
        long milli = d.getTime();
        Calendar c = Calendar.getInstance(TimeZone.getDefault());
        long milliOff = c.get(15) + c.get(16);
        Double v = (double)(milli += milliOff) / 8.64E7;
        return v - Math.floor(v);
    }

    public static int daysInMonth(int month, int year) {
        if (month == 3 || month == 5 || month == 8 || month == 10) {
            return 30;
        }
        if (month == 1) {
            return 28 + (DateUtils.isLeap(year) ? 1 : 0);
        }
        return 31;
    }

    public static boolean isLeap(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    private static String formatDaysFromToday(DateFields f) {
        String daysAgoStr = "";
        Date d = DateUtils.getDate(f);
        int daysAgo = DateUtils.daysSinceEpoch(new Date()) - DateUtils.daysSinceEpoch(d);
        if (daysAgo == 0) {
            return Localization.get("date.today");
        }
        if (daysAgo == 1) {
            return Localization.get("date.yesterday");
        }
        if (daysAgo == 2) {
            return Localization.get("date.twoago", new String[]{String.valueOf(daysAgo)});
        }
        if (daysAgo > 2 && daysAgo <= 6) {
            return Localization.get("date.nago", new String[]{String.valueOf(daysAgo)});
        }
        if (daysAgo == -1) {
            return Localization.get("date.tomorrow");
        }
        if (daysAgo < -1 && daysAgo >= -6) {
            return Localization.get("date.nfromnow", new String[]{String.valueOf(-daysAgo)});
        }
        return DateUtils.formatDate(f, 2);
    }

    public static Date getPastPeriodDate(Date ref, String type, String start, boolean beginning, boolean includeToday, int nAgo) {
        Date d = null;
        if (type.equals("week")) {
            int offset;
            int target_dow = -1;
            int current_dow = -1;
            int n = offset = includeToday ? 1 : 0;
            if (start.equals("sun")) {
                target_dow = 0;
            } else if (start.equals("mon")) {
                target_dow = 1;
            } else if (start.equals("tue")) {
                target_dow = 2;
            } else if (start.equals("wed")) {
                target_dow = 3;
            } else if (start.equals("thu")) {
                target_dow = 4;
            } else if (start.equals("fri")) {
                target_dow = 5;
            } else if (start.equals("sat")) {
                target_dow = 6;
            }
            if (target_dow == -1) {
                throw new RuntimeException();
            }
            Calendar cd = Calendar.getInstance();
            cd.setTime(ref);
            switch (cd.get(7)) {
                case 1: {
                    current_dow = 0;
                    break;
                }
                case 2: {
                    current_dow = 1;
                    break;
                }
                case 3: {
                    current_dow = 2;
                    break;
                }
                case 4: {
                    current_dow = 3;
                    break;
                }
                case 5: {
                    current_dow = 4;
                    break;
                }
                case 6: {
                    current_dow = 5;
                    break;
                }
                case 7: {
                    current_dow = 6;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            int diff = (current_dow - target_dow + (7 + offset)) % 7 - offset + 7 * nAgo - (beginning ? 0 : 6);
            d = new Date(ref.getTime() - (long)diff * 86400000L);
        } else if (!type.equals("month")) {
            throw new IllegalArgumentException();
        }
        return d;
    }

    public static int getMonthsDifference(Date earlierDate, Date laterDate) {
        Date span = new Date(laterDate.getTime() - earlierDate.getTime());
        Date firstDate = new Date(0L);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(firstDate);
        int firstYear = calendar.get(1);
        int firstMonth = calendar.get(2);
        calendar.setTime(span);
        int spanYear = calendar.get(1);
        int spanMonth = calendar.get(2);
        int months = (spanYear - firstYear) * 12 + (spanMonth - firstMonth);
        return months;
    }

    public static int daysSinceEpoch(Date date) {
        return DateUtils.dateDiff(DateUtils.getDate(1970, 1, 1), date);
    }

    public static Double fractionalDaysSinceEpoch(Date a) {
        return new Double((double)(a.getTime() - DateUtils.getDate(1970, 1, 1).getTime()) / 8.64E7);
    }

    public static Date dateAdd(Date d, int n) {
        return DateUtils.roundDate(new Date(DateUtils.roundDate(d).getTime() + 86400000L * (long)n + 43200000L));
    }

    public static int dateDiff(Date a, Date b) {
        return (int)MathUtils.divLongNotSuck(DateUtils.roundDate(b).getTime() - DateUtils.roundDate(a).getTime() + 43200000L, 86400000L);
    }

    public static List<String> split(String str, String delimiter, boolean combineMultipleDelimiters) {
        int index = str.indexOf(delimiter);
        ArrayList<String> pieces = new ArrayList<String>(index + 1);
        while (index >= 0) {
            pieces.add(str.substring(0, index));
            str = str.substring(index + delimiter.length());
            index = str.indexOf(delimiter);
        }
        pieces.add(str);
        if (combineMultipleDelimiters) {
            for (int i = 0; i < pieces.size(); ++i) {
                if (((String)pieces.get(i)).length() != 0) continue;
                pieces.remove(i);
                --i;
            }
        }
        return pieces;
    }

    public static String intPad(int n, int pad) {
        String s = String.valueOf(n);
        while (s.length() < pad) {
            s = "0" + s;
        }
        return s;
    }

    private static boolean inRange(int x, int min, int max) {
        return x >= min && x <= max;
    }

    public static String formatDateToTimeStamp(Date date) {
        return DateUtils.formatDateTime(date, 1);
    }

    public static String getShortStringValue(Date val) {
        return DateUtils.formatDate(val, 2);
    }

    public static String getXMLStringValue(Date val) {
        return DateUtils.formatDate(val, 1);
    }

    public static String get24HourTimeFromDate(Date d) {
        return DateUtils.formatTime(d, 2);
    }

    public static Date getDateFromString(String value) {
        return DateUtils.parseDate(value);
    }

    public static Date getDateTimeFromString(String value) {
        return DateUtils.parseDateTime(value);
    }

    public static boolean stringContains(String string, String substring) {
        if (string == null || substring == null) {
            return false;
        }
        return string.indexOf(substring) != -1;
    }

    public static class DateFields {
        public int year;
        public int month;
        public int day;
        public int hour;
        public int minute;
        public int second;
        public int secTicks;
        public int week;
        public int dow;

        public DateFields() {
            this.year = 1970;
            this.month = 1;
            this.day = 1;
            this.hour = 0;
            this.minute = 0;
            this.second = 0;
            this.secTicks = 0;
            this.dow = 0;
            this.week = 1;
        }

        DateFields(int year, int month, int day, int hour, int minute, int second, int secTicks, int dow, int week) {
            this.year = year;
            this.month = month;
            this.day = day;
            this.hour = hour;
            this.minute = minute;
            this.second = second;
            this.secTicks = secTicks;
            this.dow = dow;
            this.week = week;
        }

        public static DateFields of(int year, int month, int day, int hour, int minute, int second, int secTicks) {
            LocalDateTime ldt = new LocalDateTime(year, month, day, hour, minute, second, secTicks);
            int iso8601Dow = ldt.getDayOfWeek();
            int dow = iso8601Dow == 7 ? 0 : iso8601Dow;
            int week = ldt.getWeekOfWeekyear();
            return new DateFields(year, month, day, hour, minute, second, secTicks, dow, week);
        }

        public boolean check() {
            return DateUtils.inRange(this.month, 1, 12) && DateUtils.inRange(this.day, 1, DateUtils.daysInMonth(this.month - 1, this.year)) && DateUtils.inRange(this.hour, 0, 23) && DateUtils.inRange(this.minute, 0, 59) && DateUtils.inRange(this.second, 0, 59) && DateUtils.inRange(this.secTicks, 0, 999) && DateUtils.inRange(this.week, 1, 53);
        }
    }
}

