# Code generated by TRAC

from __future__ import annotations
import typing as _tp  # noqa
import dataclasses as _dc  # noqa
import enum as _enum  # noqa

import tracdap.rt.metadata as metadata
from .common import *  # noqa



@_dc.dataclass
class PlatformConfig:

    config: _tp.Dict[str, str] = _dc.field(default_factory=dict)

    platformInfo: PlatformInfo = None

    authentication: AuthenticationConfig = None

    metadata: MetadataConfig = None

    storage: StorageConfig = None

    repositories: _tp.Dict[str, PluginConfig] = _dc.field(default_factory=dict)

    executor: PluginConfig = None

    tenants: _tp.Dict[str, TenantConfig] = _dc.field(default_factory=dict)

    webServer: _tp.Optional[WebServerConfig] = None

    instances: InstantMap = None

    services: ServiceMap = None


@_dc.dataclass
class MetadataConfig:

    database: PluginConfig = None

    format: metadata.MetadataFormat = metadata.MetadataFormat.METADATA_FORMAT_NOT_SET


@_dc.dataclass
class StorageConfig:

    buckets: _tp.Dict[str, PluginConfig] = _dc.field(default_factory=dict)

    defaultBucket: str = None

    defaultFormat: str = None


@_dc.dataclass
class TenantConfig:

    defaultBucket: _tp.Optional[str] = None

    defaultFormat: _tp.Optional[str] = None


@_dc.dataclass
class WebServerConfig:

    enabled: bool = None

    port: int = None

    contentRoot: PluginConfig = None

    rewriteRules: _tp.List[WebServerRewriteRule] = _dc.field(default_factory=list)


@_dc.dataclass
class WebServerRewriteRule:

    source: str = None

    target: str = None


@_dc.dataclass
class InstantMap:

    meta: _tp.List[InstanceConfig] = _dc.field(default_factory=list)

    data: _tp.List[InstanceConfig] = _dc.field(default_factory=list)

    orch: _tp.List[InstanceConfig] = _dc.field(default_factory=list)


@_dc.dataclass
class InstanceConfig:

    scheme: str = None

    host: str = None

    port: int = None


@_dc.dataclass
class ServiceMap:

    meta: ServiceConfig = None

    data: ServiceConfig = None

    orch: ServiceConfig = None


@_dc.dataclass
class ServiceConfig:

    port: int = None
