# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['likeprocessing']

package_data = \
{'': ['*'], 'likeprocessing': ['images/*']}

install_requires = \
['pygame>=2.1.2,<3.0.0', 'pygame_textinput>=1.0.1,<2.0.0']

setup_kwargs = {
    'name': 'likeprocessing',
    'version': '0.1.6.9.8',
    'description': 'Like processing library with pygame',
    'long_description': '\n## Structure du programme \n\n\n### Installation:\n\n**Dans pycharm :** \\\nCTRL+ALT+s, puis choisir project -> python interpreter et + puis likeprocessing\n\n**dans le terminal :** \\\npip install likeprocessing\n\n\n### Les fonctions setup(), draw() et run(globals())\n\nLe programme doit contenir deux fonctions, setup() et draw(), et l\'exécution est lancée à l\'aide de l\'instruction run(globals()).\n\nLorsque l\'on exécute l\'instruction run(globals()), la fonction setup() est exécutée une fois :\n\n\n```\nfrom likeprocessing.processing import *\ndef setup():\n    createCanvas(800,600)\n    # instructions de paramétrage de l\'affichage\n```\n\n\nCette fonction permet de définir les dimensions de la fenêtre de tracé, et quelques paramètres initiaux. Les valeurs données aux paramètres de la fonction **createCanvas() ** sont affectées automatiquement à deux variables systèmes : **width** pour le premier paramètre et **height** pour le second. Un troisième paramètre **resizable** optionnel permet d\'offrir la possibilité de redimensionner la fenêtre avec la souris  On peut récupérer les valeurs de **width** et **height** grâce au fonction **width()** et **height()**\n\nPuis la fonction **draw()** est ensuite exécutée en boucle, après l\'exécution de **setup()**:\n\n\n```\ndef draw():\n    # instructions de dessin\n```\n\n\nElle contient des instructions qui seront exécutées avec une fréquence réglable, permettant de modifier le contenu de la fenêtre et de créer des contenus statiques ou des animations.\n\nL\'instruction **stop()** met fin à l\'exécution de la boucle :\n\n\n```\ndef compute():\n    # instructions de calcul\n```\n\n\nCette fonction n\'est pas obligatoire. Elle permet d\'éviter de trop surcharger la fonction **draw()** en réservant celle-ci aux instructions de dessins. La fonction **compute()** si elle existe est insérée dans la boucle et est exécutée avant la fonction **draw()** \n\n\n## Structure de base :\n\n\n```\nfrom likeprocessing.processing import *\n\ndef setup():\n   createCanvas(400,200)\n   background("grey")\n\ndef draw():\n   pass\n\nrun(globals())\n```\n\n\n\n## Fonctions système\n\n\n<table>\n  <tr>\n   <td><strong>Fonctions</strong>\n   </td>\n   <td><strong>description</strong>\n   </td>\n  </tr>\n  <tr>\n   <td>width(), height()\n   </td>\n   <td>Dimensions de la zone de dessin. Les valeurs de width et height sont définies par les paramètres de la fonction createCanvas().\n   </td>\n  </tr>\n</table>\n\n\n\n## Rafraîchissement\n\n\n<table>\n  <tr>\n   <td><strong>Fonctions</strong>\n   </td>\n   <td><strong>description</strong>\n   </td>\n  </tr>\n  <tr>\n   <td>frameCount()\n   </td>\n   <td>Nombre d\'images affichées depuis le démarrage du programme.\n   </td>\n  </tr>\n  <tr>\n   <td>frameRate() \\\ngetFrameRate()\n   </td>\n   <td>Renvoie le nombre d\'images affichées chaque seconde.\n   </td>\n  </tr>\n  <tr>\n   <td>frameRate(valeur) \\\nsetFrameRate(valeur)\n   </td>\n   <td>Spécifie le nombre d\'images à afficher chaque seconde.\n   </td>\n  </tr>\n  <tr>\n   <td>noLoop()\n   </td>\n   <td>Si cette instruction est présente dans la fonction setup la fonction draw sera exécutée une seule fois. Si cette instruction est présente dans la fonction draw, les instructions de la fonction draw en cours sont exécutées (il n\'y a pas d\'interruption) mais celle-ci ne sera pas appelée à nouveau.\n   </td>\n  </tr>\n  <tr>\n   <td>loop()\n   </td>\n   <td>Relance l\'exécution en boucle de draw().\n   </td>\n  </tr>\n</table>\n\n\n\n## Couleurs\n\n\n## Désigner une couleur\n\n\n<table>\n  <tr>\n   <td><strong>syntaxe</strong>\n   </td>\n   <td><strong>description</strong>\n   </td>\n  </tr>\n  <tr>\n   <td>\'red\'\n   </td>\n   <td>nom de couleur\n   </td>\n  </tr>\n  <tr>\n   <td>120\n   </td>\n   <td>niveau de gris : 0 - 255\n   </td>\n  </tr>\n  <tr>\n   <td>(100, 125, 255)\n   </td>\n   <td>couleur r, v, b (décimal) : 0 - 255\n   </td>\n  </tr>\n  <tr>\n   <td>\'#2aff95\'\n   </td>\n   <td>couleur r, v, b (hexadécimal) : 00 - ff\n   </td>\n  </tr>\n</table>\n\n\n\n## Dessiner en couleur\n\n\n<table>\n  <tr>\n   <td><strong>Fonctions</strong>\n   </td>\n   <td><strong>description</strong>\n   </td>\n  </tr>\n  <tr>\n   <td>background(couleur)\n   </td>\n   <td>Définit la couleur d\'arrière-plan de la zone de dessin (255 par défaut).\n   </td>\n  </tr>\n  <tr>\n   <td>set_background_image(image: Image)\n   </td>\n   <td>Définit l\'image d\'arrière-plan de la zone de dessin.\n   </td>\n  </tr>\n  <tr>\n   <td>get_background_image()\n   </td>\n   <td>Récupère l\'image d\'arrière-plan de la zone de dessin.\n   </td>\n  </tr>\n  <tr>\n   <td>save_background():\n   </td>\n   <td>fait une copie du contenu de la fenêtre et le sauvegarde dans l\'image d\'arrière plan.\n   </td>\n  </tr>\n  <tr>\n   <td>fill(couleur=None)\n   </td>\n   <td>Définit la couleur de remplissage des formes (255 par défaut) et réactive le remplissage des formes. Sans paramètre seul le remplissage est activé (utile après un noFill()). Retourne la valeur précédente du remplissage.\n   </td>\n  </tr>\n  <tr>\n   <td>fill_mouse_on(couleur: any):\n   </td>\n   <td>initialise la couleur de fond des figures qui affichera quand la souris est dessus.\n   </td>\n  </tr>\n  <tr>\n   <td>get_fill()\n   </td>\n   <td>Retourne la couleur de fond actuelle\n   </td>\n  </tr>\n  <tr>\n   <td>noFill()\n   </td>\n   <td>Désactive la couleur de remplissage.\n   </td>\n  </tr>\n  <tr>\n   <td>stroke(couleur)\n   </td>\n   <td>Définit la couleur du tracé des bords des formes et des lignes("black" par défaut). Retourne la valeur précédente de la couleur.\n   </td>\n  </tr>\n  <tr>\n   <td>get_stroke()\n   </td>\n   <td>retourne la couleur des bords actuelle\n   </td>\n  </tr>\n  <tr>\n   <td>noStroke()\n   </td>\n   <td>Désactive le tracé du contour des figures. Retourne la valeur précédente de la couleur.\n   </td>\n  </tr>\n  <tr>\n   <td>save_fill_stroke()\n   </td>\n   <td>Sauvegarde les paramètres fill et stroke\n   </td>\n  </tr>\n  <tr>\n   <td>restore_fill_stroke()\n   </td>\n   <td>recharge les paramètres fill et stroke précédemment sauvegardé avec <strong>save_fill_stroke</strong>\n   </td>\n  </tr>\n</table>\n\n\nSi **noFill()** et **noStroke() **sont exécutées en même temps, rien n\'est tracé dans la zone de dessin.\n\n\n## Formes\n\n\n### Primitives 2d\n\nL\'origine du repère est située en haut à gauche. Les abscisses augmentent de gauche à droite, les ordonnées augmentent de haut en bas.\n\n\n\n![](./images/image1.png)\n\n\n\n<table>\n  <tr>\n   <td><strong>fonctions</strong>\n   </td>\n   <td><strong>description</strong>\n   </td>\n  </tr>\n  <tr>\n   <td>point(x, y)\n   </td>\n   <td>Trace un point de coordonnées (x, y). carré de 2x2 pixels\n   </td>\n  </tr>\n  <tr>\n   <td>line(x1, y1, x2, y2)\n   </td>\n   <td>Trace un segment reliant les deux points de coordonnées (x1, y1) et (x2, y2).\n   </td>\n  </tr>\n  <tr>\n   <td>ellipse(x, y, largeur, hauteur)\n   </td>\n   <td>Tracer une ellipse dont le centre a pour coordonnées (x, y) et dont la largeur et la hauteur prennent les valeurs fixées.\n   </td>\n  </tr>\n  <tr>\n   <td>circle(x, y, diametre)\n   </td>\n   <td>Trace un cercle dont le centre a pour coordonnées (x, y) et dont le diamètre prend la valeur fixée. Idem ellipse((x, y, diametre, diametre)\n   </td>\n  </tr>\n  <tr>\n   <td>arc(x,y,largeur,hauteur,,angleDebut, angleFin)\n   </td>\n   <td>Créer une portion d\'ellipse type part de tarte qui pourra être rempli entre les points repérés par les angles angleDébut et angleFin (unité courante). x et y sont les coordonnées du centre du cercle.  \n   </td>\n  </tr>\n  <tr>\n   <td>circle_arc(x,y,rayon,angleDebut, angleFin)\n   </td>\n   <td>idem arc mais à partir d\'un disque\n   </td>\n  </tr>\n  <tr>\n   <td>ellipseMode(corners_center: str)\n   </td>\n   <td>Définie la position des points x et y des fonctions basées sur ellipse. par défaut : "corners" x et y sont les coordonnées du point en haut à gauche du rectangle dans lequel est inscrit l\'ellipse. si les paramètre est "center" x et y représente le centre du rectangle. Retourne la valeur précédente du mode.\n   </td>\n  </tr>\n  <tr>\n   <td>rect(x, y, largeur, hauteur)\n   </td>\n   <td>Créer un rectangle aux coordonnées x,y de largeur largeur et de hauteur. Si rectMode(\'center\') x et y sont les coordonnées du centre du rectangle. Si rectMode(\'corners\') x,y sont les coordonnées du coin haut gauche. Le rectangle est rempli par la couleur définie par fill(couleur). Si le paramètre image est renseigné (image= ...) le fond du rectangle sera occupé pas l\'image retaillée aux dimensions du rectangle sauf si largeur et/ou hauteur sont nulles (ou non renseignées). largeur et/ou hauteur seront alors celles de l\'image. Les paramètres <strong>allign_h </strong>(left, center et right) et  <strong>allign_v</strong> (top,center et bottom) permettent d\'aligner l\'image dans un cadre plus grand qu\'elle.\n   </td>\n  </tr>\n  <tr>\n   <td>square(x, y, cote)\n   </td>\n   <td>Trace un carré dont le sommet en haut à gauche a pour coordonnées (x, y) et dont le côté prend la valeur fixée. fonctionnement idem rectangle\n   </td>\n  </tr>\n  <tr>\n   <td>rectMode(corners_center: str)\n   </td>\n   <td>Définie la position des points x et y des fonctions basées sur rect. par défaut : "corners" x et y sont les coordonnées du point en haut à gauche du rectangle. si les paramètre est "center" x et y représente le centre du rectangle. Retourne la valeur précédente du mode.\n   </td>\n  </tr>\n  <tr>\n   <td>triangle(x1, y1, x2, y2, x3, y3)\n   </td>\n   <td>Trace un triangle dont les trois sommets ont pour coordonnées (x1, y1), (x2, y2), et (x3, y3).\n   </td>\n  </tr>\n  <tr>\n   <td>quad(x1, y1, x2, y2, x3, y3, x4, y4)\n   </td>\n   <td>Trace un quadrilatère dont les quatre sommets ont pour coordonnées (x1, y1), (x2, y2), (x3, y3) et (x4, y4).\n   </td>\n  </tr>\n  <tr>\n   <td>k_line(points)\n   </td>\n   <td>trace un ligne brisée à partir d\'une liste de points [[1,2],[5,6],[8,3],.....]. (nb_point = nb_segments + 1)\n   </td>\n  </tr>\n</table>\n\n\n\n### Tracés\n\n\n<table>\n  <tr>\n   <td><strong>fonctions</strong>\n   </td>\n   <td><strong>description</strong>\n   </td>\n  </tr>\n  <tr>\n   <td>strokeWeight(epaisseur)\n   </td>\n   <td>Définit l\'épaisseur du tracé en pixels (par défaut : 1 pixel). Retourne la valeur précédente de la largeur du trait\n   </td>\n  </tr>\n  <tr>\n   <td>noStroke()\n   </td>\n   <td>Désactive le tracé du contour des figures en mettant la largeur du bord à 0. Retourne la valeur précédente de la largeur.\n   </td>\n  </tr>\n  <tr>\n   <td>stroke(couleur)\n   </td>\n   <td>Définit la couleur du tracé des bords des formes et des lignes ("black" par défaut). Si aucune valeur n\'est passée, celle-ci retourne la couleur actuelle. Retourne la valeur précédente de la couleur.\n   </td>\n  </tr>\n</table>\n\n\n\n## Paramètres optionnels:\n\nLes paramètres optionnels sont passés directement dans la fonction et ne concernent que celle-ci: \n\nfill, no_fill, fill_mouse_on, stroke, stroke_weight,image (pour les rectangles), command, fill_mousse_on, name.\n\nexemple :\n\n\n```\ntriangle(20, 10, 50, 15, 40, 70, fill = "green", fill_mouse_on="yellow", stroke_weight=3)\n```\n\n\nl\'ajout de **command = ma_fonction** au paramètre **fill_mouse_on="couleur"** permet d\'exécuter la fonction **ma_fonction()**. Si l\'on veut attribuer **ma_fonction** à plusieurs formes il est possible d\'ajouter le paramètre **name = valeur**. Dans ce cas, la fonction **ma_fonction(name)** sera exécutée . Il faudra créer impérativement soit : \n\ndef ma_fonction():\n\n    pass\n\nou\n\ndef ma_fonction(nom):\n\n    pass\n\n\n## Textes\n\n\n<table>\n  <tr>\n   <td><strong>fonctions</strong>\n   </td>\n   <td><strong>description</strong>\n   </td>\n  </tr>\n  <tr>\n   <td>text(chaine, x, y)\n   </td>\n   <td>Affiche la chaîne à la position (x, y) dans une boite ajustée. couleur, largeur bord et couleur bord de la boite idem formes. Accepte les paramètres optionnels\n   </td>\n  </tr>\n  <tr>\n   <td>text(chaine, x, y, largeur, hauteur)\n   </td>\n   <td>Affiche la chaîne à la position (x, y) dans une boite de dimensions largeur x hauteur. couleur, largeur bord et couleur bord de la boite idem formes. largeur et hauteur sont optionnels\n   </td>\n  </tr>\n  <tr>\n   <td>textAlign(alignement_horizontal)\n<p>\ntextAlign(alignement_horizontal, alignement_vertical)\n   </td>\n   <td>Spécifie l\'alignement horizontal parmi LEFT, CENTER, et RIGHT et l\'alignement vertical parmi TOP, BOTTOM, CENTER, et BASELINE\n   </td>\n  </tr>\n  <tr>\n   <td>textFont(police)\n<p>\ntextFont(police, taille)\n   </td>\n   <td>Spécifie la police de caractères et éventuellement sa taille. Retourne la police et la taille précédente \n   </td>\n  </tr>\n  <tr>\n   <td>textSize(taille)\n   </td>\n   <td>Spécifie la taille de la police de caractères. Retourne la taille précédente de la police\n   </td>\n  </tr>\n  <tr>\n   <td>textStyle(style)\n   </td>\n   <td>Spécifie le style parmi NORMAL, ITALIC, BOLD et BOLDITALIC\n   </td>\n  </tr>\n  <tr>\n   <td>textWidth(chaine)\n   </td>\n   <td>Largeur en pixels de l\'affichage de chaîne, dans la police et taille actuelles\n   </td>\n  </tr>\n</table>\n\n\n\n## Paramètres optionnels spécifique à text:\n\nLes paramètres optionnels sont passés directement dans la fonction et ne concernent que celle-ci: \n\nla fonction text possèdes elle aussi des paramètres optionnels qui ne concernent que la fonction en cours : \\\n**font, font_size, font_color** qui permettent  de définir la police, la taille des caractères ainsi que la couleur de ceux-ci. \n\n**allign_h et allign_v** permettent de positionner le texte dans la boîte de texte comme **textAllign()**.\n\n**padx et pady** permettent de créer une marge autour du texte (valeur en pixels)  \\\nexemple : \n\n\n```\ntext("salut les amis",20,30,300,allign_h="center",font="arial",font_size=48,fontTools="green",pady=10)\n```\n\n\nCe code va afficher "salut les amis" dans un cadre de longueur 300 à la position x=20 et y=30. La hauteur du cadre est calculée en fonction de la hauteur du texte (font_size). **pady=10** ajoute 10 pixels au dessus et en dessous du texte. **Si la hauteur du cadre est donnée, si celle-ci est trop petite le texte sortira du cadre.**\n\n\n## Événements\n\n\n### Touches du clavier\n\n\n<table>\n  <tr>\n   <td><strong>fonctions</strong>\n   </td>\n   <td><strong>description</strong>\n   </td>\n  </tr>\n  <tr>\n   <td>key()\n   </td>\n   <td>état des touches du clavier (list)\n   </td>\n  </tr>\n  <tr>\n   <td>keyCode()\n   </td>\n   <td>Code de la dernière touche appuyée.\n   </td>\n  </tr>\n  <tr>\n   <td>keyIsPressed()\n<p>\nisKeyPressed()\n   </td>\n   <td>Vaut True lorsqu\'une touche du clavier est appuyée et False sinon.\n   </td>\n  </tr>\n  <tr>\n   <td>keyIsDown(code)\n<p>\nkeyIsDown(touche)\n   </td>\n   <td>Vaut True si la touche concernée est appuyée et False sinon.\n   </td>\n  </tr>\n</table>\n\n\n\n### Souris\n\n\n<table>\n  <tr>\n   <td><strong>fonctions</strong>\n   </td>\n   <td><strong>description</strong>\n   </td>\n  </tr>\n  <tr>\n   <td>mouseX(), mouseY()\n   </td>\n   <td>Coordonnées du pointeur de la souris\n   </td>\n  </tr>\n  <tr>\n   <td>mouseXY()\n   </td>\n   <td>Coordonnées du pointeur de la souris sous forme de tuple\n   </td>\n  </tr>\n  <tr>\n   <td>mouseIsPressed()\n   </td>\n   <td>Vaut True si la souris est cliquée, et False sinon.\n   </td>\n  </tr>\n  <tr>\n   <td>fill_mouse_on(couleur:str)\n   </td>\n   <td>Change la couleur des formes quand on passe la souris dessus. Non actif par défaut.\n   </td>\n  </tr>\n  <tr>\n   <td>noFill_mouse_on()\n   </td>\n   <td>annule l\'effet de fill_mouse_on()\n   </td>\n  </tr>\n  <tr>\n   <td>mouse_click_down()\n   </td>\n   <td>renvoie True lors du passage de relâché à appuyé du bouton de la souris.\n   </td>\n  </tr>\n  <tr>\n   <td>mouse_click_up()\n   </td>\n   <td>renvoie True lors du passage de appuyé à relâché du bouton de la souris.\n   </td>\n  </tr>\n  <tr>\n   <td>mouse_click()\n   </td>\n   <td>idem mouseIsPressed()\n   </td>\n  </tr>\n  <tr>\n   <td>mouse_wheel_state()\n   </td>\n   <td>retourne 1 si la roulette de la souris est tournée vers l\'avant, -1 vers l\'arrière et 0 si elle est immobile.\n   </td>\n  </tr>\n</table>\n\n\n\n## Mathématiques\n\n\n### Angles\n\n\n<table>\n  <tr>\n   <td><strong>fonctions</strong>\n   </td>\n   <td><strong>description</strong>\n   </td>\n  </tr>\n  <tr>\n   <td>angleMode(mode_angle:str)\n   </td>\n   <td>Définit l\'unité de mesure des angles. \\\n \'rad\' les angles des fonctions trigonométriques seront pris comme des radians (défaut) \\\n \'deg\' les angles des fonctions trigonométriques seront pris comme des degrés \\\n\'grd\' les angles des fonctions trigonométriques seront pris comme des grades \\\nUne exception est levée en cas d\'erreur de paramètre\n<p>\nsi mode_angle == "" la valeur de mode est retournée (str)\n   </td>\n  </tr>\n  <tr>\n   <td>cos(), sin(), tan(), acos(),asin(),atan(),atan2()\n   </td>\n   <td>Fonctions trigonométriques usuelles l\'unité considérée sera celle choisie avec angleMode(). atan2 : même fonctionnement que la fonction math.atan2 mais l\'unité de l\'angle retourné dépend  de angleMode()  \n   </td>\n  </tr>\n  <tr>\n   <td>degrees(mesure) \\\nradians(mesure) \\\ngrades(mesure)\n   </td>\n   <td>Convertit une mesure d\'angle en degrés, en radians ou en grades. l\'unité de mesure dépend de angleMode(). \n   </td>\n  </tr>\n  <tr>\n   <td>HALF_PI, PI, QUARTER_PI, TWO_PI\n   </td>\n   <td>Constantes permettant respectivement d\'approcher les valeurs de π/2, π, π/4, 2π\n   </td>\n  </tr>\n</table>\n\n\n\n### Géométrie\n\n\n<table>\n  <tr>\n   <td><strong>fonctions</strong>\n   </td>\n   <td><strong>description</strong>\n   </td>\n  </tr>\n  <tr>\n   <td>dist(x1,y1,x2,y2)\n   </td>\n   <td>retourne la distance entre deux points\n   </td>\n  </tr>\n  <tr>\n   <td>midPoint(x1, y1, x2, y2)\n   </td>\n   <td>retourne le milieu d\'un segment défini par deux points\n   </td>\n  </tr>\n</table>\n\n\n\n## Images\n\n\n<table>\n  <tr>\n   <td><strong>fonctions</strong>\n   </td>\n   <td><strong>description</strong>\n   </td>\n  </tr>\n  <tr>\n   <td>loadImage(chemin)\n   </td>\n   <td>Charge une image à partir d\'un chemin et crée un objet Image. Si nécessaire, l\'image peut être préchargée en plaçant l\'appel à la fonction loadImage dans la fonction preload.\n   </td>\n  </tr>\n  <tr>\n   <td>background(Image)\n   </td>\n   <td>Affiche une Image en fond d\'écran\n   </td>\n  </tr>\n  <tr>\n   <td>image(image, x, y)\n   </td>\n   <td>Affiche une Image en plaçant le pixel en haut à gauche au point de coordonnées (x, y) dans la zone de dessin.\n   </td>\n  </tr>\n  <tr>\n   <td>copy_image(picture: Image, rect=None) -> Image\n   </td>\n   <td>retourne une copie de picture ou une partie de picture au dimensions de rect\n   </td>\n  </tr>\n  <tr>\n   <td>get_pixel_color(picture: Image, pos: tuple) -> tuple\n   </td>\n   <td>retourne la valeur de la couleur d\'un pixel d\'une image (picture)\n<p>\nsous la forme d\'un tuple\n   </td>\n  </tr>\n  <tr>\n   <td>resize_image(picture:Image,size : tuple\n   </td>\n   <td>retourne une image redimensionné en fonction de size : (largeur,hauteur) \n   </td>\n  </tr>\n</table>\n\n\n\n## Transformations\n\n\n<table>\n  <tr>\n   <td><strong>fonctions</strong>\n   </td>\n   <td><strong>description</strong>\n   </td>\n  </tr>\n  <tr>\n   <td>translation(x,y)\n   </td>\n   <td>applique une translation à toutes les fonctions de dessin et d\'image. x et y sont des valeurs relatives qui s\'ajoutent aux translations précédentes.\n<p>\nLa translation est remise à zéro avant chaque exécution de la fonction draw().\n   </td>\n  </tr>\n  <tr>\n   <td>get_translate()\n   </td>\n   <td>retourne la valeur de la translation sous la forme d\'un tuple (x,y)\n   </td>\n  </tr>\n  <tr>\n   <td>init_translate()\n   </td>\n   <td>Force la remise à zéro de la translation. (A utiliser dans la fonction draw() en cas de besoin \n   </td>\n  </tr>\n  <tr>\n   <td>rotate(angle,axis)\n   </td>\n   <td>applique une rotation &lt;angle> par rapport à &lt;axis>. à toutes les fonctions de dessin et d\'image. angle est une valeur absolue. Par défaut axis vaut (0,0). Cette fonction retourne la valeur précédente prise par la fonction sous la forme d\'un tuple.\n   </td>\n  </tr>\n  <tr>\n   <td>flip_h(axe_h)\n   </td>\n   <td>entraîne une symétrie horizontale par rapport à la droite y = axe_h\n   </td>\n  </tr>\n  <tr>\n   <td>flip_v(axe_v)\n   </td>\n   <td>entraîne une symétrie verticale par rapport à la droite x = axe_v\n   </td>\n  </tr>\n</table>\n\n\n\n## Temporisations\n\n\n\n<table>\n  <tr>\n   <td><strong>fonctions</strong>\n   </td>\n   <td><strong>description</strong>\n   </td>\n  </tr>\n  <tr>\n   <td>t=Tempo(duree_ms)\n   </td>\n   <td>t=Tempo(500) créer un objet de temporisation t de durée 500 ms qui se relance indéfiniment. \n<img src="./images/image2.png">\n   </td>\n  </tr>\n  <tr>\n   <td>t.fin()\n   </td>\n   <td>renvoie True lorsque la temporisation est terminée. Pour notre exemple au bout de 500 ms.\n   </td>\n  </tr>\n  <tr>\n   <td>t.is_on()\n   </td>\n   <td>renvoie True si la temporisation est à on.\n   </td>\n  </tr>\n  <tr>\n   <td>t.is_off()\n   </td>\n   <td>renvoie True si la temporisation est à off.\n   </td>\n  </tr>\n  <tr>\n   <td>t.set_tempo(duree_ms)\n   </td>\n   <td>permet de réinitialiser la temporisation avec une nouvelle valeur.\n   </td>\n  </tr>\n  <tr>\n   <td>t.reset()\n   </td>\n   <td>force le redémarrage de la temporisation.\n   </td>\n  </tr>\n   <td>t=Monostable(duree_ms)\n   </td>\n   <td>t=Monostable(500) créer un objet de temporisation t de durée 500 ms qui ne se relance qu\'après execution de la methode reset() \n   </td>\n  </tr>\n</table>',
    'author': 'Pierre Lemaitre',
    'author_email': 'oultetman@sfr.fr',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
