# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['reasoner_validator',
 'reasoner_validator.biolink',
 'reasoner_validator.sri',
 'reasoner_validator.trapi']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0',
 'bmt>=1.0.2,<2.0.0',
 'fastapi>=0.68,<0.69',
 'jsonschema>=4.17.0,<5.0.0',
 'kgx>=1.7.0,<2.0.0',
 'numpy>=1.23.5,<2.0.0',
 'pydantic>=1.8.0,<2.0.0',
 'pytest==7.2.0',
 'requests>=2.28.1,<3.0.0',
 'uvicorn>=0.15,<0.16']

extras_require = \
{':extra == "docs"': ['numpydoc[docs]>=1.5.0,<2.0.0',
                      'sphinx[docs]>=5.3.0,<6.0.0',
                      'myst-parser[docs]>=0.18.1,<0.19.0']}

setup_kwargs = {
    'name': 'reasoner-validator',
    'version': '3.3.2',
    'description': 'Validation tools for Reasoner API',
    'long_description': '# Reasoner Validator\n\n[![Pyversions](https://img.shields.io/pypi/pyversions/reasoner-validator)](https://pypi.python.org/pypi/reasoner-validator)\n[![pypi](https://github.com/NCATSTranslator/reasoner-validator/workflows/pypi/badge.svg)](https://pypi.org/project/reasoner-validator/)\n[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT)\n\nThis package provides software methods to Translator components (e.g. Knowledge Providers and Autonomous Relay Agents) using *any version* of the\n[Translator Reasoner API (TRAPI)](https://github.com/NCATSTranslator/ReasonerAPI/blob/master/README.md) and the [Biolink Model](https://github.com/biolink/biolink-model/blob/master/README.md).\n\nSee [the full documentation](https://ncatstranslator.github.io/reasoner-validator/) and [the contributor guidelines](https://github.com/NCATSTranslator/reasoner-validator/blob/master/.github/CONTRIBUTING.md).\n\n# Using the Package\n\n## Python Dependency\n\nThe Reasoner Validator now requires Python 3.9 or later (some library dependencies now force this).\n\n## Installing the Module\n\nThe module may be installed directly from pypi.org.\n\n```bash\npip install reasoner-validator\n```\n\n## Installing and working with the module locally from source\n\nAs of release 3.1.6, this project uses the [poetry dependency management](https://python-poetry.org) tool to orchestrate its installation and dependencies.\n\nAfter [installing poetry](https://python-poetry.org/docs/#installation) and cloning the project, the poetry installation may be run:\n\n```bash\ngit clone https://github.com/NCATSTranslator/reasoner-validator.git\ncd reasoner-validator\npoetry install\n```\n\n## Building the Documentation Locally\n\nAll paths here are relative to the root project directory.\n\nFirst install the documentation-specific dependencies.\n\n```bash\npoetry install --extras docs\n```\n\nThe validation codes MarkDown file should first be regenerated if needed (i.e. if it was revised):\n\n```bash\ncd reasoner_validator\npython ./validation_codes.py\n```\n\nThen build the documentation locally:\n\n```bash\ncd ../docs\nmake html\n```\n\nThe resulting **index.html** and related pages are now available for viewing within the docs subfolder __build/html_.\n\n## Validation Run as a Web Service\n\nThe Reasoner Validator is available wrapped as a simple web service.  The service may be run directly or as a Docker container.\n\n### API\n\nThe web service has a single POST endpoint `/validate` taking a simple JSON request body, as follows:\n\n```json\n{\n  "trapi_version": "1.3.0",\n  "biolink_version": "3.1.1",\n  "sources": {\n    "ara_source": "infores:aragorn",\n    "kp_source": "infores:panther",\n    "kp_source_type": "primary"\n  },\n  "strict_validation": true,\n  "message": {...}\n}\n```\n\nThe request body consists of JSON data structure with two top level tag:\n\n- An **optional** `trapi_version` tag can be given a value of the TRAPI version against which the message will be validated, expressed as a SemVer string (defaults to \'latest\' if omitted; partial SemVer strings are resolved to their \'latest\' minor and patch releases). \n- An **optional** `biolink_version` tag can be given a value of the Biolink Model version against which the message knowledge graph semantic contents will be validated, expressed as a SemVer string (defaults to \'latest\' Biolink Model Toolkit supported version, if omitted). \n- An **optional** `sources` with an object dictionary (example shown) specifying the ARA and KP sources involved in the TRAPI call (specified by infores CURIE) and the expected KP provenance source type, i.e. \'primary\' implies that the KP is tagged as a \'biolink:primary_knowledge_source\'. Optional in that the root "sources" or any of the subsidiary tags may be omitted (default to None)\n- An **optional** `strict_validation` flag (default: None or \'false\'). If \'true\' then follow strict validation rules, such as treating as \'error\' states the use of `category`, `predicate` and `attribute_type_id` that are of type `abstract` or `mixin`  as errors. \n- A **mandatory** `message` tag should have as its value the complete TRAPI **Message** JSON data structure to be validated (see example below).\n\n### Running the Web Service Directly\n\nThe service may be run directly as a Python module. The web services module may be directly run, as follows. \n\n```shell\npython -m api.main\n```\n\nNote that [poetry automatically uses any existing virtual environment](https://python-poetry.org/docs/basic-usage/#using-your-virtual-environment), but you can otherwise also enter the one that is created by poetry by default:\n\n```shell\npoetry shell\n# run your commands, e.g. the web service module\nexit  # exit the poetry shell\n```\n\nGo to  http://localhost/docs to see the service documentation and to use the simple UI to input TRAPI messages for validation.\n\n### Typical Output\n\nAs an example of the kind of output to expect, if one posts the following JSON message data to the **/validate** endpoint:\n\n```json\n{\n  "trapi_version": "1.3.0",\n  "biolink_version": "3.1.1",\n  "response": {\n      "message": {\n        "query_graph": {\n            "nodes": {\n                "type-2 diabetes": {"ids": ["MONDO:0005148"]},\n                "drug": {"categories": ["biolink:Drug"]}\n            },\n            "edges": {\n                "treats": {"subject": "drug", "predicates": ["biolink:treats"], "object": "type-2 diabetes"}\n            }\n        },\n        "knowledge_graph": {\n            "nodes": {\n                "MONDO:0005148": {"name": "type-2 diabetes"},\n                "CHEBI:6801": {"name": "metformin", "categories": ["biolink:Drug"]}\n            },\n            "edges": {\n                "df87ff82": {"subject": "CHEBI:6801", "predicate": "biolink:treats", "object": "MONDO:0005148"}\n            }\n        },\n        "results": [\n            {\n                "node_bindings": {\n                    "type-2 diabetes": [{"id": "MONDO:0005148"}],\n                    "drug": [{"id": "CHEBI:6801"}]\n                },\n                "edge_bindings": {\n                    "treats": [{"id": "df87ff82"}]\n                }\n            }\n        ]\n      },\n      "workflow": [{"id": "annotate"}]\n  }\n}\n```\n\none should typically get a response body something like the following JSON validation result back:\n\n```json\n{\n  "trapi_version": "1.3.0",\n  "biolink_version": "3.1.1",\n  "messages": {\n    "information": {},\n    "warnings": {\n      "warning.knowledge_graph.node.unmapped_prefix": [\n        {\n          "node_id": "CHEBI:6801",\n          "categories": "[\'biolink:Drug\']"\n        }\n      ]\n    },\n    "errors": {\n      "error.knowledge_graph.node.category.missing": [\n        {\n          "context": "Knowledge Graph",\n          "node_id": "MONDO:0005148"\n        }\n      ],\n      "error.knowledge_graph.edge.attribute.missing": [\n        {\n          "edge_id": "CHEBI:6801--biolink:treats->MONDO:0005148"\n        }\n      ]\n    }\n  }\n}\n```\n\n### Running the Web Service within Docker\n\nThe Reasoner Validator web service may be run inside a docker container, using Docker Compose.\n\nFirst, from the root project directory, build the local docker container\n\n```shell\ndocker-compose build\n```\n\nThen, run the service:\n\n```shell\ndocker-compose up -d\n```\n\nOnce again, go to  http://localhost/docs to see the service documentation.\n\nTo stop the service:\n\n```shell\ndocker-compose down\n```\n\nOf course, the above docker-compose commands may be customized by the user to suit their needs. Note that the docker implementation assumes the use of uvicorn\n\n## Change Log\n\nSummary of earlier releases and current Change Log is [here](CHANGELOG.md).\n\n## Code Limitations (implied Future Work?)\n\n- Biolink Model release <= 2.4.8 versus 3.0.0 validation: the reasoner-validator uses the Biolink Model Toolkit. As it happens, the toolkit is not backwards compatible with at least one Biolink Model structural change from release 2.#.# to 3.#.#: the tagging of \'canonical\' predicates. That is, the 0.8.10++ toolkit reports canonical <= 2.4.8 model predicates as \'non-canonical\'.\n- This release of the Reasoner Validator Web Service will detect TRAPI 1.0.* releases but doesn\'t strive to be completely backwards compatible with them (considering that TRAPI 1.0.* is totally irrelevant now). \n- The web service validation doesn\'t do deep validation of the Results part of a TRAPI Message\n- The validation is only run on the first 1000 nodes and 100 edges of graphs, to keep the validation time tractable (this risks not having complete coverage of the graph)\n- Biolink Model toolkit is not (yet) cached so changing the model version during use will result in some latency in results\n- The validator service doesn\'t (yet) deeply validate non-core node and edge slot contents of Message Knowledge Graphs\n- The validator service doesn\'t (yet) attempt validation of Query Graph nodes and edges \'constraints\' (e.g. `biolink:Association` etc. `domain` and `range` constraints)\n- Query Graph node \'ids\' are not validated except when an associated \'categories\' parameter is provided for the given node. In general, [Query Graph Validation](https://github.com/NCATSTranslator/reasoner-validator/issues/14) could be elaborated.\n- The system should leverage the [Reasoner Pydantic Models](https://github.com/NCATSTranslator/reasoner-validator/issues/15)\n\n# Core Contributors\n\n- Kudos to Patrick Wang, who created the original implementation of the Reasoner-Validator project while with CoVar (an entrepreneurial team contributing to the Biomedical Data Translator).\n- Thanks to Kenneth Morton (CoVar) for his reviews of the latest code.\n- The project is currently being extended and maintained by Richard Bruskiewich (Delphinai Corporation, on the SRI team contributing to Translator)\n',
    'author': 'Richard Bruskiewich',
    'author_email': 'richard.bruskiewich@delphinai.com',
    'maintainer': 'Richard Bruskiewich',
    'maintainer_email': 'richard.bruskiewich@delphinai.com',
    'url': 'https://github.com/NCATSTranslator',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
