"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResolvableField = exports.Field = exports.GraphqlType = void 0;
const schema_base_1 = require("./schema-base");
/**
 * (experimental) The GraphQL Types in AppSync's GraphQL.
 *
 * GraphQL Types are the
 * building blocks for object types, queries, mutations, etc. They are
 * types like String, Int, Id or even Object Types you create.
 *
 * i.e. `String`, `String!`, `[String]`, `[String!]`, `[String]!`
 *
 * GraphQL Types are used to define the entirety of schema.
 *
 * @experimental
 */
class GraphqlType {
    /**
     * @experimental
     */
    constructor(type, options) {
        var _a, _b, _c;
        this.type = type;
        this.isList = (_a = options === null || options === void 0 ? void 0 : options.isList) !== null && _a !== void 0 ? _a : false;
        this.isRequired = (_b = options === null || options === void 0 ? void 0 : options.isRequired) !== null && _b !== void 0 ? _b : false;
        this.isRequiredList = (_c = options === null || options === void 0 ? void 0 : options.isRequiredList) !== null && _c !== void 0 ? _c : false;
        this.intermediateType = options === null || options === void 0 ? void 0 : options.intermediateType;
    }
    /**
     * (experimental) `ID` scalar type is a unique identifier. `ID` type is serialized similar to `String`.
     *
     * Often used as a key for a cache and not intended to be human-readable.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static id(options) {
        return new GraphqlType(schema_base_1.Type.ID, options);
    }
    /**
     * (experimental) `String` scalar type is a free-form human-readable text.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static string(options) {
        return new GraphqlType(schema_base_1.Type.STRING, options);
    }
    /**
     * (experimental) `Int` scalar type is a signed non-fractional numerical value.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static int(options) {
        return new GraphqlType(schema_base_1.Type.INT, options);
    }
    /**
     * (experimental) `Float` scalar type is a signed double-precision fractional value.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static float(options) {
        return new GraphqlType(schema_base_1.Type.FLOAT, options);
    }
    /**
     * (experimental) `Boolean` scalar type is a boolean value: true or false.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static boolean(options) {
        return new GraphqlType(schema_base_1.Type.BOOLEAN, options);
    }
    /**
     * (experimental) `AWSDate` scalar type represents a valid extended `ISO 8601 Date` string.
     *
     * In other words, accepts date strings in the form of `YYYY-MM-DD`. It accepts time zone offsets.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsDate(options) {
        return new GraphqlType(schema_base_1.Type.AWS_DATE, options);
    }
    /**
     * (experimental) `AWSTime` scalar type represents a valid extended `ISO 8601 Time` string.
     *
     * In other words, accepts date strings in the form of `hh:mm:ss.sss`. It accepts time zone offsets.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsTime(options) {
        return new GraphqlType(schema_base_1.Type.AWS_TIME, options);
    }
    /**
     * (experimental) `AWSDateTime` scalar type represents a valid extended `ISO 8601 DateTime` string.
     *
     * In other words, accepts date strings in the form of `YYYY-MM-DDThh:mm:ss.sssZ`. It accepts time zone offsets.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsDateTime(options) {
        return new GraphqlType(schema_base_1.Type.AWS_DATE_TIME, options);
    }
    /**
     * (experimental) `AWSTimestamp` scalar type represents the number of seconds since `1970-01-01T00:00Z`.
     *
     * Timestamps are serialized and deserialized as numbers.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsTimestamp(options) {
        return new GraphqlType(schema_base_1.Type.AWS_TIMESTAMP, options);
    }
    /**
     * (experimental) `AWSEmail` scalar type represents an email address string (i.e.`username@example.com`).
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsEmail(options) {
        return new GraphqlType(schema_base_1.Type.AWS_EMAIL, options);
    }
    /**
     * (experimental) `AWSJson` scalar type represents a JSON string.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsJson(options) {
        return new GraphqlType(schema_base_1.Type.AWS_JSON, options);
    }
    /**
     * (experimental) `AWSURL` scalar type represetns a valid URL string.
     *
     * URLs wihtout schemes or contain double slashes are considered invalid.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsUrl(options) {
        return new GraphqlType(schema_base_1.Type.AWS_URL, options);
    }
    /**
     * (experimental) `AWSPhone` scalar type represents a valid phone number. Phone numbers maybe be whitespace delimited or hyphenated.
     *
     * The number can specify a country code at the beginning, but is not required for US phone numbers.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsPhone(options) {
        return new GraphqlType(schema_base_1.Type.AWS_PHONE, options);
    }
    /**
     * (experimental) `AWSIPAddress` scalar type respresents a valid `IPv4` of `IPv6` address string.
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     * @experimental
     */
    static awsIpAddress(options) {
        return new GraphqlType(schema_base_1.Type.AWS_IP_ADDRESS, options);
    }
    /**
     * (experimental) an intermediate type to be added as an attribute (i.e. an interface or an object type).
     *
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList - intermediateType.
     * @experimental
     */
    static intermediate(options) {
        if (!(options === null || options === void 0 ? void 0 : options.intermediateType)) {
            throw new Error('GraphQL Type of interface must be configured with corresponding Intermediate Type');
        }
        return new GraphqlType(schema_base_1.Type.INTERMEDIATE, options);
    }
    /**
     * (experimental) Generate the string for this attribute.
     *
     * @experimental
     */
    toString() {
        var _a;
        // If an Object Type, we use the name of the Object Type
        let type = this.intermediateType ? (_a = this.intermediateType) === null || _a === void 0 ? void 0 : _a.name : this.type;
        // If configured as required, the GraphQL Type becomes required
        type = this.isRequired ? `${type}!` : type;
        // If configured with isXxxList, the GraphQL Type becomes a list
        type = this.isList || this.isRequiredList ? `[${type}]` : type;
        // If configured with isRequiredList, the list becomes required
        type = this.isRequiredList ? `${type}!` : type;
        return type;
    }
    /**
     * (experimental) Generate the arguments for this field.
     *
     * @experimental
     */
    argsToString() {
        return '';
    }
    /**
     * (experimental) Generate the directives for this field.
     *
     * @experimental
     */
    directivesToString(_modes) {
        return '';
    }
}
exports.GraphqlType = GraphqlType;
/**
 * (experimental) Fields build upon Graphql Types and provide typing and arguments.
 *
 * @experimental
 */
class Field extends GraphqlType {
    /**
     * @experimental
     */
    constructor(options) {
        const props = {
            isList: options.returnType.isList,
            isRequired: options.returnType.isRequired,
            isRequiredList: options.returnType.isRequiredList,
            intermediateType: options.returnType.intermediateType,
        };
        super(options.returnType.type, props);
        this.fieldOptions = options;
    }
    /**
     * (experimental) Generate the args string of this resolvable field.
     *
     * @experimental
     */
    argsToString() {
        if (!this.fieldOptions || !this.fieldOptions.args) {
            return '';
        }
        return Object.keys(this.fieldOptions.args).reduce((acc, key) => { var _a, _b; return `${acc}${key}: ${(_b = (_a = this.fieldOptions) === null || _a === void 0 ? void 0 : _a.args) === null || _b === void 0 ? void 0 : _b[key].toString()} `; }, '(').slice(0, -1) + ')';
    }
    /**
     * (experimental) Generate the directives for this field.
     *
     * @experimental
     */
    directivesToString(modes) {
        if (!this.fieldOptions || !this.fieldOptions.directives) {
            return '';
        }
        return this.fieldOptions.directives.reduce((acc, directive) => `${acc}${directive._bindToAuthModes(modes).toString()} `, '\n  ').slice(0, -1);
    }
}
exports.Field = Field;
/**
 * (experimental) Resolvable Fields build upon Graphql Types and provide fields that can resolve into operations on a data source.
 *
 * @experimental
 */
class ResolvableField extends Field {
    /**
     * @experimental
     */
    constructor(options) {
        const props = {
            returnType: options.returnType,
            args: options.args,
        };
        super(props);
        this.fieldOptions = options;
    }
}
exports.ResolvableField = ResolvableField;
//# sourceMappingURL=data:application/json;base64,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