import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::AppSync::ApiCache`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html
 * @external
 */
export interface CfnApiCacheProps {
    /**
     * `AWS::AppSync::ApiCache.ApiCachingBehavior`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-apicachingbehavior
     * @external
     */
    readonly apiCachingBehavior: string;
    /**
     * `AWS::AppSync::ApiCache.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-apiid
     * @external
     */
    readonly apiId: string;
    /**
     * `AWS::AppSync::ApiCache.Ttl`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-ttl
     * @external
     */
    readonly ttl: number;
    /**
     * `AWS::AppSync::ApiCache.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::AppSync::ApiCache.AtRestEncryptionEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-atrestencryptionenabled
     * @external
     */
    readonly atRestEncryptionEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::AppSync::ApiCache.TransitEncryptionEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-transitencryptionenabled
     * @external
     */
    readonly transitEncryptionEnabled?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AppSync::ApiCache`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html
 * @external
 * @cloudformationResource AWS::AppSync::ApiCache
 */
export declare class CfnApiCache extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppSync::ApiCache";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApiCache;
    /**
     * `AWS::AppSync::ApiCache.ApiCachingBehavior`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-apicachingbehavior
     * @external
     */
    apiCachingBehavior: string;
    /**
     * `AWS::AppSync::ApiCache.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-apiid
     * @external
     */
    apiId: string;
    /**
     * `AWS::AppSync::ApiCache.Ttl`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-ttl
     * @external
     */
    ttl: number;
    /**
     * `AWS::AppSync::ApiCache.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-type
     * @external
     */
    type: string;
    /**
     * `AWS::AppSync::ApiCache.AtRestEncryptionEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-atrestencryptionenabled
     * @external
     */
    atRestEncryptionEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::AppSync::ApiCache.TransitEncryptionEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-transitencryptionenabled
     * @external
     */
    transitEncryptionEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::AppSync::ApiCache`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApiCacheProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::AppSync::ApiKey`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apikey.html
 * @external
 */
export interface CfnApiKeyProps {
    /**
     * `AWS::AppSync::ApiKey.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apikey.html#cfn-appsync-apikey-apiid
     * @external
     */
    readonly apiId: string;
    /**
     * `AWS::AppSync::ApiKey.ApiKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apikey.html#cfn-appsync-apikey-apikeyid
     * @external
     */
    readonly apiKeyId?: string;
    /**
     * `AWS::AppSync::ApiKey.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apikey.html#cfn-appsync-apikey-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::AppSync::ApiKey.Expires`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apikey.html#cfn-appsync-apikey-expires
     * @external
     */
    readonly expires?: number;
}
/**
 * A CloudFormation `AWS::AppSync::ApiKey`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apikey.html
 * @external
 * @cloudformationResource AWS::AppSync::ApiKey
 */
export declare class CfnApiKey extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppSync::ApiKey";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApiKey;
    /**
     * @external
     * @cloudformationAttribute ApiKey
     */
    readonly attrApiKey: string;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::AppSync::ApiKey.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apikey.html#cfn-appsync-apikey-apiid
     * @external
     */
    apiId: string;
    /**
     * `AWS::AppSync::ApiKey.ApiKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apikey.html#cfn-appsync-apikey-apikeyid
     * @external
     */
    apiKeyId: string | undefined;
    /**
     * `AWS::AppSync::ApiKey.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apikey.html#cfn-appsync-apikey-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::AppSync::ApiKey.Expires`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apikey.html#cfn-appsync-apikey-expires
     * @external
     */
    expires: number | undefined;
    /**
     * Create a new `AWS::AppSync::ApiKey`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApiKeyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::AppSync::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html
 * @external
 */
export interface CfnDataSourceProps {
    /**
     * `AWS::AppSync::DataSource.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-apiid
     * @external
     */
    readonly apiId: string;
    /**
     * `AWS::AppSync::DataSource.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::AppSync::DataSource.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::AppSync::DataSource.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::AppSync::DataSource.DynamoDBConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-dynamodbconfig
     * @external
     */
    readonly dynamoDbConfig?: CfnDataSource.DynamoDBConfigProperty | cdk.IResolvable;
    /**
     * `AWS::AppSync::DataSource.ElasticsearchConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-elasticsearchconfig
     * @external
     */
    readonly elasticsearchConfig?: CfnDataSource.ElasticsearchConfigProperty | cdk.IResolvable;
    /**
     * `AWS::AppSync::DataSource.HttpConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-httpconfig
     * @external
     */
    readonly httpConfig?: CfnDataSource.HttpConfigProperty | cdk.IResolvable;
    /**
     * `AWS::AppSync::DataSource.LambdaConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-lambdaconfig
     * @external
     */
    readonly lambdaConfig?: CfnDataSource.LambdaConfigProperty | cdk.IResolvable;
    /**
     * `AWS::AppSync::DataSource.RelationalDatabaseConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-relationaldatabaseconfig
     * @external
     */
    readonly relationalDatabaseConfig?: CfnDataSource.RelationalDatabaseConfigProperty | cdk.IResolvable;
    /**
     * `AWS::AppSync::DataSource.ServiceRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-servicerolearn
     * @external
     */
    readonly serviceRoleArn?: string;
}
/**
 * A CloudFormation `AWS::AppSync::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html
 * @external
 * @cloudformationResource AWS::AppSync::DataSource
 */
export declare class CfnDataSource extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppSync::DataSource";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDataSource;
    /**
     * @external
     * @cloudformationAttribute DataSourceArn
     */
    readonly attrDataSourceArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::AppSync::DataSource.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-apiid
     * @external
     */
    apiId: string;
    /**
     * `AWS::AppSync::DataSource.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-name
     * @external
     */
    name: string;
    /**
     * `AWS::AppSync::DataSource.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-type
     * @external
     */
    type: string;
    /**
     * `AWS::AppSync::DataSource.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::AppSync::DataSource.DynamoDBConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-dynamodbconfig
     * @external
     */
    dynamoDbConfig: CfnDataSource.DynamoDBConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppSync::DataSource.ElasticsearchConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-elasticsearchconfig
     * @external
     */
    elasticsearchConfig: CfnDataSource.ElasticsearchConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppSync::DataSource.HttpConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-httpconfig
     * @external
     */
    httpConfig: CfnDataSource.HttpConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppSync::DataSource.LambdaConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-lambdaconfig
     * @external
     */
    lambdaConfig: CfnDataSource.LambdaConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppSync::DataSource.RelationalDatabaseConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-relationaldatabaseconfig
     * @external
     */
    relationalDatabaseConfig: CfnDataSource.RelationalDatabaseConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppSync::DataSource.ServiceRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-servicerolearn
     * @external
     */
    serviceRoleArn: string | undefined;
    /**
     * Create a new `AWS::AppSync::DataSource`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDataSourceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppSync::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html
 * @external
 * @cloudformationResource AWS::AppSync::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-authorizationconfig.html
     * @external
     */
    interface AuthorizationConfigProperty {
        /**
         * `CfnDataSource.AuthorizationConfigProperty.AuthorizationType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-authorizationconfig.html#cfn-appsync-datasource-authorizationconfig-authorizationtype
         * @external
         */
        readonly authorizationType: string;
        /**
         * `CfnDataSource.AuthorizationConfigProperty.AwsIamConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-authorizationconfig.html#cfn-appsync-datasource-authorizationconfig-awsiamconfig
         * @external
         */
        readonly awsIamConfig?: CfnDataSource.AwsIamConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppSync::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html
 * @external
 * @cloudformationResource AWS::AppSync::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-awsiamconfig.html
     * @external
     */
    interface AwsIamConfigProperty {
        /**
         * `CfnDataSource.AwsIamConfigProperty.SigningRegion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-awsiamconfig.html#cfn-appsync-datasource-awsiamconfig-signingregion
         * @external
         */
        readonly signingRegion?: string;
        /**
         * `CfnDataSource.AwsIamConfigProperty.SigningServiceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-awsiamconfig.html#cfn-appsync-datasource-awsiamconfig-signingservicename
         * @external
         */
        readonly signingServiceName?: string;
    }
}
/**
 * A CloudFormation `AWS::AppSync::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html
 * @external
 * @cloudformationResource AWS::AppSync::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-deltasyncconfig.html
     * @external
     */
    interface DeltaSyncConfigProperty {
        /**
         * `CfnDataSource.DeltaSyncConfigProperty.BaseTableTTL`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-deltasyncconfig.html#cfn-appsync-datasource-deltasyncconfig-basetablettl
         * @external
         */
        readonly baseTableTtl: string;
        /**
         * `CfnDataSource.DeltaSyncConfigProperty.DeltaSyncTableName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-deltasyncconfig.html#cfn-appsync-datasource-deltasyncconfig-deltasynctablename
         * @external
         */
        readonly deltaSyncTableName: string;
        /**
         * `CfnDataSource.DeltaSyncConfigProperty.DeltaSyncTableTTL`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-deltasyncconfig.html#cfn-appsync-datasource-deltasyncconfig-deltasynctablettl
         * @external
         */
        readonly deltaSyncTableTtl: string;
    }
}
/**
 * A CloudFormation `AWS::AppSync::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html
 * @external
 * @cloudformationResource AWS::AppSync::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html
     * @external
     */
    interface DynamoDBConfigProperty {
        /**
         * `CfnDataSource.DynamoDBConfigProperty.AwsRegion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html#cfn-appsync-datasource-dynamodbconfig-awsregion
         * @external
         */
        readonly awsRegion: string;
        /**
         * `CfnDataSource.DynamoDBConfigProperty.DeltaSyncConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html#cfn-appsync-datasource-dynamodbconfig-deltasyncconfig
         * @external
         */
        readonly deltaSyncConfig?: CfnDataSource.DeltaSyncConfigProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DynamoDBConfigProperty.TableName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html#cfn-appsync-datasource-dynamodbconfig-tablename
         * @external
         */
        readonly tableName: string;
        /**
         * `CfnDataSource.DynamoDBConfigProperty.UseCallerCredentials`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html#cfn-appsync-datasource-dynamodbconfig-usecallercredentials
         * @external
         */
        readonly useCallerCredentials?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.DynamoDBConfigProperty.Versioned`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html#cfn-appsync-datasource-dynamodbconfig-versioned
         * @external
         */
        readonly versioned?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppSync::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html
 * @external
 * @cloudformationResource AWS::AppSync::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-elasticsearchconfig.html
     * @external
     */
    interface ElasticsearchConfigProperty {
        /**
         * `CfnDataSource.ElasticsearchConfigProperty.AwsRegion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-elasticsearchconfig.html#cfn-appsync-datasource-elasticsearchconfig-awsregion
         * @external
         */
        readonly awsRegion: string;
        /**
         * `CfnDataSource.ElasticsearchConfigProperty.Endpoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-elasticsearchconfig.html#cfn-appsync-datasource-elasticsearchconfig-endpoint
         * @external
         */
        readonly endpoint: string;
    }
}
/**
 * A CloudFormation `AWS::AppSync::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html
 * @external
 * @cloudformationResource AWS::AppSync::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-httpconfig.html
     * @external
     */
    interface HttpConfigProperty {
        /**
         * `CfnDataSource.HttpConfigProperty.AuthorizationConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-httpconfig.html#cfn-appsync-datasource-httpconfig-authorizationconfig
         * @external
         */
        readonly authorizationConfig?: CfnDataSource.AuthorizationConfigProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.HttpConfigProperty.Endpoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-httpconfig.html#cfn-appsync-datasource-httpconfig-endpoint
         * @external
         */
        readonly endpoint: string;
    }
}
/**
 * A CloudFormation `AWS::AppSync::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html
 * @external
 * @cloudformationResource AWS::AppSync::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-lambdaconfig.html
     * @external
     */
    interface LambdaConfigProperty {
        /**
         * `CfnDataSource.LambdaConfigProperty.LambdaFunctionArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-lambdaconfig.html#cfn-appsync-datasource-lambdaconfig-lambdafunctionarn
         * @external
         */
        readonly lambdaFunctionArn: string;
    }
}
/**
 * A CloudFormation `AWS::AppSync::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html
 * @external
 * @cloudformationResource AWS::AppSync::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html
     * @external
     */
    interface RdsHttpEndpointConfigProperty {
        /**
         * `CfnDataSource.RdsHttpEndpointConfigProperty.AwsRegion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html#cfn-appsync-datasource-rdshttpendpointconfig-awsregion
         * @external
         */
        readonly awsRegion: string;
        /**
         * `CfnDataSource.RdsHttpEndpointConfigProperty.AwsSecretStoreArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html#cfn-appsync-datasource-rdshttpendpointconfig-awssecretstorearn
         * @external
         */
        readonly awsSecretStoreArn: string;
        /**
         * `CfnDataSource.RdsHttpEndpointConfigProperty.DatabaseName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html#cfn-appsync-datasource-rdshttpendpointconfig-databasename
         * @external
         */
        readonly databaseName?: string;
        /**
         * `CfnDataSource.RdsHttpEndpointConfigProperty.DbClusterIdentifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html#cfn-appsync-datasource-rdshttpendpointconfig-dbclusteridentifier
         * @external
         */
        readonly dbClusterIdentifier: string;
        /**
         * `CfnDataSource.RdsHttpEndpointConfigProperty.Schema`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html#cfn-appsync-datasource-rdshttpendpointconfig-schema
         * @external
         */
        readonly schema?: string;
    }
}
/**
 * A CloudFormation `AWS::AppSync::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html
 * @external
 * @cloudformationResource AWS::AppSync::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-relationaldatabaseconfig.html
     * @external
     */
    interface RelationalDatabaseConfigProperty {
        /**
         * `CfnDataSource.RelationalDatabaseConfigProperty.RdsHttpEndpointConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-relationaldatabaseconfig.html#cfn-appsync-datasource-relationaldatabaseconfig-rdshttpendpointconfig
         * @external
         */
        readonly rdsHttpEndpointConfig?: CfnDataSource.RdsHttpEndpointConfigProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.RelationalDatabaseConfigProperty.RelationalDatabaseSourceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-relationaldatabaseconfig.html#cfn-appsync-datasource-relationaldatabaseconfig-relationaldatabasesourcetype
         * @external
         */
        readonly relationalDatabaseSourceType: string;
    }
}
/**
 * Properties for defining a `AWS::AppSync::FunctionConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html
 * @external
 */
export interface CfnFunctionConfigurationProps {
    /**
     * `AWS::AppSync::FunctionConfiguration.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-apiid
     * @external
     */
    readonly apiId: string;
    /**
     * `AWS::AppSync::FunctionConfiguration.DataSourceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-datasourcename
     * @external
     */
    readonly dataSourceName: string;
    /**
     * `AWS::AppSync::FunctionConfiguration.FunctionVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-functionversion
     * @external
     */
    readonly functionVersion: string;
    /**
     * `AWS::AppSync::FunctionConfiguration.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::AppSync::FunctionConfiguration.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::AppSync::FunctionConfiguration.RequestMappingTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-requestmappingtemplate
     * @external
     */
    readonly requestMappingTemplate?: string;
    /**
     * `AWS::AppSync::FunctionConfiguration.RequestMappingTemplateS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-requestmappingtemplates3location
     * @external
     */
    readonly requestMappingTemplateS3Location?: string;
    /**
     * `AWS::AppSync::FunctionConfiguration.ResponseMappingTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-responsemappingtemplate
     * @external
     */
    readonly responseMappingTemplate?: string;
    /**
     * `AWS::AppSync::FunctionConfiguration.ResponseMappingTemplateS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-responsemappingtemplates3location
     * @external
     */
    readonly responseMappingTemplateS3Location?: string;
    /**
     * `AWS::AppSync::FunctionConfiguration.SyncConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-syncconfig
     * @external
     */
    readonly syncConfig?: CfnFunctionConfiguration.SyncConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AppSync::FunctionConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html
 * @external
 * @cloudformationResource AWS::AppSync::FunctionConfiguration
 */
export declare class CfnFunctionConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppSync::FunctionConfiguration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFunctionConfiguration;
    /**
     * @external
     * @cloudformationAttribute DataSourceName
     */
    readonly attrDataSourceName: string;
    /**
     * @external
     * @cloudformationAttribute FunctionArn
     */
    readonly attrFunctionArn: string;
    /**
     * @external
     * @cloudformationAttribute FunctionId
     */
    readonly attrFunctionId: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::AppSync::FunctionConfiguration.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-apiid
     * @external
     */
    apiId: string;
    /**
     * `AWS::AppSync::FunctionConfiguration.DataSourceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-datasourcename
     * @external
     */
    dataSourceName: string;
    /**
     * `AWS::AppSync::FunctionConfiguration.FunctionVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-functionversion
     * @external
     */
    functionVersion: string;
    /**
     * `AWS::AppSync::FunctionConfiguration.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-name
     * @external
     */
    name: string;
    /**
     * `AWS::AppSync::FunctionConfiguration.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::AppSync::FunctionConfiguration.RequestMappingTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-requestmappingtemplate
     * @external
     */
    requestMappingTemplate: string | undefined;
    /**
     * `AWS::AppSync::FunctionConfiguration.RequestMappingTemplateS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-requestmappingtemplates3location
     * @external
     */
    requestMappingTemplateS3Location: string | undefined;
    /**
     * `AWS::AppSync::FunctionConfiguration.ResponseMappingTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-responsemappingtemplate
     * @external
     */
    responseMappingTemplate: string | undefined;
    /**
     * `AWS::AppSync::FunctionConfiguration.ResponseMappingTemplateS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-responsemappingtemplates3location
     * @external
     */
    responseMappingTemplateS3Location: string | undefined;
    /**
     * `AWS::AppSync::FunctionConfiguration.SyncConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html#cfn-appsync-functionconfiguration-syncconfig
     * @external
     */
    syncConfig: CfnFunctionConfiguration.SyncConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::AppSync::FunctionConfiguration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFunctionConfigurationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppSync::FunctionConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html
 * @external
 * @cloudformationResource AWS::AppSync::FunctionConfiguration
 */
export declare namespace CfnFunctionConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-functionconfiguration-lambdaconflicthandlerconfig.html
     * @external
     */
    interface LambdaConflictHandlerConfigProperty {
        /**
         * `CfnFunctionConfiguration.LambdaConflictHandlerConfigProperty.LambdaConflictHandlerArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-functionconfiguration-lambdaconflicthandlerconfig.html#cfn-appsync-functionconfiguration-lambdaconflicthandlerconfig-lambdaconflicthandlerarn
         * @external
         */
        readonly lambdaConflictHandlerArn?: string;
    }
}
/**
 * A CloudFormation `AWS::AppSync::FunctionConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-functionconfiguration.html
 * @external
 * @cloudformationResource AWS::AppSync::FunctionConfiguration
 */
export declare namespace CfnFunctionConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-functionconfiguration-syncconfig.html
     * @external
     */
    interface SyncConfigProperty {
        /**
         * `CfnFunctionConfiguration.SyncConfigProperty.ConflictDetection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-functionconfiguration-syncconfig.html#cfn-appsync-functionconfiguration-syncconfig-conflictdetection
         * @external
         */
        readonly conflictDetection: string;
        /**
         * `CfnFunctionConfiguration.SyncConfigProperty.ConflictHandler`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-functionconfiguration-syncconfig.html#cfn-appsync-functionconfiguration-syncconfig-conflicthandler
         * @external
         */
        readonly conflictHandler?: string;
        /**
         * `CfnFunctionConfiguration.SyncConfigProperty.LambdaConflictHandlerConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-functionconfiguration-syncconfig.html#cfn-appsync-functionconfiguration-syncconfig-lambdaconflicthandlerconfig
         * @external
         */
        readonly lambdaConflictHandlerConfig?: CfnFunctionConfiguration.LambdaConflictHandlerConfigProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::AppSync::GraphQLApi`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html
 * @external
 */
export interface CfnGraphQLApiProps {
    /**
     * `AWS::AppSync::GraphQLApi.AuthenticationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-authenticationtype
     * @external
     */
    readonly authenticationType: string;
    /**
     * `AWS::AppSync::GraphQLApi.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::AppSync::GraphQLApi.AdditionalAuthenticationProviders`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-additionalauthenticationproviders
     * @external
     */
    readonly additionalAuthenticationProviders?: Array<CfnGraphQLApi.AdditionalAuthenticationProviderProperty | cdk.IResolvable> | cdk.IResolvable | cdk.IResolvable;
    /**
     * `AWS::AppSync::GraphQLApi.LogConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-logconfig
     * @external
     */
    readonly logConfig?: CfnGraphQLApi.LogConfigProperty | cdk.IResolvable;
    /**
     * `AWS::AppSync::GraphQLApi.OpenIDConnectConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-openidconnectconfig
     * @external
     */
    readonly openIdConnectConfig?: CfnGraphQLApi.OpenIDConnectConfigProperty | cdk.IResolvable;
    /**
     * `AWS::AppSync::GraphQLApi.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-tags
     * @external
     */
    readonly tags?: Array<cdk.CfnTag | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AppSync::GraphQLApi.UserPoolConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-userpoolconfig
     * @external
     */
    readonly userPoolConfig?: CfnGraphQLApi.UserPoolConfigProperty | cdk.IResolvable;
    /**
     * `AWS::AppSync::GraphQLApi.XrayEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-xrayenabled
     * @external
     */
    readonly xrayEnabled?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AppSync::GraphQLApi`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html
 * @external
 * @cloudformationResource AWS::AppSync::GraphQLApi
 */
export declare class CfnGraphQLApi extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppSync::GraphQLApi";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnGraphQLApi;
    /**
     * @external
     * @cloudformationAttribute ApiId
     */
    readonly attrApiId: string;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute GraphQLUrl
     */
    readonly attrGraphQlUrl: string;
    /**
     * `AWS::AppSync::GraphQLApi.AuthenticationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-authenticationtype
     * @external
     */
    authenticationType: string;
    /**
     * `AWS::AppSync::GraphQLApi.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-name
     * @external
     */
    name: string;
    /**
     * `AWS::AppSync::GraphQLApi.AdditionalAuthenticationProviders`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-additionalauthenticationproviders
     * @external
     */
    additionalAuthenticationProviders: Array<CfnGraphQLApi.AdditionalAuthenticationProviderProperty | cdk.IResolvable> | cdk.IResolvable | cdk.IResolvable | undefined;
    /**
     * `AWS::AppSync::GraphQLApi.LogConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-logconfig
     * @external
     */
    logConfig: CfnGraphQLApi.LogConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppSync::GraphQLApi.OpenIDConnectConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-openidconnectconfig
     * @external
     */
    openIdConnectConfig: CfnGraphQLApi.OpenIDConnectConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppSync::GraphQLApi.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::AppSync::GraphQLApi.UserPoolConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-userpoolconfig
     * @external
     */
    userPoolConfig: CfnGraphQLApi.UserPoolConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppSync::GraphQLApi.XrayEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-xrayenabled
     * @external
     */
    xrayEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::AppSync::GraphQLApi`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGraphQLApiProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppSync::GraphQLApi`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html
 * @external
 * @cloudformationResource AWS::AppSync::GraphQLApi
 */
export declare namespace CfnGraphQLApi {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-additionalauthenticationprovider.html
     * @external
     */
    interface AdditionalAuthenticationProviderProperty {
        /**
         * `CfnGraphQLApi.AdditionalAuthenticationProviderProperty.AuthenticationType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-additionalauthenticationprovider.html#cfn-appsync-graphqlapi-additionalauthenticationprovider-authenticationtype
         * @external
         */
        readonly authenticationType: string;
        /**
         * `CfnGraphQLApi.AdditionalAuthenticationProviderProperty.OpenIDConnectConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-additionalauthenticationprovider.html#cfn-appsync-graphqlapi-additionalauthenticationprovider-openidconnectconfig
         * @external
         */
        readonly openIdConnectConfig?: CfnGraphQLApi.OpenIDConnectConfigProperty | cdk.IResolvable;
        /**
         * `CfnGraphQLApi.AdditionalAuthenticationProviderProperty.UserPoolConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-additionalauthenticationprovider.html#cfn-appsync-graphqlapi-additionalauthenticationprovider-userpoolconfig
         * @external
         */
        readonly userPoolConfig?: CfnGraphQLApi.CognitoUserPoolConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppSync::GraphQLApi`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html
 * @external
 * @cloudformationResource AWS::AppSync::GraphQLApi
 */
export declare namespace CfnGraphQLApi {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-cognitouserpoolconfig.html
     * @external
     */
    interface CognitoUserPoolConfigProperty {
        /**
         * `CfnGraphQLApi.CognitoUserPoolConfigProperty.AppIdClientRegex`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-cognitouserpoolconfig.html#cfn-appsync-graphqlapi-cognitouserpoolconfig-appidclientregex
         * @external
         */
        readonly appIdClientRegex?: string;
        /**
         * `CfnGraphQLApi.CognitoUserPoolConfigProperty.AwsRegion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-cognitouserpoolconfig.html#cfn-appsync-graphqlapi-cognitouserpoolconfig-awsregion
         * @external
         */
        readonly awsRegion?: string;
        /**
         * `CfnGraphQLApi.CognitoUserPoolConfigProperty.UserPoolId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-cognitouserpoolconfig.html#cfn-appsync-graphqlapi-cognitouserpoolconfig-userpoolid
         * @external
         */
        readonly userPoolId?: string;
    }
}
/**
 * A CloudFormation `AWS::AppSync::GraphQLApi`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html
 * @external
 * @cloudformationResource AWS::AppSync::GraphQLApi
 */
export declare namespace CfnGraphQLApi {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-logconfig.html
     * @external
     */
    interface LogConfigProperty {
        /**
         * `CfnGraphQLApi.LogConfigProperty.CloudWatchLogsRoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-logconfig.html#cfn-appsync-graphqlapi-logconfig-cloudwatchlogsrolearn
         * @external
         */
        readonly cloudWatchLogsRoleArn?: string;
        /**
         * `CfnGraphQLApi.LogConfigProperty.ExcludeVerboseContent`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-logconfig.html#cfn-appsync-graphqlapi-logconfig-excludeverbosecontent
         * @external
         */
        readonly excludeVerboseContent?: boolean | cdk.IResolvable;
        /**
         * `CfnGraphQLApi.LogConfigProperty.FieldLogLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-logconfig.html#cfn-appsync-graphqlapi-logconfig-fieldloglevel
         * @external
         */
        readonly fieldLogLevel?: string;
    }
}
/**
 * A CloudFormation `AWS::AppSync::GraphQLApi`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html
 * @external
 * @cloudformationResource AWS::AppSync::GraphQLApi
 */
export declare namespace CfnGraphQLApi {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-openidconnectconfig.html
     * @external
     */
    interface OpenIDConnectConfigProperty {
        /**
         * `CfnGraphQLApi.OpenIDConnectConfigProperty.AuthTTL`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-openidconnectconfig.html#cfn-appsync-graphqlapi-openidconnectconfig-authttl
         * @external
         */
        readonly authTtl?: number;
        /**
         * `CfnGraphQLApi.OpenIDConnectConfigProperty.ClientId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-openidconnectconfig.html#cfn-appsync-graphqlapi-openidconnectconfig-clientid
         * @external
         */
        readonly clientId?: string;
        /**
         * `CfnGraphQLApi.OpenIDConnectConfigProperty.IatTTL`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-openidconnectconfig.html#cfn-appsync-graphqlapi-openidconnectconfig-iatttl
         * @external
         */
        readonly iatTtl?: number;
        /**
         * `CfnGraphQLApi.OpenIDConnectConfigProperty.Issuer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-openidconnectconfig.html#cfn-appsync-graphqlapi-openidconnectconfig-issuer
         * @external
         */
        readonly issuer?: string;
    }
}
/**
 * A CloudFormation `AWS::AppSync::GraphQLApi`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html
 * @external
 * @cloudformationResource AWS::AppSync::GraphQLApi
 */
export declare namespace CfnGraphQLApi {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-userpoolconfig.html
     * @external
     */
    interface UserPoolConfigProperty {
        /**
         * `CfnGraphQLApi.UserPoolConfigProperty.AppIdClientRegex`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-userpoolconfig.html#cfn-appsync-graphqlapi-userpoolconfig-appidclientregex
         * @external
         */
        readonly appIdClientRegex?: string;
        /**
         * `CfnGraphQLApi.UserPoolConfigProperty.AwsRegion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-userpoolconfig.html#cfn-appsync-graphqlapi-userpoolconfig-awsregion
         * @external
         */
        readonly awsRegion?: string;
        /**
         * `CfnGraphQLApi.UserPoolConfigProperty.DefaultAction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-userpoolconfig.html#cfn-appsync-graphqlapi-userpoolconfig-defaultaction
         * @external
         */
        readonly defaultAction?: string;
        /**
         * `CfnGraphQLApi.UserPoolConfigProperty.UserPoolId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-userpoolconfig.html#cfn-appsync-graphqlapi-userpoolconfig-userpoolid
         * @external
         */
        readonly userPoolId?: string;
    }
}
/**
 * Properties for defining a `AWS::AppSync::GraphQLSchema`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlschema.html
 * @external
 */
export interface CfnGraphQLSchemaProps {
    /**
     * `AWS::AppSync::GraphQLSchema.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlschema.html#cfn-appsync-graphqlschema-apiid
     * @external
     */
    readonly apiId: string;
    /**
     * `AWS::AppSync::GraphQLSchema.Definition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlschema.html#cfn-appsync-graphqlschema-definition
     * @external
     */
    readonly definition?: string;
    /**
     * `AWS::AppSync::GraphQLSchema.DefinitionS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlschema.html#cfn-appsync-graphqlschema-definitions3location
     * @external
     */
    readonly definitionS3Location?: string;
}
/**
 * A CloudFormation `AWS::AppSync::GraphQLSchema`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlschema.html
 * @external
 * @cloudformationResource AWS::AppSync::GraphQLSchema
 */
export declare class CfnGraphQLSchema extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppSync::GraphQLSchema";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnGraphQLSchema;
    /**
     * `AWS::AppSync::GraphQLSchema.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlschema.html#cfn-appsync-graphqlschema-apiid
     * @external
     */
    apiId: string;
    /**
     * `AWS::AppSync::GraphQLSchema.Definition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlschema.html#cfn-appsync-graphqlschema-definition
     * @external
     */
    definition: string | undefined;
    /**
     * `AWS::AppSync::GraphQLSchema.DefinitionS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlschema.html#cfn-appsync-graphqlschema-definitions3location
     * @external
     */
    definitionS3Location: string | undefined;
    /**
     * Create a new `AWS::AppSync::GraphQLSchema`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGraphQLSchemaProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::AppSync::Resolver`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html
 * @external
 */
export interface CfnResolverProps {
    /**
     * `AWS::AppSync::Resolver.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-apiid
     * @external
     */
    readonly apiId: string;
    /**
     * `AWS::AppSync::Resolver.FieldName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-fieldname
     * @external
     */
    readonly fieldName: string;
    /**
     * `AWS::AppSync::Resolver.TypeName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-typename
     * @external
     */
    readonly typeName: string;
    /**
     * `AWS::AppSync::Resolver.CachingConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-cachingconfig
     * @external
     */
    readonly cachingConfig?: CfnResolver.CachingConfigProperty | cdk.IResolvable;
    /**
     * `AWS::AppSync::Resolver.DataSourceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-datasourcename
     * @external
     */
    readonly dataSourceName?: string;
    /**
     * `AWS::AppSync::Resolver.Kind`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-kind
     * @external
     */
    readonly kind?: string;
    /**
     * `AWS::AppSync::Resolver.PipelineConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-pipelineconfig
     * @external
     */
    readonly pipelineConfig?: CfnResolver.PipelineConfigProperty | cdk.IResolvable;
    /**
     * `AWS::AppSync::Resolver.RequestMappingTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-requestmappingtemplate
     * @external
     */
    readonly requestMappingTemplate?: string;
    /**
     * `AWS::AppSync::Resolver.RequestMappingTemplateS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-requestmappingtemplates3location
     * @external
     */
    readonly requestMappingTemplateS3Location?: string;
    /**
     * `AWS::AppSync::Resolver.ResponseMappingTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-responsemappingtemplate
     * @external
     */
    readonly responseMappingTemplate?: string;
    /**
     * `AWS::AppSync::Resolver.ResponseMappingTemplateS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-responsemappingtemplates3location
     * @external
     */
    readonly responseMappingTemplateS3Location?: string;
    /**
     * `AWS::AppSync::Resolver.SyncConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-syncconfig
     * @external
     */
    readonly syncConfig?: CfnResolver.SyncConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AppSync::Resolver`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html
 * @external
 * @cloudformationResource AWS::AppSync::Resolver
 */
export declare class CfnResolver extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppSync::Resolver";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnResolver;
    /**
     * @external
     * @cloudformationAttribute FieldName
     */
    readonly attrFieldName: string;
    /**
     * @external
     * @cloudformationAttribute ResolverArn
     */
    readonly attrResolverArn: string;
    /**
     * @external
     * @cloudformationAttribute TypeName
     */
    readonly attrTypeName: string;
    /**
     * `AWS::AppSync::Resolver.ApiId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-apiid
     * @external
     */
    apiId: string;
    /**
     * `AWS::AppSync::Resolver.FieldName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-fieldname
     * @external
     */
    fieldName: string;
    /**
     * `AWS::AppSync::Resolver.TypeName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-typename
     * @external
     */
    typeName: string;
    /**
     * `AWS::AppSync::Resolver.CachingConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-cachingconfig
     * @external
     */
    cachingConfig: CfnResolver.CachingConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppSync::Resolver.DataSourceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-datasourcename
     * @external
     */
    dataSourceName: string | undefined;
    /**
     * `AWS::AppSync::Resolver.Kind`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-kind
     * @external
     */
    kind: string | undefined;
    /**
     * `AWS::AppSync::Resolver.PipelineConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-pipelineconfig
     * @external
     */
    pipelineConfig: CfnResolver.PipelineConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppSync::Resolver.RequestMappingTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-requestmappingtemplate
     * @external
     */
    requestMappingTemplate: string | undefined;
    /**
     * `AWS::AppSync::Resolver.RequestMappingTemplateS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-requestmappingtemplates3location
     * @external
     */
    requestMappingTemplateS3Location: string | undefined;
    /**
     * `AWS::AppSync::Resolver.ResponseMappingTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-responsemappingtemplate
     * @external
     */
    responseMappingTemplate: string | undefined;
    /**
     * `AWS::AppSync::Resolver.ResponseMappingTemplateS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-responsemappingtemplates3location
     * @external
     */
    responseMappingTemplateS3Location: string | undefined;
    /**
     * `AWS::AppSync::Resolver.SyncConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-syncconfig
     * @external
     */
    syncConfig: CfnResolver.SyncConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::AppSync::Resolver`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnResolverProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppSync::Resolver`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html
 * @external
 * @cloudformationResource AWS::AppSync::Resolver
 */
export declare namespace CfnResolver {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-resolver-cachingconfig.html
     * @external
     */
    interface CachingConfigProperty {
        /**
         * `CfnResolver.CachingConfigProperty.CachingKeys`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-resolver-cachingconfig.html#cfn-appsync-resolver-cachingconfig-cachingkeys
         * @external
         */
        readonly cachingKeys?: string[];
        /**
         * `CfnResolver.CachingConfigProperty.Ttl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-resolver-cachingconfig.html#cfn-appsync-resolver-cachingconfig-ttl
         * @external
         */
        readonly ttl?: number;
    }
}
/**
 * A CloudFormation `AWS::AppSync::Resolver`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html
 * @external
 * @cloudformationResource AWS::AppSync::Resolver
 */
export declare namespace CfnResolver {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-resolver-lambdaconflicthandlerconfig.html
     * @external
     */
    interface LambdaConflictHandlerConfigProperty {
        /**
         * `CfnResolver.LambdaConflictHandlerConfigProperty.LambdaConflictHandlerArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-resolver-lambdaconflicthandlerconfig.html#cfn-appsync-resolver-lambdaconflicthandlerconfig-lambdaconflicthandlerarn
         * @external
         */
        readonly lambdaConflictHandlerArn?: string;
    }
}
/**
 * A CloudFormation `AWS::AppSync::Resolver`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html
 * @external
 * @cloudformationResource AWS::AppSync::Resolver
 */
export declare namespace CfnResolver {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-resolver-pipelineconfig.html
     * @external
     */
    interface PipelineConfigProperty {
        /**
         * `CfnResolver.PipelineConfigProperty.Functions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-resolver-pipelineconfig.html#cfn-appsync-resolver-pipelineconfig-functions
         * @external
         */
        readonly functions?: string[];
    }
}
/**
 * A CloudFormation `AWS::AppSync::Resolver`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html
 * @external
 * @cloudformationResource AWS::AppSync::Resolver
 */
export declare namespace CfnResolver {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-resolver-syncconfig.html
     * @external
     */
    interface SyncConfigProperty {
        /**
         * `CfnResolver.SyncConfigProperty.ConflictDetection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-resolver-syncconfig.html#cfn-appsync-resolver-syncconfig-conflictdetection
         * @external
         */
        readonly conflictDetection: string;
        /**
         * `CfnResolver.SyncConfigProperty.ConflictHandler`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-resolver-syncconfig.html#cfn-appsync-resolver-syncconfig-conflicthandler
         * @external
         */
        readonly conflictHandler?: string;
        /**
         * `CfnResolver.SyncConfigProperty.LambdaConflictHandlerConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-resolver-syncconfig.html#cfn-appsync-resolver-syncconfig-lambdaconflicthandlerconfig
         * @external
         */
        readonly lambdaConflictHandlerConfig?: CfnResolver.LambdaConflictHandlerConfigProperty | cdk.IResolvable;
    }
}
