# import sys

import os
import io

from setuptools import setup, find_packages, Command
from os import path

root = 'monet'
name = 'monet'
version = '0.3.0'

here = path.abspath(path.dirname(__file__))
description = ('Monet: An open-source Python package for analyzing and '
               'integrating single-cell RNA-Seq data using PCA-based latent '
               'spaces.')

install_requires = [
    'pandas>=1.0.3',
    'numpy>=1.18.1',
    'scipy>=1.4.1',
    'scikit-learn>=0.22.1',
    #'plotly>=4.4.1',
    'plotly>=4.2.1',
    'click>=7, <8',
    'xlmhg>=2.5.4',
    'scanpy>=1.5.1',
    'umap-learn>=0.4.6',
]

# get long description from file
long_description = ''
with io.open(path.join(here, 'README.md'), encoding='UTF-8') as fh:
    long_description = fh.read()


class CleanCommand(Command):
    """Removes files generated by setuptools.

    """
    user_options = []

    def initialize_options(self):
        pass

    def finalize_options(self):
        pass

    def run(self):
        error_msg = 'You must run this command in the package root!'
        if not os.getcwd() == here:
            raise OSError(error_msg)
        else:
            os.system('rm -rf ./dist ./build ./*.egg-info ')

setup(
    name=name,

    version=version,

    description=description,
    long_description=long_description,

    # homepage
    url='https://github.com/flo-compbio/monet',

    author='Florian Wagner',
    author_email='florian.compbio@gmail.com',

    license='3-clause BSD',

    # See https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        'Development Status :: 3 - Alpha',

        'Intended Audience :: Developers',
        'Intended Audience :: Science/Research',
        'Topic :: Scientific/Engineering :: Bio-Informatics',

        'License :: OSI Approved :: BSD License',

        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],

    keywords='',

    packages=find_packages(exclude=['docs', 'tests*']),

    # libraries = [],

    install_requires=install_requires,

    # tests_require=[],

    extras_require={
        'docs': [
        ],
        'tests': [
            'pytest>=5.2.1',
            'pytest-cov>=2.7.1',
        ],
    },

    # data
    package_data={
        'monet': [
            'data/gene_lists/*.txt',
            'data/test/*',
        ]
    },

    entry_points={
        'console_scripts': [
            'enhance.py = monet.denoise.cli:run_enhance',
        ],
    },

    cmdclass={
        'clean': CleanCommand,
    },

)
