# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['RLTest', 'RLTest.Enterprise']

package_data = \
{'': ['*']}

install_requires = \
['distro>=1.5.0,<2.0.0',
 'psutil==5.8.0',
 'pytest-cov==2.5',
 'redis>=4.2.2,<5.0.0']

entry_points = \
{'console_scripts': ['RLTest = RLTest.__main__:main']}

setup_kwargs = {
    'name': 'rltest',
    'version': '0.5.8',
    'description': 'Redis Labs Test Framework, allow to run tests on redis and modules on a variety of environments',
    'long_description': '[![license](https://img.shields.io/github/license/RedisLabsModules/RLTest.svg)](https://github.com/RedisLabsModules/RLTest/blob/master/LICENSE)\n[![PyPI version](https://badge.fury.io/py/rltest.svg)](https://badge.fury.io/py/rltest)\n[![CI](https://github.com/RedisLabsModules/RLTest/workflows/CI/badge.svg)](https://github.com/RedisLabsModules/RLTest/actions)\n[![Version](https://img.shields.io/github/release/RedisLabsModules/RLTest.svg)](https://github.com/RedisLabsModules/RLTest/releases/latest)\n[![Codecov](https://codecov.io/gh/RedisLabsModules/RLTest/branch/master/graph/badge.svg)](https://codecov.io/gh/RedisLabsModules/RLTest)\n[![Known Vulnerabilities](https://snyk.io/test/github/RedisLabsModules/RLTest/badge.svg?targetFile=pyproject.toml)](https://snyk.io/test/github/RedisLabsModules/RLTest?targetFile=pyproject.toml)\n\n\n\n# RLTest\n\nRedis Labs Test Framework, allow running tests on redis and modules on a variety of environments.\n\nSupported Environment: oss, oss-cluster, enterprise, enterprise-cluster\n\nThe framework allow you to write a test without environment specification and then run the test on all supported environment.\n\n\n# Install\n```\n$ pip install git+https://github.com/RedisLabsModules/RLTest.git@master\n\n```\n\n# Usage:\n```\n$ RLTest --help\nusage: RLTest [-h] [--version] [--module MODULE] [--module-args MODULE_ARGS]\n              [--env {oss,oss-cluster,enterprise,enterprise-cluster,existing-env,cluster_existing-env}]\n              [--existing-env-addr EXISTING_ENV_ADDR]\n              [--shards_ports SHARDS_PORTS]\n              [--cluster_address CLUSTER_ADDRESS]\n              [--oss_password OSS_PASSWORD]\n              [--cluster_credentials CLUSTER_CREDENTIALS]\n              [--cluster_node_timeout CLUSTER_NODE_TIMEOUT]\n              [--internal_password INTERNAL_PASSWORD]\n              [--oss-redis-path OSS_REDIS_PATH]\n              [--enterprise-redis-path ENTERPRISE_REDIS_PATH]\n              [--stop-on-failure] [-x] [--verbose] [--debug] [-t TEST]\n              [--env-only] [--clear-logs] [--log-dir LOG_DIR] [--use-slaves]\n              [--shards-count SHARDS_COUNT] [--download-enterprise-binaries]\n              [--proxy-binary-path PROXY_BINARY_PATH]\n              [--enterprise-lib-path ENTERPRISE_LIB_PATH] [-r]\n              [--use-aof] [--use-rdb-preamble]\n              [--debug-print] [-V] [--vg-suppressions VG_SUPPRESSIONS]\n              [--vg-options VG_OPTIONS] [--vg-no-leakcheck] [--vg-verbose]\n              [--vg-no-fail-on-errors] [-i] [--debugger DEBUGGER] [-s]\n              [--check-exitcode] [--unix] [--randomize-ports] [--collect-only]\n              [--tls] [--tls-cert-file TLS_CERT_FILE]\n              [--tls-key-file TLS_KEY_FILE]\n              [--tls-ca-cert-file TLS_CA_CERT_FILE]\n\nTest Framework for redis and redis module\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --version             Print RLTest version and exit (default: False)\n  --module MODULE       path to the module file. You can use `--module` more\n                        than once but it imples that you explicitly specify\n                        `--module-args` as well. Notice that on enterprise the\n                        file should be a zip file packed with\n                        [RAMP](https://github.com/RedisLabs/RAMP). (default:\n                        None)\n  --module-args MODULE_ARGS\n                        arguments to give to the module on loading (default:\n                        None)\n  --env {oss,oss-cluster,enterprise,enterprise-cluster,existing-env,cluster_existing-env}, -e {oss,oss-cluster,enterprise,enterprise-cluster,existing-env,cluster_existing-env}\n                        env on which to run the test (default: oss)\n  --existing-env-addr EXISTING_ENV_ADDR\n                        Address of existing env, relevent only when running\n                        with existing-env, cluster_existing-env (default:\n                        localhost:6379)\n  --shards_ports SHARDS_PORTS\n                        list of ports, the shards are listening to, relevent\n                        only when running with cluster_existing-env (default:\n                        None)\n  --cluster_address CLUSTER_ADDRESS\n                        enterprise cluster ip, relevent only when running with\n                        cluster_existing-env (default: None)\n  --oss_password OSS_PASSWORD\n                        set redis password, relevant for oss and oss-cluster\n                        environment (default: None)\n  --cluster_credentials CLUSTER_CREDENTIALS\n                        enterprise cluster cluster_credentials\n                        "username:password", relevent only when running with\n                        cluster_existing-env (default: None)\n  --cluster_node_timeout CLUSTER_NODE_TIMEOUT\n                        cluster node timeout in milliseconds\n  --internal_password INTERNAL_PASSWORD\n                        Give an ability to execute commands on shards\n                        directly, relevent only when running with\n                        cluster_existing-env (default: )\n  --oss-redis-path OSS_REDIS_PATH\n                        path to the oss redis binary (default: redis-server)\n  --enterprise-redis-path ENTERPRISE_REDIS_PATH\n                        path to the entrprise redis binary (default:\n                        ~/.RLTest/opt/redislabs/bin/redis-server)\n  --stop-on-failure     stop running on failure (default: False)\n  -x, --exit-on-failure\n                        Stop test execution and exit on first assertion\n                        failure (default: False)\n  --verbose, -v         print more information about the test (default: 0)\n  --debug               stop before each test allow gdb attachment (default:\n                        False)\n  -t TEST, --test TEST  Specify test to run, in the form of "file:test"\n                        (default: None)\n  --env-only            start the env but do not run any tests (default:\n                        False)\n  --clear-logs          deleting the log direcotry before the execution\n                        (default: False)\n  --log-dir LOG_DIR     directory to write logs to (default: ./logs)\n  --use-slaves          run env with slaves enabled (default: False)\n  --shards-count SHARDS_COUNT\n                        Number shards in bdb (default: 1)\n  --download-enterprise-binaries\n                        run env with slaves enabled (default: False)\n  --proxy-binary-path PROXY_BINARY_PATH\n                        dmc proxy binary path (default:\n                        ~/.RLTest/opt/redislabs/bin/dmcproxy)\n  --enterprise-lib-path ENTERPRISE_LIB_PATH\n                        path of needed libraries to run enterprise binaries\n                        (default: ~/.RLTest/opt/redislabs/lib/)\n  -r, --env-reuse       reuse exists env, this feature is based on best\n                        efforts, if the env can not be reused then it will be\n                        taken down. (default: False)\n  --use-aof             use aof instead of rdb (default: False)\n  --use-rdb-preamble    use rdb preamble when rewriting aof file (default: True)\n  --debug-print         print debug messages (default: False)\n  -V, --vg, --use-valgrind\n                        running redis under valgrind (assuming valgrind is\n                        install on the machine) (default: False)\n  --vg-suppressions VG_SUPPRESSIONS\n                        path valgrind suppressions file (default: None)\n  --vg-options VG_OPTIONS\n                        valgrind [options] (default: None)\n  --vg-no-leakcheck     Don\'t perform a leak check (default: False)\n  --vg-verbose          Don\'t log valgrind output. Output to screen directly\n                        (default: False)\n  --vg-no-fail-on-errors\n                        Dont Fail test when valgrind reported any errors in\n                        the run.By default on RLTest the return value from\n                        Valgrind will be used to fail the tests.Use this\n                        option when you wish to dry-run valgrind but not fail\n                        the test on valgrind reported errors. (default: False)\n  -i, --interactive-debugger\n                        runs the redis on a debuger (gdb/lldb)\n                        interactivly.debugger interactive mode is only\n                        possible on a single process and so unsupported on\n                        cluste or with slaves.it is also not possible to use\n                        valgrind on interactive mode.interactive mode direcly\n                        applies: --no-output-catch and --stop-on-failure.it is\n                        also implies that only one test will be run (if --env-\n                        only was not specify), an error will be raise\n                        otherwise. (default: False)\n  --debugger DEBUGGER   Run specified command line as the debugger (default:\n                        None)\n  -s, --no-output-catch\n                        all output will be written to the stdout, no log\n                        files. (default: False)\n  --check-exitcode      Check redis process exit code (default: False)\n  --unix                Use Unix domain sockets instead of TCP (default:\n                        False)\n  --randomize-ports     Randomize Redis listening port assignment rather\n                        thanusing default port (default: False)\n  --collect-only        Collect the tests and exit (default: False)\n  --tls                 Enable TLS Support and disable the non-TLS port\n                        completely. TLS connections will be available at the\n                        default non-TLS ports. (default: False)\n  --tls-cert-file TLS_CERT_FILE\n                        /path/to/redis.crt (default: None)\n  --tls-key-file TLS_KEY_FILE\n                        /path/to/redis.key (default: None)\n  --tls-ca-cert-file TLS_CA_CERT_FILE\n                        /path/to/ca.crt (default: None)\n\n```\n\n## Sample usages\n\n### Multiple modules\n\n```\nRLTest --module modules/module1.so --module-args \'\' --module modules/module2.so --module-args \'\'\n```\n\n# Configuration File\nBy default, the framework search for configuration file on the current directory. The configuration file name is: config.txt.\nIt is possible to specify different configuration file on command line using the \'@\' prefix, for example:\n```\nRLTest @myConfig.txt # search for myConfig.txt configuration file\n```\nThe configuration file format is the same as the command line argument, i.e : \'--< param_name > < param_val >\'.\n\nIt is also possible to comment a specific lines in the configuration file using \'#\'.\n\nExample:\n\n```\n-vv\n--clear-logs\n#--debug\n```\n\n\n# Test Example\n\n```python\nfrom RLTest import Env\nimport time\n\n\nclass testExample():\n    \'\'\'\n    run all tests on a single env without taking\n    env down between tests\n    \'\'\'\n    def __init__(self):\n        self.env = Env()\n\n    def testExample(self):\n        con = self.env.getConnection()\n        con.set(\'x\', 1)\n        self.env.assertEqual(con.get(\'x\'), \'1\')\n\n    def testExample1(self):\n        con = self.env.getConnection()\n        con.set(\'x\', 1)\n        self.env.assertEqual(con.get(\'x\'), \'1\')\n        self.env.assertFalse(True)  # check failure\n\n    def testExample2(self):\n        con = self.env.getConnection()\n        con.set(\'x\', 1)\n        self.env.assertEqual(con.get(\'x\'), \'1\')\n\n\n# run each test on different env\ndef test_example():\n    env = Env()\n    con = env.getConnection()\n    con.set(\'x\', 1)\n    env.assertEqual(con.get(\'x\'), \'1\')\n\n\ndef test_example_2():\n    env = Env()\n    env.assertOk(env.cmd(\'set\', \'x\', \'1\'))\n    env.expect(\'get\', \'x\').equal(\'1\')\n\n    env.expect(\'lpush\', \'list\', \'1\', \'2\', \'3\').equal(3)\n    env.expect(\'lrange\', \'list\', \'0\', \'-1\').debugPrint().contains(\'1\')\n    env.debugPrint(\'this is some debug printing\')\n\n\ndef test_example_3():\n    env = Env(useSlaves=True, env=\'oss\')\n    con = env.getConnection()\n    con.set(\'x\', 1)\n    con2 = env.getSlaveConnection()\n    time.sleep(0.1)\n    env.assertEqual(con2.get(\'x\'), \'1\')\n\n```\n',
    'author': 'RedisLabs',
    'author_email': 'oss@redislabs.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.0',
}


setup(**setup_kwargs)
