# -*- coding: utf-8 -*-
#
# This file is part of Flask-CeleryExt
# Copyright (C) 2017 CERN.
# Copyright (C) 2022 Graz University of Technology.
#
# Flask-CeleryExt is free software; you can redistribute it and/or modify it
# under the terms of the Revised BSD License; see LICENSE file for more
# details.

"""Mapping of Invenio Celery to Celery configuration names."""

FLASK_TO_CELERY_MAPPING = {
    'CELERY_ACCEPT_CONTENT': 'accept_content',
    'CELERY_BEAT_MAX_LOOP_INTERVAL': 'beat_max_loop_interval',
    'CELERY_BEAT_SCHEDULE': 'beat_schedule',
    'CELERY_BEAT_SCHEDULER': 'beat_scheduler',
    'CELERY_BEAT_SCHEDULE_FILENAME': 'beat_schedule_filename',
    'CELERY_BEAT_SYNC_EVERY': 'beat_sync_every',
    'CELERY_BROKER_CONNECTION_MAX_RETRIES': 'broker_connection_max_retries',
    'CELERY_BROKER_CONNECTION_RETRY': 'broker_connection_retry',
    'CELERY_BROKER_CONNECTION_TIMEOUT': 'broker_connection_timeout',
    'CELERY_BROKER_FAILOVER_STRATEGY': 'broker_failover_strategy',
    'CELERY_BROKER_HEARTBEAT': 'broker_heartbeat',
    'CELERY_BROKER_LOGIN_METHOD': 'broker_login_method',
    'CELERY_BROKER_POOL_LIMIT': 'broker_pool_limit',
    'CELERY_BROKER_TRANSPORT': 'broker_transport',
    'CELERY_BROKER_TRANSPORT_OPTIONS': 'broker_transport_options',
    'CELERY_BROKER_URL': 'broker_url',
    'CELERY_BROKER_USE_SSL': 'broker_use_ssl',
    'CELERY_CACHE_BACKEND': 'cache_backend',
    'CELERY_CACHE_BACKEND_OPTIONS': 'cache_backend_options',
    'CELERY_CASSANDRA_ENTRY_TTL': 'cassandra_entry_ttl',
    'CELERY_CASSANDRA_KEYSPACE': 'cassandra_keyspace',
    'CELERY_CASSANDRA_PORT': 'cassandra_port',
    'CELERY_CASSANDRA_READ_CONSISTENCY': 'cassandra_read_consistency',
    'CELERY_CASSANDRA_SERVERS': 'cassandra_servers',
    'CELERY_CASSANDRA_TABLE': 'cassandra_table',
    'CELERY_CASSANDRA_WRITE_CONSISTENCY': 'cassandra_write_consistency',
    'CELERY_COUCHBASE_BACKEND_SETTINGS': 'couchbase_backend_settings',
    'CELERY_DATABASE_DB_NAMES': 'database_db_names',
    'CELERY_DATABASE_ENGINE_OPTIONS': 'database_engine_options',
    'CELERY_DATABASE_SHORT_LIVED_SESSIONS': 'database_short_lived_sessions',
    'CELERY_ENABLE_UTC': 'enable_utc',
    'CELERY_EVENT_QUEUE_EXPIRES': 'event_queue_expires',
    'CELERY_EVENT_QUEUE_PREFIX': 'event_queue_prefix',
    'CELERY_EVENT_QUEUE_TTL': 'event_queue_ttl',
    'CELERY_EVENT_SERIALIZER': 'event_serializer',
    'CELERY_IMPORTS': 'imports',
    'CELERY_INCLUDE': 'include',
    'CELERY_MONGODB_BACKEND_SETTINGS': 'mongodb_backend_settings',
    'CELERY_REDIS_DB': 'redis_db',
    'CELERY_REDIS_HOST': 'redis_host',
    'CELERY_REDIS_MAX_CONNECTIONS': 'redis_max_connections',
    'CELERY_REDIS_PASSWORD': 'redis_password',
    'CELERY_REDIS_PORT': 'redis_port',
    'CELERY_RESULT_BACKEND': 'result_backend',
    'CELERY_RESULT_CACHE_MAX': 'result_cache_max',
    'CELERY_RESULT_COMPRESSION': 'result_compression',
    'CELERY_RESULT_EXCHANGE': 'result_exchange',
    'CELERY_RESULT_EXCHANGE_TYPE': 'result_exchange_type',
    'CELERY_RESULT_EXPIRES': 'result_expires',
    'CELERY_RESULT_PERSISTENT': 'result_persistent',
    'CELERY_RESULT_SERIALIZER': 'result_serializer',
    'CELERY_SECURITY_CERTIFICATE': 'security_certificate',
    'CELERY_SECURITY_CERT_STORE': 'security_cert_store',
    'CELERY_SECURITY_KEY': 'security_key',
    'CELERY_TASK_ACKS_LATE': 'task_acks_late',
    'CELERY_TASK_ALWAYS_EAGER': 'task_always_eager',
    'CELERY_TASK_ANNOTATIONS': 'task_annotations',
    'CELERY_TASK_COMPRESSION': 'result_compression',
    'CELERY_TASK_CREATE_MISSING_QUEUES': 'task_create_missing_queues',
    'CELERY_TASK_DEFAULT_DELIVERY_MODE': 'task_default_delivery_mode',
    'CELERY_TASK_DEFAULT_EXCHANGE': 'task_default_exchange',
    'CELERY_TASK_DEFAULT_EXCHANGE_TYPE': 'task_default_exchange_type',
    'CELERY_TASK_DEFAULT_QUEUE': 'task_default_queue',
    'CELERY_TASK_DEFAULT_RATE_LIMIT': 'task_default_rate_limit',
    'CELERY_TASK_DEFAULT_ROUTING_KEY': 'task_default_routing_key',
    'CELERY_TASK_EAGER_PROPAGATES': 'task_eager_propagates',
    'CELERY_TASK_IGNORE_RESULT': 'task_ignore_result',
    'CELERY_TASK_PUBLISH_RETRY': 'task_publish_retry',
    'CELERY_TASK_PUBLISH_RETRY_POLICY': 'task_publish_retry_policy',
    'CELERY_TASK_QUEUES': 'task_queues',
    'CELERY_TASK_ROUTES': 'task_routes',
    'CELERY_TASK_SEND_SENT_EVENT': 'task_send_sent_event',
    'CELERY_TASK_SERIALIZER': 'task_serializer',
    'CELERY_TASK_SOFT_TIME_LIMIT': 'task_soft_time_limit',
    'CELERY_TASK_TIME_LIMIT': 'task_time_limit',
    'CELERY_TASK_TRACK_STARTED': 'task_track_started',
    'CELERY_TIMEZONE': 'timezone',
    'CELERY_WORKER_AGENT': 'worker_agent',
    'CELERY_WORKER_AUTOSCALER': 'worker_autoscaler',
    'CELERY_WORKER_CONCURRENCY': 'worker_concurrency',
    'CELERY_WORKER_CONSUMER': 'worker_consumer',
    'CELERY_WORKER_DIRECT': 'worker_direct',
    'CELERY_WORKER_DISABLE_RATE_LIMITS': 'worker_disable_rate_limits',
    'CELERY_WORKER_ENABLE_REMOTE_CONTROL': 'worker_enable_remote_control',
    'CELERY_WORKER_HIJACK_ROOT_LOGGER': 'worker_hijack_root_logger',
    'CELERY_WORKER_LOG_COLOR': 'worker_log_color',
    'CELERY_WORKER_LOG_FORMAT': 'worker_log_format',
    'CELERY_WORKER_LOST_WAIT': 'worker_lost_wait',
    'CELERY_WORKER_MAX_TASKS_PER_CHILD': 'worker_max_tasks_per_child',
    'CELERY_WORKER_POOL': 'worker_pool',
    'CELERY_WORKER_POOL_PUTLOCKS': 'worker_pool_putlocks',
    'CELERY_WORKER_POOL_RESTARTS': 'worker_pool_restarts',
    'CELERY_WORKER_PREFETCH_MULTIPLIER': 'worker_prefetch_multiplier',
    'CELERY_WORKER_REDIRECT_STDOUTS': 'worker_redirect_stdouts',
    'CELERY_WORKER_REDIRECT_STDOUTS_LEVEL': 'worker_redirect_stdouts_level',
    'CELERY_WORKER_SEND_TASK_EVENTS': 'worker_send_task_events',
    'CELERY_WORKER_STATE_DB': 'worker_state_db',
    'CELERY_WORKER_TASK_LOG_FORMAT': 'worker_task_log_format',
    'CELERY_WORKER_TIMER': 'worker_timer',
    'CELERY_WORKER_TIMER_PRECISION': 'worker_timer_precision',
    'CASSANDRA_OPTIONS': 'cassandra_options',
    'S3_ACCESS_KEY_ID': 's3_access_key_id',
    'S3_SECRET_ACCESS_KEY': 's3_secret_access_key',
    'S3_BUCKET': 's3_bucket',
    'S3_BASE_PATH': 's3_base_path',
    'S3_ENDPOINT_URL': 's3_endpoint_url',
    'S3_REGION': 's3_region',
    'ARANGODB_BACKEND_SETTINGS': 'arangodb_backend_settings',
    'REDIS_USERNAME': 'redis_username',
    'REDIS_BACKEND_USE_SSL': 'redis_backend_use_ssl',
    'RESULT_DBURI': 'result_backend',
    'ACKS_ON_FAILURE_OR_TIMEOUT': 'task_acks_on_failure_or_timeout',
    'COMPRESSION': 'task_compression',
    'TASK_REJECT_ON_WORKER_LOST': 'task_reject_on_worker_lost',
}
