class_map = {
    "total": {
        1: "spleen",
        2: "kidney_right",
        3: "kidney_left",
        4: "gallbladder",
        5: "liver",
        6: "stomach",
        7: "aorta",
        8: "inferior_vena_cava",
        9: "portal_vein_and_splenic_vein",
        10: "pancreas",
        11: "adrenal_gland_right",
        12: "adrenal_gland_left",
        13: "lung_upper_lobe_left",
        14: "lung_lower_lobe_left",
        15: "lung_upper_lobe_right",
        16: "lung_middle_lobe_right",
        17: "lung_lower_lobe_right",
        18: "vertebrae_L5",
        19: "vertebrae_L4",
        20: "vertebrae_L3",
        21: "vertebrae_L2",
        22: "vertebrae_L1",
        23: "vertebrae_T12",
        24: "vertebrae_T11",
        25: "vertebrae_T10",
        26: "vertebrae_T9",
        27: "vertebrae_T8",
        28: "vertebrae_T7",
        29: "vertebrae_T6",
        30: "vertebrae_T5",
        31: "vertebrae_T4",
        32: "vertebrae_T3",
        33: "vertebrae_T2",
        34: "vertebrae_T1",
        35: "vertebrae_C7",
        36: "vertebrae_C6",
        37: "vertebrae_C5",
        38: "vertebrae_C4",
        39: "vertebrae_C3",
        40: "vertebrae_C2",
        41: "vertebrae_C1",
        42: "esophagus",
        43: "trachea",
        44: "heart_myocardium",
        45: "heart_atrium_left",
        46: "heart_ventricle_left",
        47: "heart_atrium_right",
        48: "heart_ventricle_right",
        49: "pulmonary_artery",
        50: "brain",
        51: "iliac_artery_left",
        52: "iliac_artery_right",
        53: "iliac_vena_left",
        54: "iliac_vena_right",
        55: "small_bowel",
        56: "duodenum",
        57: "colon",
        58: "rib_left_1",
        59: "rib_left_2",
        60: "rib_left_3",
        61: "rib_left_4",
        62: "rib_left_5",
        63: "rib_left_6",
        64: "rib_left_7",
        65: "rib_left_8",
        66: "rib_left_9",
        67: "rib_left_10",
        68: "rib_left_11",
        69: "rib_left_12",
        70: "rib_right_1",
        71: "rib_right_2",
        72: "rib_right_3",
        73: "rib_right_4",
        74: "rib_right_5",
        75: "rib_right_6",
        76: "rib_right_7",
        77: "rib_right_8",
        78: "rib_right_9",
        79: "rib_right_10",
        80: "rib_right_11",
        81: "rib_right_12",
        82: "humerus_left",
        83: "humerus_right",
        84: "scapula_left",
        85: "scapula_right",
        86: "clavicula_left",
        87: "clavicula_right",
        88: "femur_left",
        89: "femur_right",
        90: "hip_left",
        91: "hip_right",
        92: "sacrum",
        93: "face",
        94: "gluteus_maximus_left",
        95: "gluteus_maximus_right",
        96: "gluteus_medius_left",
        97: "gluteus_medius_right",
        98: "gluteus_minimus_left",
        99: "gluteus_minimus_right",
        100: "autochthon_left",
        101: "autochthon_right",
        102: "iliopsoas_left",
        103: "iliopsoas_right",
        104: "urinary_bladder"
    },
    "total_v2": {
        1: "spleen",
        2: "kidney_right",
        3: "kidney_left",
        4: "gallbladder",
        5: "liver",
        6: "stomach",
        7: "aorta",
        8: "inferior_vena_cava",
        9: "portal_vein_and_splenic_vein",
        10: "pancreas",
        11: "adrenal_gland_right",
        12: "adrenal_gland_left",
        13: "lung_upper_lobe_left",
        14: "lung_lower_lobe_left",
        15: "lung_upper_lobe_right",
        16: "lung_middle_lobe_right",
        17: "lung_lower_lobe_right",
        18: "vertebrae_L5",
        19: "vertebrae_L4",
        20: "vertebrae_L3",
        21: "vertebrae_L2",
        22: "vertebrae_L1",
        23: "vertebrae_T12",
        24: "vertebrae_T11",
        25: "vertebrae_T10",
        26: "vertebrae_T9",
        27: "vertebrae_T8",
        28: "vertebrae_T7",
        29: "vertebrae_T6",
        30: "vertebrae_T5",
        31: "vertebrae_T4",
        32: "vertebrae_T3",
        33: "vertebrae_T2",
        34: "vertebrae_T1",
        35: "vertebrae_C7",
        36: "vertebrae_C6",
        37: "vertebrae_C5",
        38: "vertebrae_C4",
        39: "vertebrae_C3",
        40: "vertebrae_C2",
        41: "vertebrae_C1",
        42: "esophagus",
        43: "trachea",
        44: "heart_myocardium",
        45: "heart_atrium_left",
        46: "heart_ventricle_left",
        47: "heart_atrium_right",
        48: "heart_ventricle_right",
        49: "pulmonary_artery",
        50: "brain",
        51: "iliac_artery_left",
        52: "iliac_artery_right",
        53: "iliac_vena_left",
        54: "iliac_vena_right",
        55: "small_bowel",
        56: "duodenum",
        57: "colon",
        58: "rib_left_1",
        59: "rib_left_2",
        60: "rib_left_3",
        61: "rib_left_4",
        62: "rib_left_5",
        63: "rib_left_6",
        64: "rib_left_7",
        65: "rib_left_8",
        66: "rib_left_9",
        67: "rib_left_10",
        68: "rib_left_11",
        69: "rib_left_12",
        70: "rib_right_1",
        71: "rib_right_2",
        72: "rib_right_3",
        73: "rib_right_4",
        74: "rib_right_5",
        75: "rib_right_6",
        76: "rib_right_7",
        77: "rib_right_8",
        78: "rib_right_9",
        79: "rib_right_10",
        80: "rib_right_11",
        81: "rib_right_12",
        82: "scapula_left",
        83: "scapula_right",
        84: "clavicula_left",
        85: "clavicula_right",
        86: "hip_left",
        87: "hip_right",
        88: "sacrum",
        89: "face",
        90: "gluteus_maximus_left",
        91: "gluteus_maximus_right",
        92: "gluteus_medius_left",
        93: "gluteus_medius_right",
        94: "gluteus_minimus_left",
        95: "gluteus_minimus_right",
        96: "autochthon_left",
        97: "autochthon_right",
        98: "iliopsoas_left",
        99: "iliopsoas_right",
        100: "urinary_bladder",
        101: "femur",
        102: "patella",
        103: "tibia",
        104: "fibula",
        105: "tarsal",
        106: "metatarsal",
        107: "phalanges_feet",
        108: "humerus",
        109: "ulna",
        110: "radius",
        111: "carpal",
        112: "metacarpal",
        113: "phalanges_hand",
        114: "sternum",
        115: "skull",
        116: "subcutaneous_fat",
        117: "skeletal_muscle",
        118: "torso_fat",
        119: "spinal_cord",
    },
    # combine all ribs, vertebrae groups and left/right
    "total_v2_fast": {
        1: "spleen",
        2: "kidney",
        3: "gallbladder",
        4: "liver",
        5: "stomach",
        6: "aorta",
        7: "inferior_vena_cava",
        8: "portal_vein_and_splenic_vein",
        9: "pancreas",
        10: "adrenal_gland",
        11: "lung_upper_lobe_left",
        12: "lung_lower_lobe_left",
        13: "lung_upper_lobe_right",
        14: "lung_middle_lobe_right",
        15: "lung_lower_lobe_right",
        16: "vertebrae_lumbar",
        17: "vertebrae_thoracic",
        18: "vertebrae_cervical",
        19: "esophagus",
        20: "trachea",
        21: "heart_myocardium",
        22: "heart_atrium_left",
        23: "heart_ventricle_left",
        24: "heart_atrium_right",
        25: "heart_ventricle_right",
        26: "pulmonary_artery",
        27: "brain",
        28: "iliac_artery",
        29: "iliac_vena",
        30: "small_bowel",
        31: "duodenum",
        32: "colon",
        33: "ribs",
        34: "scapula",
        35: "clavicula",
        36: "hip",
        37: "sacrum",
        38: "face",
        39: "gluteus_maximus",
        40: "gluteus_medius",
        41: "gluteus_minimus",
        42: "autochthon",
        43: "iliopsoas",
        44: "urinary_bladder",
        45: "femur",
        46: "patella",
        47: "tibia",
        48: "fibula",
        49: "tarsal",
        50: "metatarsal",
        51: "phalanges_feet",
        52: "humerus",
        53: "ulna",
        54: "radius",
        55: "carpal",
        56: "metacarpal",
        57: "phalanges_hand",
        58: "sternum",
        59: "skull",
        60: "subcutaneous_fat",
        61: "skeletal_muscle",
        62: "torso_fat",
        63: "spinal_cord"
    },
    "lung_vessels": {
        1: "lung_vessels",
        2: "lung_trachea_bronchia"
    },
    "covid": {
        1: "lung_covid_infiltrate",
    },
    "cerebral_bleed": {
        1: "intracerebral_hemorrhage",
    },
    "hip_implant": {
        1: "hip_implant",
    },
    "coronary_arteries": {
        1: "coronary_arteries",
    },
    "body": {
        1: "body_trunc",
        2: "body_extremities",
    },
    "pleural_pericard_effusion": {
        # 1: "lung_pleural",
        2: "pleural_effusion",
        3: "pericardial_effusion",
    },
    "liver_vessels": {
        1: "liver_vessels",
        2: "liver_tumor"
    },
    "heartchambers_test": {
        1: "heart_myocardium", 
        2: "heart_atrium_left", 
        3: "heart_ventricle_left", 
        4: "heart_atrium_right", 
        5: "heart_ventricle_right", 
        6: "aorta", 
        7: "pulmonary_artery"
    },
    "bones_tissue_test" : {
        1: "femur",
        2: "patella",
        3: "tibia",
        4: "fibula",
        5: "tarsal",
        6: "metatarsal",
        7: "phalanges_feet",
        8: "humerus",
        9: "ulna",
        10: "radius",
        11: "carpal",
        12: "metacarpal",
        13: "phalanges_hand",
        14: "sternum",
        15: "skull",
        16: "subcutaneous_fat",
        17: "skeletal_muscle",
        18: "torso_fat",
        19: "spinal_cord"
    },
    "aortic_branches_test": {
        1: "brachiocephalic_trunk",  # brachiocephalic_trunc
        2: "subclavian_artery_right",
        3: "subclavian_artery_left",
        4: "common_carotid_artery_right",
        5: "common_carotid_artery_left",
        6: "brachiocephalic_vein_left",
        7: "brachiocephalic_vein_right",
        8: "atrial_appendage_left",  # less common: auricle_of_heart_left 
        9: "superior_vena_cava",
        10: "pulmunary_vein",
        11: "pulmunary_artery",
        12: "heart_atrium_left",
        13: "heart_atrium_right",
        14: "aorta",
        15: "thyroid_gland"  # thyroid
    },
    "test": {
        1: "carpal",
        2: "clavicula",
        3: "femur",
        4: "fibula",
        5: "humerus",
        6: "metacarpal",
        7: "metatarsal",
        8: "patella",
        9: "hips",
        10: "phalanges_hand",
        11: "radius",
        12: "ribs",
        13: "scapula",
        14: "skull",
        15: "spine",
        16: "sternum",
        17: "tarsal",
        18: "tibia",
        19: "phalanges_feet",
        20: "ulna"
    }
}


class_map_5_parts = {

    # 17 classes
    "class_map_part_organs": {
        1: "spleen",
        2: "kidney_right",
        3: "kidney_left",
        4: "gallbladder",
        5: "liver",
        6: "stomach",
        7: "aorta",
        8: "inferior_vena_cava",
        9: "portal_vein_and_splenic_vein",
        10: "pancreas",
        11: "adrenal_gland_right",
        12: "adrenal_gland_left",
        13: "lung_upper_lobe_left",
        14: "lung_lower_lobe_left",
        15: "lung_upper_lobe_right",
        16: "lung_middle_lobe_right",
        17: "lung_lower_lobe_right"
    },

    # 24 classes
    "class_map_part_vertebrae": {
        1: "vertebrae_L5",
        2: "vertebrae_L4",
        3: "vertebrae_L3",
        4: "vertebrae_L2",
        5: "vertebrae_L1",
        6: "vertebrae_T12",
        7: "vertebrae_T11",
        8: "vertebrae_T10",
        9: "vertebrae_T9",
        10: "vertebrae_T8",
        11: "vertebrae_T7",
        12: "vertebrae_T6",
        13: "vertebrae_T5",
        14: "vertebrae_T4",
        15: "vertebrae_T3",
        16: "vertebrae_T2",
        17: "vertebrae_T1",
        18: "vertebrae_C7",
        19: "vertebrae_C6",
        20: "vertebrae_C5",
        21: "vertebrae_C4",
        22: "vertebrae_C3",
        23: "vertebrae_C2",
        24: "vertebrae_C1"
    },

    # 18
    "class_map_part_cardiac": {
        1: "esophagus",
        2: "trachea",
        3: "heart_myocardium",
        4: "heart_atrium_left",
        5: "heart_ventricle_left",
        6: "heart_atrium_right",
        7: "heart_ventricle_right",
        8: "pulmonary_artery",
        9: "brain",
        10: "iliac_artery_left",
        11: "iliac_artery_right",
        12: "iliac_vena_left",
        13: "iliac_vena_right",
        14: "small_bowel",
        15: "duodenum",
        16: "colon",
        17: "urinary_bladder",
        18: "face"
    },

    # 21
    "class_map_part_muscles": {
        1: "humerus_left",
        2: "humerus_right",
        3: "scapula_left",
        4: "scapula_right",
        5: "clavicula_left",
        6: "clavicula_right",
        7: "femur_left",
        8: "femur_right",
        9: "hip_left",
        10: "hip_right",
        11: "sacrum",
        12: "gluteus_maximus_left",
        13: "gluteus_maximus_right",
        14: "gluteus_medius_left",
        15: "gluteus_medius_right",
        16: "gluteus_minimus_left",
        17: "gluteus_minimus_right",
        18: "autochthon_left",
        19: "autochthon_right",
        20: "iliopsoas_left",
        21: "iliopsoas_right"
    },

    # without humerus and femur
    "class_map_part_muscles_v2": {
        1: "scapula_left",
        2: "scapula_right",
        3: "clavicula_left",
        4: "clavicula_right",
        5: "hip_left",
        6: "hip_right",
        7: "sacrum",
        8: "gluteus_maximus_left",
        9: "gluteus_maximus_right",
        10: "gluteus_medius_left",
        11: "gluteus_medius_right",
        12: "gluteus_minimus_left",
        13: "gluteus_minimus_right",
        14: "autochthon_left",
        15: "autochthon_right",
        16: "iliopsoas_left",
        17: "iliopsoas_right"
    },

    # 24 classes
    # 12. ribs start from vertebrae T12
    # Small subset of population (roughly 8%) have 13. rib below 12. rib
    #  (would start from L1 then)
    #  -> this has label rib_12
    # Even smaller subset (roughly 1%) has extra rib above 1. rib   ("Halsrippe")
    #  (the extra rib would start from C7)
    #  -> this has label rib_1
    #
    # Quite often only 11 ribs (12. ribs probably so small that not found). Those 
    # cases often wrongly segmented. 
    "class_map_part_ribs": {
        1: "rib_left_1",
        2: "rib_left_2",
        3: "rib_left_3",
        4: "rib_left_4",
        5: "rib_left_5",
        6: "rib_left_6",
        7: "rib_left_7",
        8: "rib_left_8",
        9: "rib_left_9",
        10: "rib_left_10",
        11: "rib_left_11",
        12: "rib_left_12",
        13: "rib_right_1",
        14: "rib_right_2",
        15: "rib_right_3",
        16: "rib_right_4",
        17: "rib_right_5",
        18: "rib_right_6",
        19: "rib_right_7",
        20: "rib_right_8",
        21: "rib_right_9",
        22: "rib_right_10",
        23: "rib_right_11",
        24: "rib_right_12"
    },

    "class_map_part_bones" : {
        1: "femur",
        2: "patella",
        3: "tibia",
        4: "fibula",
        5: "tarsal",
        6: "metatarsal",
        7: "phalanges_feet",
        8: "humerus",
        9: "ulna",
        10: "radius",
        11: "carpal",
        12: "metacarpal",
        13: "phalanges_hand",
        14: "sternum",
        15: "skull",
        16: "subcutaneous_fat",
        17: "skeletal_muscle",
        18: "torso_fat",
        19: "spinal_cord"
    },

    "test": class_map["test"]
}


map_taskid_to_partname = {
    251: "class_map_part_organs",
    252: "class_map_part_vertebrae",
    253: "class_map_part_cardiac",
    254: "class_map_part_muscles",
    255: "class_map_part_ribs",

    517: "test"
}

# pprint({idx:v for idx, (k, v) in enumerate(a.items())}, sort_dicts=False)
