"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebappConfig = void 0;
const fs_1 = require("fs");
const os_1 = require("os");
const path_1 = require("path");
class WebappConfig {
    constructor(props) {
        this.props = props;
        this.dir = fs_1.mkdtempSync(path_1.join(os_1.tmpdir(), 'chwebapp'));
        this.path = path_1.join(this.dir, 'config.json');
        fs_1.writeFileSync(this.path, JSON.stringify(this.frontendConfig));
    }
    get frontendConfig() {
        return {
            packageLinks: this.packageLinks,
            packageTags: this.packageTags,
            featuredPackages: this.featuredPackages,
        };
    }
    get packageLinks() {
        var _a;
        const packageLinks = (_a = this.props.packageLinks) !== null && _a !== void 0 ? _a : [];
        // remove allowed domains from frontend config
        return packageLinks.map(({ allowedDomains, ...rest }) => rest);
    }
    get packageTags() {
        var _a;
        const packageTags = (_a = this.props.packageTags) !== null && _a !== void 0 ? _a : [];
        // remove conditional logic from frontend config
        return packageTags.map(({ condition, ...rest }) => rest);
    }
    get featuredPackages() {
        var _a;
        const config = (_a = this.props.featuredPackages) !== null && _a !== void 0 ? _a : {
            sections: [
                {
                    name: 'Recently updated',
                    showLastUpdated: 10,
                },
            ],
        };
        for (const section of config.sections) {
            if ((section.showPackages !== undefined && section.showLastUpdated !== undefined) ||
                (section.showPackages === undefined && section.showLastUpdated === undefined)) {
                throw new Error('Exactly one of \'showPackages\' and \'showPackages\' should be provided.');
            }
        }
        return config;
    }
}
exports.WebappConfig = WebappConfig;
//# sourceMappingURL=data:application/json;base64,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