import { IDistribution } from '@aws-cdk/aws-cloudfront';
import { Metric, MetricOptions } from '@aws-cdk/aws-cloudwatch';
import { Bucket } from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
export interface CacheInvalidatorProps {
    /**
     * The S3 Bucket served by the CloudFront distribution.
     */
    readonly bucket: Bucket;
    /**
     * The CloudFront Distribution on which to perform automated invalidation.
     */
    readonly distribution: IDistribution;
    /**
     * A path prefix to prepend to S3 object keys when computing the cache
     * invalidation paths. The value is REQUIRED to begin with a leading `/`.
     *
     * @default '/'
     */
    readonly pathPrefix?: string;
}
/**
 * Automatically invalidates paths from a CloudFront distribution based on S3
 * object updates. The invalidated paths are constructed from the S3 object keys
 * being updated, combined with an optional path prefix.
 */
export declare class CacheInvalidator extends Construct {
    constructor(scope: Construct, id: string, props: CacheInvalidatorProps);
    /**
     * The age of S3 events processed by the cache invalidator. By default this
     * is the MAXIMUM value over a 5 minutes period.
     */
    metricS3EventAge(opts: MetricOptions): Metric;
}
