import { Metric, MetricOptions } from '@aws-cdk/aws-cloudwatch';
import { IBucket } from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
import type { IPackageSource, PackageSourceBindOptions, PackageSourceBindResult } from '../package-source';
/**
 * @experimental
 */
export interface NpmJsProps {
    /**
     * (experimental) The bucket to use for staging npm packages.
     *
     * @default - a new bucket will be created.
     * @experimental
     */
    readonly stagingBucket?: IBucket;
}
/**
 * (experimental) A package source that gets package data from the npmjs.com package registry.
 *
 * @experimental
 */
export declare class NpmJs implements IPackageSource {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props?: NpmJsProps);
    /**
     * (experimental) Binds the package source to a scope and target queue.
     *
     * @experimental
     */
    bind(scope: Construct, { denyList, ingestion, licenseList, monitoring, queue, repository }: PackageSourceBindOptions): PackageSourceBindResult;
    /**
     * (experimental) The average time it took to process a changes batch.
     *
     * @experimental
     */
    metricBatchProcessingTime(opts?: MetricOptions): Metric;
    /**
     * (experimental) The total count of changes that were processed.
     *
     * @experimental
     */
    metricChangeCount(opts?: MetricOptions): Metric;
    /**
     * (experimental) The last sequence number that was processed.
     *
     * This metric can be used to
     * discover when a sequence reset has happened in the CouchDB instance.
     *
     * @experimental
     */
    metricLastSeq(opts?: MetricOptions): Metric;
    /**
     * @experimental
     */
    metricNpmJsChangeAge(opts?: MetricOptions): Metric;
    /**
     * (experimental) The age of the oldest package version that was processed.
     *
     * @experimental
     */
    metricPackageVersionAge(opts?: MetricOptions): Metric;
    /**
     * (experimental) The total count of package versions that were inspected.
     *
     * @experimental
     */
    metricPackageVersionCount(opts?: MetricOptions): Metric;
    /**
     * (experimental) The total count of package versions that were deemed relevant.
     *
     * @experimental
     */
    metricRelevantPackageVersions(opts?: MetricOptions): Metric;
    /**
     * (experimental) The amount of time that was remaining when the lambda returned in order to avoid hitting a timeout.
     *
     * @experimental
     */
    metricRemainingTime(opts?: MetricOptions): Metric;
    /**
     * (experimental) The total count of staging failures.
     *
     * @experimental
     */
    metricStagingFailureCount(opts?: MetricOptions): Metric;
    /**
     * (experimental) The average time it took to stage a package to S3.
     *
     * @experimental
     */
    metricStagingTime(opts?: MetricOptions): Metric;
    /**
     * (experimental) The amount of changes that were not processed due to having an invalid format.
     *
     * @experimental
     */
    metricUnprocessableEntity(opts?: MetricOptions): Metric;
}
