# YACC (Yet another case converter) [![PyPI version](https://badge.fury.io/py/yascc.svg)](https://badge.fury.io/py/yascc)

Just wanted to shave off extra seconds from standard regex based camelcase to snakecase conversion implementation

```
pip install yascc
```

example usage:

```
>>> from yascc import camelcase
>>> camelcase.to_snake_case('yetAnotherCaseConverter')
'yet_another_case_converter'
>>> from yascc import snakecase
>>> snakecase.to_camel_case('yet_another_case_converter')
'yetAnotherCaseConverter'
>>>
```

benchmarks (against drf implementation of camelization):
```
------------------------------------------------------------------------------------------------------- benchmark: 8 tests -------------------------------------------------------------------------------------------------------
Name (time in ns)                               Min                    Max                   Mean                StdDev                 Median                 IQR            Outliers  OPS (Kops/s)            Rounds  Iterations
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
test_camelize_benchmark[c]                 487.4979 (1.0)       2,883.3485 (1.0)         500.2592 (1.0)         20.2490 (1.0)         497.8996 (1.0)        6.2486 (1.0)     3411;6076    1,998.9638 (1.0)       89550          20
test_decamelize_benchmark[c]               768.7486 (1.58)      6,831.2482 (2.37)        800.5022 (1.60)        55.7327 (2.75)        795.8501 (1.60)      12.5001 (2.00)    1164;7342    1,249.2157 (0.62)      60607          20
test_camelize_list_benchmark[c]          1,347.0029 (2.76)     14,527.6620 (5.04)      1,436.5677 (2.87)       107.9171 (5.33)      1,430.6667 (2.87)      27.9979 (4.48)    2554;8950      696.1036 (0.35)     166668           3
test_decamelize_list_benchmark[c]        2,167.0130 (4.45)     20,499.9815 (7.11)      2,390.8258 (4.78)       182.2880 (9.00)      2,374.9890 (4.77)      83.9937 (13.44)     781;777      418.2655 (0.21)      41522           1
test_decamelize_benchmark[drf]           2,624.9909 (5.38)     36,458.0192 (12.64)     2,811.5553 (5.62)       363.6106 (17.96)     2,791.9887 (5.61)      82.9459 (13.27)    206;1805      355.6750 (0.18)      41667           1
test_camelize_benchmark[drf]             5,540.9619 (11.37)    40,624.9892 (14.09)     5,781.0103 (11.56)      465.7064 (23.00)     5,749.9856 (11.55)    124.9718 (20.00)    624;2617      172.9801 (0.09)      43322           1
test_camelize_list_benchmark[drf]       14,499.9940 (29.74)    73,749.9795 (25.58)    14,871.2123 (29.73)      674.1604 (33.29)    14,792.0218 (29.71)    125.0301 (20.01)    688;2011       67.2440 (0.03)      30497           1
test_decamelize_list_benchmark[drf]     27,041.9987 (55.47)    63,790.9980 (22.12)    27,616.0604 (55.20)    1,057.0720 (52.20)    27,416.9724 (55.07)    208.9655 (33.44)     235;452       36.2108 (0.02)       4382           1
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
```
