# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/06_SNPmatch.ipynb (unless otherwise specified).

__all__ = ['shorten_id', 'match_ss_with_bim', 'check_ss', 'compare_snps', 'snp_match']

# Cell
from xxhash import xxh32 as xxh

# Cell
def shorten_id(x):
    return x if len(x) < 30 else f"{x.split('_')[0]}_{xxh(x).hexdigest()}"

# Cell
import pandas as pd
import numpy as np
from Bio.Seq import Seq

# Cell
def match_ss_with_bim(query,subject):
    '''snp match case in one dataset'''
    query = query.itertuples()
    subject = subject.itertuples()
    qi,si = next(query,None),next(subject,None)
    flip=[]
    while(qi and si):
        if qi.CHR>si.chrom:
            si = next(subject,None)
            continue
        elif qi.CHR<si.chrom:
            raise Exception(qi,'is not in genodata')
        else:
            if qi.POS>si.pos:
                si = next(subject,None)
                continue
            elif qi.POS<si.pos:
                raise Exception(qi,'is not in genodata')
            else:
                #Fix me
                #same pos has multiple snps
                #query compare with each of them in subject
                if qi.ALT == si.a1 and qi.REF == si.a0:
                    flip.append(False)
                elif qi.ALT == si.a0 and qi.REF == si.a1:
                    flip.append(True)
                else:
                    si = next(subject,None)
                    continue
                qi = next(query,None)
                si = next(subject,None)
    return flip

# Cell
def check_ss(ss,bim):
    ss.CHR = ss.CHR.astype(int)
    bim.chrom = bim.chrom.astype(int)
    flip = np.array(match_ss_with_bim(ss,bim))
    print('Total SNPs',len(flip),'. Flip SNPs',sum(flip))
    #shift ref and alt for fliped snps and change snp's name and the sign of beta
    if flip.any():
        fss = ss[flip]
        ref = fss.ALT.copy()
        alt = fss.REF.copy()
        fss.REF = ref
        fss.ALT =alt
        fss.SNP = 'chr'+fss[['CHR','POS','REF','ALT']].astype(str).agg(':'.join, axis=1)
        fss.BETA = -fss.BETA
        ss = pd.concat([ss[~flip],fss]).sort_index()
    return ss

# Cell
def compare_snps(query,subject):
    '''
    input: query and subject, two data frame with the first five column: chr, pos, snp, a0, a1
    output: data frame included six boolean columns (keep,exact,flip,reverse,both, complement) and two columns of the index query and subject.
    '''
    smry = []
    query = query.itertuples()
    subject = subject.itertuples()
    pre_s = None
    qi,si = next(query,None),next(subject,None)
    multi_snps = []
    while(qi and si):
        if qi[1]>si[1]:
            si = next(subject,None)
        elif qi[1]<si[1]:
            smry.append([False]*6+[qi[0],-1])
            qi = next(query,None)
        else:
            if qi[2]>si[2]:
                si = next(subject,None)
            elif qi[2]<si[2]:
                smry.append([False]*6+[qi[0],-1])
                qi = next(query,None)
            else:
                #same pos has multiple snps
                #query compare with each of them in subject
                multi_snps.append(si)
                smry.append(snp_match(qi[3],qi[4],si[3],si[4])+[qi[0],si[0]])
                pre_s = si
                si = next(subject,None)
                if si is None or si[2] != pre_s[2]:
                    qi = next(query,None)
                    while(qi is not None and qi[2]==pre_s[2]):
                        for s in multi_snps:
                            smry.append(snp_match(qi[3],qi[4],s[3],s[4])+[qi[0],s[0]])
                        qi = next(query,None)
                    multi_snps = []

    while(qi):
        smry.append([False]*6+[qi[0],-1])
        qi = next(query,None)
    smry = pd.DataFrame(smry,columns=['keep','exact','flip','reverse','both','complement','qidx','sidx'])
    print(smry.iloc[:,:6].value_counts())
    return smry

# Cell
def snp_match(a0,a1,ref0,ref1):
    '''
    input: a0 and a1 are the first snp, ref0 and ref1 are the second snp.
    output: keep,exact,flip,reverse,both, complement. boolean values.
    '''
    keep,exact,flip,reverse,both=False,False,False,False,False
     # reverse chain for multi base?
    ca0,ca1 = Seq(a0).reverse_complement(),Seq(a1).reverse_complement()
    if a0==ref0 and a1==ref1:
        exact=True
        keep=True
    elif a0==ref1 and a1==ref0:
        flip=True
        keep=True

    if ca0==ref0 and ca1==ref1:
        reverse = True
        keep=True
    elif ca0==ref1 and ca1==ref0:
        both=True
        keep=True
    return [keep,exact,flip,reverse,both,a0==ca1]