/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.meta;

import loci.common.xml.XMLTools;
import loci.formats.Modulo;
import loci.formats.ome.OMEXMLMetadata;
import ome.xml.model.XMLAnnotation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ModuloAnnotation
extends XMLAnnotation {
    public static final String MODULO_NS = "openmicroscopy.org/omero/dimension/modulo";
    private Modulo modulo;

    public void setModulo(OMEXMLMetadata meta, Modulo m3) {
        this.modulo = m3;
        this.setNamespace(MODULO_NS);
        Document doc = XMLTools.createDocument();
        Element r = this.makeModuloElement(doc);
        this.setValue(XMLTools.dumpXML(null, doc, r, false));
    }

    protected Element makeModuloElement(Document document) {
        Element mtop = document.createElement("Modulo");
        mtop.setAttribute("namespace", "http://www.openmicroscopy.org/Schemas/Additions/2011-09");
        Element m3 = document.createElement("ModuloAlong" + this.modulo.parentDimension);
        mtop.appendChild(m3);
        String type = this.modulo.type;
        String typeDescription = this.modulo.typeDescription;
        if (type != null) {
            type = type.toLowerCase();
        }
        if (type.equals("rotation")) {
            type = "angle";
        }
        if (!(type != null && (type.equals("angle") || type.equals("phase") || type.equals("tile") || type.equals("lifetime") || type.equals("lambda")))) {
            if (typeDescription == null) {
                typeDescription = type;
            }
            type = "other";
        }
        m3.setAttribute("Type", type);
        m3.setAttribute("TypeDescription", typeDescription);
        if (this.modulo.unit != null) {
            m3.setAttribute("Unit", this.modulo.unit);
        }
        if (this.modulo.end > this.modulo.start) {
            m3.setAttribute("Start", String.valueOf(this.modulo.start));
            m3.setAttribute("Step", String.valueOf(this.modulo.step));
            m3.setAttribute("End", String.valueOf(this.modulo.end));
        }
        if (this.modulo.labels != null) {
            for (String label : this.modulo.labels) {
                Element labelNode = document.createElement("Label");
                labelNode.setTextContent(label);
                m3.appendChild(labelNode);
            }
        }
        return mtop;
    }
}

