/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in.LeicaMicrosystemsMetadata;

import java.util.ArrayList;
import java.util.List;
import loci.formats.in.LeicaMicrosystemsMetadata.LMSXmlDocument;
import loci.formats.in.LeicaMicrosystemsMetadata.XlcfDocument;
import loci.formats.in.LeicaMicrosystemsMetadata.XlifDocument;
import org.w3c.dom.NodeList;

public class LMSCollectionXmlDocument
extends LMSXmlDocument {
    private List<LMSXmlDocument> children = new ArrayList<LMSXmlDocument>();

    public LMSCollectionXmlDocument(String filepath, LMSCollectionXmlDocument parent) {
        super(filepath, parent);
    }

    public List<XlifDocument> getXlifs() {
        ArrayList<XlifDocument> xlifs = new ArrayList<XlifDocument>();
        for (LMSXmlDocument child : this.children) {
            if (child instanceof XlifDocument) {
                xlifs.add((XlifDocument)child);
                continue;
            }
            if (!(child instanceof XlcfDocument)) continue;
            xlifs.addAll(((XlcfDocument)child).getXlifs());
        }
        return xlifs;
    }

    public List<String> getChildrenFiles(boolean pixels) {
        ArrayList<String> files = new ArrayList<String>();
        for (LMSXmlDocument child : this.children) {
            files.add(child.filepath);
            if (child instanceof XlcfDocument) {
                files.addAll(((XlcfDocument)child).getChildrenFiles(pixels));
                continue;
            }
            if (!(child instanceof XlifDocument) || !pixels) continue;
            files.addAll(((XlifDocument)child).getImagePaths());
        }
        return files;
    }

    protected void initChildren() {
        NodeList references = this.xPath("//Reference");
        LOGGER.info("References Found: " + references.getLength());
        for (int i = 0; i < references.getLength(); ++i) {
            String path = this.parseFilePath(this.getAttr(references.item(i), "File"));
            String correctedPath = LMSCollectionXmlDocument.fileExists(path);
            if (correctedPath != null) {
                if (correctedPath.endsWith(".xlif")) {
                    XlifDocument xlif = new XlifDocument(correctedPath, this);
                    if (xlif.isValid()) {
                        this.children.add(xlif);
                        continue;
                    }
                    LOGGER.warn("XLIF file is invalid: " + correctedPath);
                    continue;
                }
                if (!correctedPath.endsWith(".xlcf")) continue;
                this.children.add(new XlcfDocument(correctedPath, this));
                continue;
            }
            LOGGER.warn("Expected file at image path does not exist: " + path);
        }
    }
}

