/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.Region;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.SubResolutionFormatReader;
import loci.formats.UnsupportedCompressionException;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.PackbitsCodec;
import loci.formats.codec.WrappedCodec;
import loci.formats.dicom.DicomAttribute;
import loci.formats.dicom.DicomFileInfo;
import loci.formats.dicom.DicomTag;
import loci.formats.dicom.DicomTile;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class DicomReader
extends SubResolutionFormatReader {
    public static final String DICOM_MAGIC_STRING = "DICM";
    public static final int HEADER_LENGTH = 128;
    private static final String[] DICOM_SUFFIXES = new String[]{"dic", "dcm", "dicom", "j2ki", "j2kr"};
    private byte[][] lut;
    private short[][] shortLut;
    private int maxPixelRange;
    private int centerPixelValue;
    private boolean inverted;
    private String date;
    private String time;
    private String imageType;
    private String pixelSizeX;
    private String pixelSizeY;
    private Double pixelSizeZ;
    private List<Double> positionX = new ArrayList<Double>();
    private List<Double> positionY = new ArrayList<Double>();
    private List<Double> positionZ = new ArrayList<Double>();
    private List<String> channelNames = new ArrayList<String>();
    private boolean isJPEG = false;
    private boolean isRLE = false;
    private boolean isJP2K = false;
    private boolean isDeflate = false;
    private Map<Integer, List<String>> fileList;
    private int imagesPerFile;
    private String instanceUID;
    private String originalDate;
    private String originalTime;
    private String originalInstance;
    private int originalSeries;
    private int originalX;
    private int originalY;
    private String originalSpecimen;
    private List<String> companionFiles = new ArrayList<String>();
    private Map<Integer, List<DicomTile>> tilePositions;
    private Map<Integer, List<Double>> zOffsets;
    private Number concatenationNumber = null;
    private boolean edf = false;
    private List<DicomTag> tags;

    public DicomReader() {
        super("DICOM", new String[]{"dic", "dcm", "dicom", "jp2", "j2ki", "j2kr", "raw", "ima"});
        this.suffixNecessary = false;
        this.suffixSufficient = false;
        this.domains = new String[]{"Medical Imaging"};
        this.datasetDescription = "One or more .dcm or .dicom files";
        this.hasCompanionFiles = true;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (DicomReader.checkSuffix(name, DICOM_SUFFIXES)) {
            return true;
        }
        return super.isThisType(name, open);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 1024;
        if (!FormatTools.validStream(stream, 1024, true)) {
            return false;
        }
        stream.seek(128L);
        if (stream.readString(4).equals(DICOM_MAGIC_STRING)) {
            return true;
        }
        stream.seek(0L);
        try {
            DicomTag tag = new DicomTag(stream, false, 0L, false, false);
            if (tag.attribute == null || tag.attribute == DicomAttribute.INVALID) {
                return false;
            }
            if (tag.attribute != DicomAttribute.FILE_META_INFO_GROUP_LENGTH) {
                return true;
            }
            stream.seek(0L);
            tag = new DicomTag(stream, false, 0L, false);
            return tag.getNumberValue() != null && tag.getNumberValue().longValue() < stream.length();
        }
        catch (RuntimeException runtimeException) {
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        for (String file2 : files) {
            if (!file2.endsWith("DICOMDIR")) continue;
            return 1;
        }
        return super.getRequiredDirectories(files);
    }

    @Override
    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 0 && this.getPixelType() != 1) {
            return null;
        }
        return this.lut;
    }

    @Override
    public short[][] get16BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 2 && this.getPixelType() != 3) {
            return null;
        }
        return this.shortLut;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels || this.fileList == null) {
            return null;
        }
        ArrayList<String> uniqueFiles = new ArrayList<String>();
        uniqueFiles.add(new Location(this.currentId).getAbsolutePath());
        if (this.tilePositions != null) {
            for (List list : this.tilePositions.values()) {
                for (DicomTile t : list) {
                    if (uniqueFiles.contains(t.file)) continue;
                    uniqueFiles.add(t.file);
                }
            }
        }
        for (String string : this.companionFiles) {
            if (uniqueFiles.contains(string)) continue;
            uniqueFiles.add(string);
        }
        return uniqueFiles.toArray(new String[uniqueFiles.size()]);
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 1;
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.tilePositions.containsKey(this.getCoreIndex())) {
            return this.tilePositions.get((Object)Integer.valueOf((int)this.getCoreIndex())).get((int)0).region.width;
        }
        if (this.originalX < this.getSizeX() && this.originalX > 0) {
            return this.originalX;
        }
        return super.getOptimalTileWidth();
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.tilePositions.containsKey(this.getCoreIndex())) {
            return this.tilePositions.get((Object)Integer.valueOf((int)this.getCoreIndex())).get((int)0).region.height;
        }
        if (this.originalY < this.getSizeY() && this.originalY > 0) {
            return this.originalY;
        }
        return super.getOptimalTileHeight();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        block6: {
            int bpp;
            block7: {
                FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
                bpp = FormatTools.getBytesPerPixel(this.getPixelType());
                int pixel = bpp * this.getRGBChannelCount();
                Region currentRegion = new Region(x, y, w, h2);
                int z = this.getZCTCoords(no)[0];
                int c = this.getZCTCoords(no)[1];
                if (!this.tilePositions.containsKey(this.getCoreIndex())) {
                    LOGGER.warn("No tiles for core index = {}", (Object)this.getCoreIndex());
                    return buf;
                }
                List<Double> zs = this.zOffsets.get(this.getCoreIndex());
                List<DicomTile> tiles = this.tilePositions.get(this.getCoreIndex());
                for (int t = 0; t < tiles.size(); ++t) {
                    DicomTile tile = tiles.get(t);
                    if (this.getSizeZ() != 1 && (this.getSizeZ() > zs.size() || !tile.zOffset.equals(zs.get(z))) && (this.getSizeZ() != tiles.size() || t != z) || tile.channel != c && this.getEffectiveSizeC() != 1 || !tile.region.intersects(currentRegion)) continue;
                    byte[] tileBuf = new byte[tile.region.width * tile.region.height * pixel];
                    Region intersection = tile.region.intersection(currentRegion);
                    this.getTile(tile, tileBuf, intersection.x - tile.region.x, intersection.y - tile.region.y, intersection.width, intersection.height);
                    for (int row = 0; row < intersection.height; ++row) {
                        int srcIndex = row * intersection.width * pixel;
                        int destIndex = pixel * ((intersection.y - y + row) * w + (intersection.x - x));
                        System.arraycopy(tileBuf, srcIndex, buf, destIndex, intersection.width * pixel);
                    }
                }
                if (!this.inverted) break block6;
                if (bpp != 1) break block7;
                for (int i = 0; i < buf.length; ++i) {
                    buf[i] = (byte)(255 - buf[i]);
                }
                break block6;
            }
            if (bpp != 2) break block6;
            long maxPixelValue = this.maxPixelRange + this.centerPixelValue / 2;
            if (this.maxPixelRange == -1 || this.centerPixelValue < this.maxPixelRange / 2) {
                maxPixelValue = FormatTools.defaultMinMax(this.getPixelType())[1];
            }
            boolean little = this.isLittleEndian();
            for (int i = 0; i < buf.length; i += 2) {
                short s2 = DataTools.bytesToShort(buf, i, 2, little);
                DataTools.unpackBytes(maxPixelValue - (long)s2, buf, i, 2, little);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.isJPEG = false;
            this.isRLE = false;
            this.isJP2K = false;
            this.isDeflate = false;
            this.lut = null;
            this.shortLut = null;
            this.maxPixelRange = 0;
            this.centerPixelValue = 0;
            this.pixelSizeY = null;
            this.pixelSizeX = null;
            this.pixelSizeZ = null;
            this.imagesPerFile = 0;
            this.fileList = null;
            this.inverted = false;
            this.imageType = null;
            this.time = null;
            this.date = null;
            this.originalInstance = null;
            this.originalTime = null;
            this.originalDate = null;
            this.originalSpecimen = null;
            this.instanceUID = null;
            this.originalSeries = 0;
            this.originalX = 0;
            this.originalY = 0;
            this.companionFiles.clear();
            this.positionX.clear();
            this.positionY.clear();
            this.positionZ.clear();
            this.tilePositions = null;
            this.zOffsets = null;
            this.concatenationNumber = null;
            this.edf = false;
            this.tags = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        if (this.in != null) {
            this.in.close();
        }
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        CoreMetadata m3 = (CoreMetadata)this.core.get(0, 0);
        this.attachCompanionFiles();
        m3.littleEndian = true;
        long location = 0L;
        boolean bigEndianTransferSyntax = false;
        boolean oddLocations = false;
        int bitsPerPixel = 0;
        this.lut = null;
        this.inverted = false;
        LOGGER.info("Verifying DICOM format");
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        this.in.seek(128L);
        if (this.in.readString(4).equals(DICOM_MAGIC_STRING)) {
            if (level != MetadataLevel.MINIMUM) {
                this.in.seek(0L);
                String header = this.in.readString(128).trim();
                if (!header.startsWith("II") && !header.startsWith("MM")) {
                    this.addSeriesMeta("Header information", header);
                }
                this.in.skipBytes(4);
            }
            location = 128L;
        } else {
            this.in.seek(0L);
        }
        LOGGER.info("Reading tags");
        long baseOffset = 0L;
        boolean decodingTags = true;
        boolean signed = false;
        String currentType = "";
        boolean tiledFull = false;
        Double fileZOffset = null;
        this.tags = new ArrayList<DicomTag>();
        int frameOffsetNumber = 0;
        int opticalChannels = 0;
        ArrayList<Integer> opticalPathIDs = new ArrayList<Integer>();
        while (decodingTags && this.in.getFilePointer() + 4L < this.in.length()) {
            LOGGER.debug("Reading tag from {}", (Object)this.in.getFilePointer());
            DicomTag tag = new DicomTag(this.in, bigEndianTransferSyntax, location, oddLocations);
            LOGGER.debug("  {}", (Object)tag);
            this.tags.add(tag);
            oddLocations = (location & 1L) != 0L;
            this.addInfo(tag);
            if (tag.attribute == null) {
                this.in.seek(tag.getEndPointer());
                continue;
            }
            switch (tag.attribute) {
                case TRANSFER_SYNTAX_UID: {
                    String uid = tag.getStringValue();
                    this.isJP2K = uid.startsWith("1.2.840.10008.1.2.4.9");
                    this.isJPEG = !this.isJP2K && uid.startsWith("1.2.840.10008.1.2.4");
                    this.isRLE = uid.startsWith("1.2.840.10008.1.2.5");
                    this.isDeflate = uid.startsWith("1.2.8.10008.1.2.1.99");
                    if (!(this.isJP2K || this.isJPEG || this.isRLE || this.isDeflate || uid.indexOf("1.2.4") <= -1 && uid.indexOf("1.2.5") <= -1)) {
                        throw new UnsupportedCompressionException("Sorry, compression type " + uid + " not supported");
                    }
                    if (uid.indexOf("1.2.840.10008.1.2.2") < 0) break;
                    bigEndianTransferSyntax = true;
                    break;
                }
                case NUMBER_OF_FRAMES: {
                    double frames = tag.getNumberValue().doubleValue();
                    if (frames > 1.0 && frames > (double)this.imagesPerFile) {
                        this.imagesPerFile = (int)frames;
                    }
                    if (m3.sizeZ != 0) break;
                    m3.sizeZ = this.imagesPerFile;
                    break;
                }
                case SLICE_LOCATION: {
                    fileZOffset = tag.getNumberValue().doubleValue();
                    break;
                }
                case PLANAR_CONFIGURATION: {
                    m3.interleaved = tag.getNumberValue().intValue() == 0;
                    break;
                }
                case ROWS: {
                    int y = tag.getNumberValue().intValue();
                    if (y <= this.getSizeY()) break;
                    m3.sizeY = y;
                    this.originalY = y;
                    break;
                }
                case COLUMNS: {
                    int x = tag.getNumberValue().intValue();
                    if (x <= this.getSizeX()) break;
                    m3.sizeX = x;
                    this.originalX = x;
                    break;
                }
                case TOTAL_PIXEL_MATRIX_COLUMNS: {
                    int mx = tag.getNumberValue().intValue();
                    if (m3.sizeX != this.originalX) break;
                    m3.sizeX = mx;
                    if (m3.sizeZ != this.imagesPerFile) break;
                    m3.sizeZ = 1;
                    break;
                }
                case TOTAL_PIXEL_MATRIX_ROWS: {
                    int my = tag.getNumberValue().intValue();
                    if (m3.sizeY != this.originalY) break;
                    m3.sizeY = my;
                    break;
                }
                case TOTAL_PIXEL_MATRIX_FOCAL_PLANES: {
                    m3.sizeZ = tag.getNumberValue().intValue();
                    break;
                }
                case WINDOW_CENTER: {
                    if (tag.getStringValue().isEmpty() || tag.getNumberValue() == null) {
                        this.centerPixelValue = -1;
                        break;
                    }
                    this.centerPixelValue = tag.getNumberValue().intValue();
                    break;
                }
                case BITS_ALLOCATED: {
                    if (bitsPerPixel != 0) break;
                    bitsPerPixel = tag.getNumberValue().intValue();
                    break;
                }
                case PIXEL_REPRESENTATION: 
                case PIXEL_SIGN: {
                    signed = tag.getNumberValue().intValue() == 1;
                    break;
                }
                case WINDOW_WIDTH: {
                    if (tag.getStringValue().isEmpty() || tag.getNumberValue() == null) {
                        this.maxPixelRange = -1;
                        break;
                    }
                    this.maxPixelRange = tag.getNumberValue().intValue();
                    break;
                }
                case PIXEL_DATA: 
                case ITEM: 
                case INVALID_PIXEL_DATA: {
                    if (tag.getValueStartPointer() > tag.getEndPointer()) break;
                    baseOffset = tag.getValueStartPointer();
                    decodingTags = tag.getEndPointer() < this.in.length() && !this.isRLE && !this.isJPEG && !this.isJP2K;
                    break;
                }
                case VARIABLE_PIXEL_DATA: {
                    if (tag.getValueStartPointer() > tag.getEndPointer()) break;
                    baseOffset = location + 4L;
                    decodingTags = false;
                    break;
                }
                case INVALID: {
                    this.in.seek(tag.getValueStartPointer() - 4L);
                    break;
                }
                case DIRECTORY_RECORD_TYPE: {
                    currentType = tag.getStringValue();
                    break;
                }
                case DIRECTORY_RECORD_SEQUENCE: {
                    for (DicomTag dicomTag : tag.children) {
                        if (dicomTag.attribute == DicomAttribute.REFERENCED_FILE_ID) {
                            this.handleReferencedFile(dicomTag, currentType);
                            currentType = "";
                            continue;
                        }
                        if (dicomTag.attribute == DicomAttribute.DIRECTORY_RECORD_TYPE) {
                            currentType = dicomTag.getStringValue();
                            continue;
                        }
                        if (dicomTag.attribute != DicomAttribute.SERIES_NUMBER) continue;
                        this.originalSeries = this.parseIntValue(dicomTag.getNumberValue(), 0);
                    }
                    break;
                }
                case REFERENCED_FILE_ID: {
                    this.handleReferencedFile(tag, currentType);
                    currentType = "";
                    break;
                }
                case DIMENSION_ORGANIZATION_TYPE: {
                    tiledFull = tag.getStringValue().equals("TILED_FULL");
                    break;
                }
                case PER_FRAME_FUNCTIONAL_GROUPS_SEQUENCE: {
                    int channel = 0;
                    for (DicomTag child2 : tag.children) {
                        if (child2.attribute == DicomAttribute.OPTICAL_PATH_ID_SEQUENCE) {
                            DicomTag opticalPath = child2.lookupChild(DicomAttribute.OPTICAL_PATH_ID);
                            if (opticalPath == null || opticalPath.getStringValue() == null) continue;
                            String v = opticalPath.getStringValue().replace("#", "");
                            channel = Integer.parseInt(v);
                            continue;
                        }
                        if (child2.attribute != DicomAttribute.PLANE_POSITION_SLIDE_SEQUENCE) continue;
                        if (this.tilePositions == null) {
                            this.tilePositions = new HashMap<Integer, List<DicomTile>>();
                            this.tilePositions.put(0, new ArrayList());
                        }
                        int col = -1;
                        int row = -1;
                        Double zOffset = null;
                        for (DicomTag position : child2.children) {
                            if (position.attribute == DicomAttribute.ROW_POSITION_IN_MATRIX) {
                                row = position.getNumberValue().intValue() - 1;
                                continue;
                            }
                            if (position.attribute == DicomAttribute.COLUMN_POSITION_IN_MATRIX) {
                                col = position.getNumberValue().intValue() - 1;
                                continue;
                            }
                            if (position.attribute != DicomAttribute.Z_OFFSET_IN_SLIDE) continue;
                            zOffset = position.getNumberValue().doubleValue();
                        }
                        if (col < 0 || row < 0) continue;
                        DicomTile tile = new DicomTile();
                        tile.region = new Region(col, row, this.originalX, this.originalY);
                        tile.file = new Location(this.currentId).getAbsolutePath();
                        tile.zOffset = zOffset;
                        tile.channel = channel;
                        tile.isRLE = this.isRLE;
                        tile.isJPEG = this.isJPEG;
                        tile.isJP2K = this.isJP2K;
                        tile.isDeflate = this.isDeflate;
                        this.tilePositions.get(0).add(tile);
                    }
                    break;
                }
                case SHARED_FUNCTIONAL_GROUPS_SEQUENCE: {
                    DicomTag pixelSpacing;
                    DicomTag dicomTag = tag.lookupChild(DicomAttribute.PIXEL_MEASURES_SEQUENCE);
                    if (dicomTag == null || (pixelSpacing = dicomTag.lookupChild(DicomAttribute.PIXEL_SPACING)) == null) break;
                    this.parsePixelSpacing(pixelSpacing.getStringValue());
                    break;
                }
                case SPECIMEN_DESCRIPTION_SEQUENCE: {
                    DicomTag specimenID = tag.lookupChild(DicomAttribute.SPECIMEN_ID);
                    if (specimenID == null) break;
                    this.originalSpecimen = specimenID.getStringValue();
                    break;
                }
                case IN_CONCATENATION_NUMBER: {
                    this.concatenationNumber = tag.getNumberValue();
                    break;
                }
                case CONCATENATION_FRAME_OFFSET_NUMBER: {
                    if (tag.getNumberValue() == null) break;
                    frameOffsetNumber = tag.getNumberValue().intValue();
                    break;
                }
                case OPTICAL_PATH_SEQUENCE: {
                    for (DicomTag child : tag.children) {
                        if (child.attribute == DicomAttribute.OPTICAL_PATH_ID) {
                            Number v = child.getNumberValue();
                            if (v != null) {
                                opticalPathIDs.add(v.intValue());
                            }
                            ++opticalChannels;
                            continue;
                        }
                        if (child.attribute != DicomAttribute.OPTICAL_PATH_DESCRIPTION) continue;
                        this.channelNames.add(child.getStringValue());
                    }
                    break;
                }
                case EXTENDED_DEPTH_OF_FIELD: {
                    this.edf = tag.getStringValue().equalsIgnoreCase("yes");
                    break;
                }
                default: {
                    this.in.seek(tag.getEndPointer());
                }
            }
            if (this.in.getFilePointer() < this.in.length() - 4L) continue;
            decodingTags = false;
        }
        if (this.imagesPerFile == 0) {
            this.imagesPerFile = 1;
        }
        if (new Location(this.currentId).getName().equals("DICOMDIR")) {
            String parent = new Location(this.currentId).getAbsoluteFile().getParent();
            Object[] fileKeys = this.fileList.keySet().toArray(new Integer[0]);
            Arrays.sort(fileKeys);
            for (int q = 0; q < this.fileList.size(); ++q) {
                for (int i = 0; i < this.fileList.get(fileKeys[q]).size(); ++i) {
                    String file2 = this.fileList.get(fileKeys[q]).get(i);
                    file2 = file2.replace('\\', File.separatorChar);
                    file2 = file2.replaceAll("/", File.separator);
                    this.fileList.get(fileKeys[q]).set(i, parent + File.separator + file2);
                }
            }
            for (int i = 0; i < this.companionFiles.size(); ++i) {
                String file3 = this.companionFiles.get(i);
                file3 = file3.replace('\\', File.separatorChar);
                file3 = file3.replaceAll("/", File.separator);
                this.companionFiles.set(i, file3);
            }
            this.tilePositions = new HashMap<Integer, List<DicomTile>>();
            this.zOffsets = new HashMap<Integer, List<Double>>();
            this.core.clear();
        } else {
            if (m3.sizeZ == 0) {
                m3.sizeZ = 1;
            }
            if (opticalChannels == 0 || this.concatenationNumber == null && this.imagesPerFile / m3.sizeZ % opticalChannels != 0) {
                opticalChannels = 1;
            }
            m3.sizeC *= opticalChannels;
            m3.imageCount *= opticalChannels;
            if (tiledFull || this.tilePositions == null) {
                this.tilePositions = new HashMap<Integer, List<DicomTile>>();
                this.tilePositions.put(0, new ArrayList());
                int cols = (int)Math.ceil((double)this.getSizeX() / (double)this.originalX);
                int rows = (int)Math.ceil((double)this.getSizeY() / (double)this.originalY);
                int tilesPerPlane = rows * cols;
                int c = frameOffsetNumber / (tilesPerPlane * this.getSizeZ());
                int newOffset = frameOffsetNumber - c * tilesPerPlane * this.getSizeZ();
                int z = newOffset / tilesPerPlane;
                int x = this.originalX * (newOffset % tilesPerPlane % cols);
                int y = this.originalY * (newOffset % tilesPerPlane / cols);
                for (int p = 0; p < this.imagesPerFile; ++p) {
                    DicomTile dicomTile = new DicomTile();
                    dicomTile.fileIndex = this.tilePositions.get(0).size();
                    dicomTile.zOffset = m3.sizeZ == 1 && fileZOffset != null ? fileZOffset : Double.valueOf(z);
                    dicomTile.channel = c;
                    if (c < opticalPathIDs.size()) {
                        dicomTile.channel = (Integer)opticalPathIDs.get(c);
                    }
                    dicomTile.file = new Location(this.currentId).getAbsolutePath();
                    dicomTile.region = new Region(x, y, this.originalX, this.originalY);
                    dicomTile.isRLE = this.isRLE;
                    dicomTile.isJPEG = this.isJPEG;
                    dicomTile.isJP2K = this.isJP2K;
                    dicomTile.isDeflate = this.isDeflate;
                    this.tilePositions.get(0).add(dicomTile);
                    if (x + this.originalX < this.getSizeX()) {
                        x += this.originalX;
                        continue;
                    }
                    if (y + this.originalY < this.getSizeY()) {
                        x = 0;
                        y += this.originalY;
                        continue;
                    }
                    x = 0;
                    y = 0;
                    if (++z != m3.sizeZ) continue;
                    z = 0;
                    ++c;
                }
            }
            m3.bitsPerPixel = bitsPerPixel;
            while (bitsPerPixel % 8 != 0) {
                ++bitsPerPixel;
            }
            if (bitsPerPixel == 24 || bitsPerPixel == 48) {
                bitsPerPixel /= 3;
                m3.bitsPerPixel /= 3;
            }
            m3.pixelType = FormatTools.pixelTypeFromBytes(bitsPerPixel / 8, signed, false);
            LOGGER.info("Calculating image offsets");
            this.calculatePixelsOffsets(baseOffset);
        }
        this.makeFileList();
        LOGGER.info("Populating metadata");
        int seriesCount = this.fileList.size();
        Object[] keys = this.fileList.keySet().toArray(new Integer[0]);
        Arrays.sort(keys);
        ArrayList<DicomFileInfo> metadataInfo = new ArrayList<DicomFileInfo>();
        if (seriesCount > 1) {
            for (int i = 0; i < seriesCount; ++i) {
                List<String> currentFileList = this.fileList.get(keys[i]);
                DicomFileInfo fileInfo = this.createFileInfo(currentFileList.get(0));
                this.zOffsets.put(i, fileInfo.zOffsets);
                fileInfo.coreMetadata.sizeZ *= currentFileList.size();
                fileInfo.coreMetadata.imageCount = fileInfo.coreMetadata.sizeZ;
                this.core.add(fileInfo.coreMetadata);
                ArrayList<DicomTile> positions = new ArrayList<DicomTile>();
                ArrayList<Double> x = new ArrayList<Double>();
                ArrayList<Double> y = new ArrayList<Double>();
                ArrayList<Double> arrayList = new ArrayList<Double>();
                for (String f : currentFileList) {
                    DicomFileInfo inf = f.equals(currentFileList.get(0)) ? fileInfo : this.createFileInfo(f);
                    positions.addAll(inf.tiles);
                    x.addAll(inf.positionX);
                    y.addAll(inf.positionY);
                    arrayList.addAll(inf.positionZ);
                }
                fileInfo.positionX = x;
                fileInfo.positionY = y;
                fileInfo.positionZ = arrayList;
                metadataInfo.add(fileInfo);
                this.tilePositions.put(i, positions);
            }
        } else {
            List<String> allFiles = this.fileList.get(keys[0]);
            ArrayList<DicomFileInfo> infos = new ArrayList<DicomFileInfo>();
            for (String file4 : allFiles) {
                DicomFileInfo info = this.createFileInfo(file4);
                infos.add(info);
            }
            if (infos.size() > 1) {
                int i;
                infos.sort(null);
                metadataInfo.add((DicomFileInfo)infos.get(0));
                this.core.clear();
                this.tilePositions.clear();
                this.updateCoreMetadata(((DicomFileInfo)infos.get((int)0)).coreMetadata);
                this.core.add(((DicomFileInfo)infos.get((int)0)).coreMetadata);
                this.tilePositions.put(0, ((DicomFileInfo)infos.get((int)0)).tiles);
                this.zOffsets.put(0, ((DicomFileInfo)infos.get((int)0)).zOffsets);
                this.channelNames.clear();
                this.channelNames.addAll(((DicomFileInfo)infos.get((int)0)).channelNames);
                for (i = 1; i < infos.size(); ++i) {
                    DicomFileInfo info = (DicomFileInfo)infos.get(i);
                    DicomFileInfo prevInfo = (DicomFileInfo)infos.get(i - 1);
                    this.updateCoreMetadata(info.coreMetadata);
                    if (!(info.imageType.indexOf("VOLUME") >= 0 && info.edf == prevInfo.edf || info.imageType.equals(prevInfo.imageType) && info.coreMetadata.sizeX == prevInfo.coreMetadata.sizeX && info.coreMetadata.sizeY == prevInfo.coreMetadata.sizeY)) {
                        this.core.add(info.coreMetadata);
                        metadataInfo.add(info);
                    } else if (info.coreMetadata.sizeX != prevInfo.coreMetadata.sizeX && info.coreMetadata.sizeY != prevInfo.coreMetadata.sizeY) {
                        this.core.add(this.core.size() - 1, info.coreMetadata);
                        metadataInfo.add(info);
                    } else if (info.coreMetadata.sizeX != prevInfo.coreMetadata.sizeX || info.coreMetadata.sizeY != prevInfo.coreMetadata.sizeY) {
                        this.core.add(info.coreMetadata);
                        metadataInfo.add(info);
                    } else if (info.channelNames.size() == 1 && !this.channelNames.contains(info.channelNames.get(0))) {
                        this.channelNames.add(info.channelNames.get(0));
                    } else if (info.concatenationIndex == 0) {
                        ++((CoreMetadata)this.core.get((int)(this.core.size() - 1), (int)(this.core.sizes()[this.core.size() - 1] - 1))).sizeZ;
                        ((CoreMetadata)this.core.get((int)(this.core.size() - 1), (int)(this.core.sizes()[this.core.size() - 1] - 1))).imageCount += info.coreMetadata.imageCount;
                    }
                    int lastCoreIndex = this.core.flattenedIndex(this.core.size() - 1, this.core.sizes()[this.core.size() - 1] - 1);
                    if (!this.tilePositions.containsKey(lastCoreIndex)) {
                        this.tilePositions.put(lastCoreIndex, info.tiles);
                    } else {
                        this.tilePositions.get(lastCoreIndex).addAll(info.tiles);
                    }
                    if (this.zOffsets.containsKey(lastCoreIndex)) {
                        for (Double z : info.zOffsets) {
                            if (this.zOffsets.get(lastCoreIndex).contains(z)) continue;
                            this.zOffsets.get(lastCoreIndex).add(z);
                        }
                        continue;
                    }
                    this.zOffsets.put(lastCoreIndex, info.zOffsets);
                }
                if (((CoreMetadata)this.core.get((int)0, (int)0)).sizeC <= 1) {
                    for (i = 0; i < this.core.size(); ++i) {
                        for (int r = 0; r < this.core.size(i); ++r) {
                            ((CoreMetadata)this.core.get((int)i, (int)r)).sizeC = this.channelNames.size();
                            if (((CoreMetadata)this.core.get((int)i, (int)r)).imageCount == ((CoreMetadata)this.core.get((int)i, (int)r)).sizeC) {
                                ((CoreMetadata)this.core.get((int)i, (int)r)).sizeZ = 1;
                            }
                            this.updateCoreMetadata((CoreMetadata)this.core.get(i, r));
                        }
                    }
                }
            } else {
                this.tilePositions.put(0, ((DicomFileInfo)infos.get((int)0)).tiles);
                this.updateCoreMetadata((CoreMetadata)this.core.get(0, 0));
                metadataInfo.add((DicomFileInfo)infos.get(0));
                this.zOffsets.put(0, ((DicomFileInfo)infos.get((int)0)).zOffsets);
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.setSeries(i);
            DicomFileInfo info = (DicomFileInfo)metadataInfo.get(this.seriesToCoreIndex(i));
            if (info.timestamp != null) {
                store.setImageAcquisitionDate(info.timestamp, i);
            }
            if (info.imageType != null) {
                int tokenIndex;
                String[] typeTokens = info.imageType.split("\\\\");
                int n = tokenIndex = typeTokens.length > 2 ? 2 : typeTokens.length - 1;
                if (tokenIndex >= 0) {
                    store.setImageName(typeTokens[tokenIndex], i);
                }
            }
            if (level == MetadataLevel.MINIMUM) continue;
            store.setImageDescription(info.imageType, i);
            if (info.pixelSizeX != null) {
                store.setPixelsPhysicalSizeX(info.pixelSizeX, i);
            }
            if (info.pixelSizeY != null) {
                store.setPixelsPhysicalSizeY(info.pixelSizeY, i);
            }
            if (info.pixelSizeZ != null) {
                store.setPixelsPhysicalSizeZ(info.pixelSizeZ, i);
            }
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                if (c >= this.channelNames.size()) continue;
                store.setChannelName(this.channelNames.get(c), i, c);
            }
            for (int p = 0; p < this.getImageCount(); ++p) {
                Length z;
                Length y;
                Length x;
                if (p < info.positionX.size() && info.positionX.get(p) != null && (x = new Length(info.positionX.get(p), UNITS.MILLIMETER)) != null) {
                    store.setPlanePositionX(x, i, p);
                }
                if (p < info.positionY.size() && info.positionY.get(p) != null && (y = new Length(info.positionY.get(p), UNITS.MILLIMETER)) != null) {
                    store.setPlanePositionY(y, i, p);
                }
                if (p >= info.positionZ.size() || info.positionZ.get(p) == null || (z = new Length(info.positionZ.get(p), UNITS.MILLIMETER)) == null) continue;
                store.setPlanePositionZ(z, i, p);
            }
        }
        this.setSeries(0);
    }

    private void addInfo(DicomTag info) throws IOException {
        CoreMetadata m3 = (CoreMetadata)this.core.get(0, 0);
        m3.littleEndian = this.in.isLittleEndian();
        if (info.attribute != DicomAttribute.ITEM) {
            int tag;
            if (info.attribute != null) {
                String infoString = info.getStringValue();
                Number infoNumber = info.getNumberValue();
                switch (info.attribute) {
                    case SAMPLES_PER_PIXEL: {
                        m3.sizeC = infoNumber.intValue();
                        if (this.getSizeC() <= 1) break;
                        m3.rgb = true;
                        break;
                    }
                    case PHOTOMETRIC_INTERPRETATION: {
                        if (infoString.equals("PALETTE COLOR")) {
                            m3.indexed = true;
                            m3.sizeC = 1;
                            m3.rgb = false;
                            this.lut = new byte[3][];
                            this.shortLut = new short[3][];
                            break;
                        }
                        if (!infoString.startsWith("MONOCHROME")) break;
                        this.inverted = infoString.endsWith("1");
                        break;
                    }
                    case ACQUISITION_TIMESTAMP: {
                        if (infoString.length() < 8) break;
                        String timestamp = infoString.substring(0, 8);
                        try {
                            if (Integer.parseInt(timestamp) > 0) {
                                this.originalDate = timestamp;
                            }
                        }
                        catch (NumberFormatException e) {
                            LOGGER.trace("", e);
                        }
                        this.originalTime = infoString.substring(8);
                        break;
                    }
                    case ACQUISITION_DATE: {
                        if (infoNumber == null || infoNumber.intValue() <= 0) break;
                        this.originalDate = infoString;
                        break;
                    }
                    case ACQUISITION_TIME: {
                        this.originalTime = infoString;
                        break;
                    }
                    case SOP_INSTANCE_UID: {
                        this.instanceUID = infoString;
                        break;
                    }
                    case INSTANCE_NUMBER: {
                        if (infoString == null || infoString.isEmpty()) break;
                        this.originalInstance = infoString;
                        break;
                    }
                    case SERIES_NUMBER: {
                        this.originalSeries = this.parseIntValue(infoNumber, 0);
                        break;
                    }
                    case RED_LUT_DATA: 
                    case GREEN_LUT_DATA: 
                    case BLUE_LUT_DATA: 
                    case SEGMENTED_RED_LUT_DATA: 
                    case SEGMENTED_GREEN_LUT_DATA: 
                    case SEGMENTED_BLUE_LUT_DATA: {
                        if (info.value == null || this.shortLut == null) break;
                        String color = info.key.substring(0, info.key.indexOf(32)).trim();
                        int ndx = color.equals("Red") ? 0 : (color.equals("Green") ? 1 : 2);
                        this.shortLut[ndx] = (short[])info.value;
                        this.lut[ndx] = new byte[this.shortLut[ndx].length];
                        for (int i = 0; i < this.lut[ndx].length; ++i) {
                            this.lut[ndx][i] = (byte)(this.shortLut[ndx][i] & 0xFF);
                        }
                        break;
                    }
                    case CONTENT_TIME: {
                        this.time = infoString;
                        break;
                    }
                    case CONTENT_DATE: {
                        this.date = infoString;
                        break;
                    }
                    case IMAGE_TYPE: {
                        if (this.imageType != null) break;
                        this.imageType = infoString;
                        break;
                    }
                    case PIXEL_SPACING: {
                        this.parsePixelSpacing(infoString);
                        break;
                    }
                    case SLICE_SPACING: {
                        if (infoNumber == null) break;
                        this.pixelSizeZ = infoNumber.doubleValue();
                        break;
                    }
                    case IMAGE_POSITION_PATIENT: {
                        String[] positions = infoString.replace('\\', '_').split("_");
                        if (positions.length > 0) {
                            try {
                                this.positionX.add(Double.valueOf(positions[0]));
                            }
                            catch (NumberFormatException e) {
                                this.positionX.add(null);
                            }
                        } else {
                            this.positionX.add(null);
                            this.positionY.add(null);
                            this.positionZ.add(null);
                        }
                        if (positions.length > 1) {
                            try {
                                this.positionY.add(Double.valueOf(positions[1]));
                            }
                            catch (NumberFormatException e) {
                                this.positionY.add(null);
                            }
                        } else {
                            this.positionY.add(null);
                            this.positionZ.add(null);
                        }
                        if (positions.length > 2) {
                            try {
                                this.positionZ.add(Double.valueOf(positions[2]));
                            }
                            catch (NumberFormatException e) {
                                this.positionZ.add(null);
                            }
                            break;
                        }
                        this.positionZ.add(null);
                    }
                }
            }
            if (((tag = info.tag) & 0xFFFF0000) >> 16 != 32736) {
                String key = DicomAttribute.formatTag(tag);
                if (info.key != null) {
                    key = key + " " + info.key;
                }
                this.addOriginalMetadata(key, info);
            }
        }
    }

    private void addOriginalMetadata(String key, DicomTag info) {
        if (info.value != null && !(info.value instanceof byte[]) && !(info.value instanceof short[])) {
            if (info.value instanceof String) {
                this.addSeriesMetaList(key, ((String)info.value).trim());
            } else {
                this.addSeriesMetaList(key, info.value);
            }
        }
        if (info.attribute != DicomAttribute.PER_FRAME_FUNCTIONAL_GROUPS_SEQUENCE && info.attribute != DicomAttribute.REFERENCED_IMAGE_NAVIGATION_SEQUENCE) {
            for (DicomTag child : info.children) {
                String childKey = DicomAttribute.formatTag(child.tag);
                if (child.key != null) {
                    childKey = childKey + " " + child.key;
                }
                this.addOriginalMetadata(childKey, child);
            }
        }
    }

    private void makeFileList() throws FormatException, IOException {
        LOGGER.info("Building file list");
        if (this.fileList == null && this.originalInstance != null && this.originalDate != null && this.originalTime != null && this.instanceUID != null && this.isGroupFiles()) {
            this.currentId = new Location(this.currentId).getAbsolutePath();
            this.fileList = new HashMap<Integer, List<String>>();
            Integer s2 = this.originalSeries;
            this.fileList.put(s2, new ArrayList());
            int instanceNumber = Integer.parseInt(this.originalInstance) - 1;
            if (instanceNumber == 0) {
                this.fileList.get(s2).add(this.currentId);
            } else {
                while (instanceNumber > this.fileList.get(s2).size()) {
                    this.fileList.get(s2).add(null);
                }
                this.fileList.get(s2).add(this.currentId);
            }
            Location currentFile = new Location(this.currentId).getAbsoluteFile();
            Location directory = currentFile.getParentFile();
            this.scanDirectory(directory, true);
            for (List<String> files : this.fileList.values()) {
                Iterator<String> fileIterator = files.iterator();
                while (fileIterator.hasNext()) {
                    if (fileIterator.next() != null) continue;
                    fileIterator.remove();
                }
            }
        } else if (this.fileList == null || !this.isGroupFiles()) {
            this.fileList = new HashMap<Integer, List<String>>();
            this.fileList.put(0, new ArrayList());
            this.fileList.get(0).add(new Location(this.currentId).getAbsolutePath());
        }
    }

    private void scanDirectory(Location dir, boolean checkSeries) throws FormatException, IOException {
        Object[] files = dir.list(true);
        if (files == null) {
            return;
        }
        Arrays.sort(files);
        for (Object f : files) {
            String file2 = new Location(dir, (String)f).getAbsolutePath();
            LOGGER.debug("Checking file {}", (Object)file2);
            if (((String)f).equals(this.currentId) || file2.equals(this.currentId) || !this.isThisType(file2)) continue;
            this.addFileToList(file2, checkSeries);
        }
    }

    private void addFileToList(String file2, boolean checkSeries) throws FormatException, IOException {
        int currentX = 0;
        int currentY = 0;
        int fileSeries = -1;
        String thisSpecimen = null;
        String date = null;
        String time = null;
        String instance = null;
        String thisInstanceUID = null;
        try (RandomAccessInputStream stream = new RandomAccessInputStream(file2);){
            long fp;
            if (!this.isThisType(stream)) {
                return;
            }
            stream.order(true);
            stream.seek(128L);
            if (!stream.readString(4).equals(DICOM_MAGIC_STRING)) {
                stream.seek(0L);
            }
            boolean bigEndian = false;
            boolean odd = false;
            long currentLocation = stream.getFilePointer();
            block24: while ((date == null || time == null || instance == null || checkSeries && fileSeries < 0 || currentX == 0 || currentY == 0 || this.originalSpecimen != null && thisSpecimen == null) && (fp = stream.getFilePointer()) + 4L < stream.length()) {
                if (fp < 0L) {
                    break;
                }
                DicomTag tag = new DicomTag(stream, bigEndian, 0L, odd);
                boolean bl = odd = (currentLocation & 1L) != 0L;
                if (tag.attribute == null || tag.value == null && tag.children.size() == 0) {
                    stream.seek(tag.getEndPointer());
                    continue;
                }
                switch (tag.attribute) {
                    case SPECIMEN_DESCRIPTION_SEQUENCE: {
                        DicomTag specimenID = tag.lookupChild(DicomAttribute.SPECIMEN_ID);
                        if (specimenID == null) continue block24;
                        thisSpecimen = specimenID.getStringValue();
                        continue block24;
                    }
                    case SOP_INSTANCE_UID: {
                        thisInstanceUID = tag.getStringValue();
                        continue block24;
                    }
                    case INSTANCE_NUMBER: {
                        instance = tag.getStringValue();
                        if (instance.length() != 0) continue block24;
                        instance = null;
                        continue block24;
                    }
                    case ACQUISITION_TIMESTAMP: {
                        if (tag.getStringValue().length() < 8) continue block24;
                        date = tag.getStringValue().substring(0, 8);
                        time = tag.getStringValue().substring(8);
                        continue block24;
                    }
                    case ACQUISITION_TIME: {
                        time = tag.getStringValue();
                        continue block24;
                    }
                    case ACQUISITION_DATE: {
                        date = tag.getStringValue();
                        continue block24;
                    }
                    case SERIES_NUMBER: {
                        fileSeries = this.parseIntValue(tag.getNumberValue(), 0);
                        continue block24;
                    }
                    case ROWS: {
                        currentY = Math.max(currentY, tag.getNumberValue().intValue());
                        continue block24;
                    }
                    case COLUMNS: {
                        currentX = Math.max(currentX, tag.getNumberValue().intValue());
                        continue block24;
                    }
                    case PIXEL_DATA: 
                    case INVALID_PIXEL_DATA: 
                    case VARIABLE_PIXEL_DATA: {
                        stream.seek(stream.length() - 1L);
                        continue block24;
                    }
                }
                stream.seek(tag.getEndPointer());
            }
        }
        LOGGER.debug("file = {}", (Object)file2);
        LOGGER.debug("  date = {}, originalDate = {}", (Object)date, (Object)this.originalDate);
        LOGGER.debug("  time = {}, originalTime = {}", (Object)time, (Object)this.originalTime);
        LOGGER.debug("  instance = {}, originalInstance = {}", (Object)instance, (Object)this.originalInstance);
        LOGGER.debug("  checkSeries = {}", (Object)checkSeries);
        LOGGER.debug("  fileSeries = {}, originalSeries = {}", (Object)fileSeries, (Object)this.originalSeries);
        LOGGER.debug("  currentX = {}, originalX = {}", (Object)currentX, (Object)this.originalX);
        LOGGER.debug("  currentY = {}, originalY = {}", (Object)currentY, (Object)this.originalY);
        LOGGER.debug("  thisSpecimen = {}, originalSpecimen = {}", (Object)thisSpecimen, (Object)this.originalSpecimen);
        boolean noSpecimens = this.originalSpecimen == null && thisSpecimen == null;
        boolean oneNullSpecimen = this.originalSpecimen == null || thisSpecimen == null;
        boolean dicomdir = new Location(file2).getName().equals("DICOMDIR");
        if (date == null || time == null || instance == null || checkSeries && fileSeries != this.originalSeries || !noSpecimens && oneNullSpecimen || !noSpecimens && !this.originalSpecimen.equals(thisSpecimen)) {
            return;
        }
        if (dicomdir) {
            this.companionFiles.add(new Location(file2).getAbsolutePath());
            return;
        }
        if (this.tilePositions == null) {
            if (this.instanceUID != null && thisInstanceUID != null) {
                String[] uid = this.instanceUID.split("\\.");
                String[] thisUID = thisInstanceUID.split("\\.");
                for (int i = 0; i < Math.min(uid.length, thisUID.length) - 2; ++i) {
                    if (uid[i].equals(thisUID[i])) continue;
                    return;
                }
            } else if (this.instanceUID != null || thisInstanceUID != null) {
                return;
            }
            if (currentX != this.originalX || currentY != this.originalY) {
                ++fileSeries;
            }
        }
        double stamp = this.getTimestampMicroseconds(time);
        double timestamp = this.getTimestampMicroseconds(this.originalTime);
        LOGGER.trace("  stamp = {}", (Object)stamp);
        LOGGER.trace("  timestamp = {}", (Object)timestamp);
        if (date.equals(this.originalDate) && Math.abs(stamp - timestamp) < 1.5E8) {
            int position = Integer.parseInt(instance) - 1;
            if (position < 0) {
                position = 0;
            }
            if (this.fileList.get(fileSeries) == null) {
                this.fileList.put(fileSeries, new ArrayList());
            }
            if (position < this.fileList.get(fileSeries).size()) {
                while (position < this.fileList.get(fileSeries).size() && this.fileList.get(fileSeries).get(position) != null) {
                    ++position;
                }
                if (position < this.fileList.get(fileSeries).size()) {
                    this.fileList.get(fileSeries).set(position, file2);
                } else if (!this.fileList.get(fileSeries).contains(file2)) {
                    this.fileList.get(fileSeries).add(file2);
                }
            } else if (!this.fileList.get(fileSeries).contains(file2)) {
                while (position > this.fileList.get(fileSeries).size()) {
                    this.fileList.get(fileSeries).add(null);
                }
                this.fileList.get(fileSeries).add(file2);
            }
        }
    }

    private int parseIntValue(Number v, int defaultValue) {
        return v == null ? defaultValue : v.intValue();
    }

    private long getTimestampMicroseconds(String v) {
        if (v == null) {
            return 0L;
        }
        v = v.trim();
        if ((v = v.replaceAll(":", "")).indexOf("+") >= 0) {
            v = v.substring(0, v.indexOf("+"));
        }
        if (v.indexOf("-") >= 0) {
            v = v.substring(0, v.indexOf("-"));
        }
        if (v.isEmpty()) {
            return 0L;
        }
        int hours = Integer.parseInt(v.substring(0, 2));
        long total = hours * 60 * 60;
        if (v.length() > 2) {
            int minutes = Integer.parseInt(v.substring(2, 4));
            total += (long)(minutes * 60);
        }
        if (v.length() > 4) {
            int seconds = Integer.parseInt(v.substring(4, 6));
            total += (long)seconds;
        }
        total *= 1000000L;
        if (v.length() > 6) {
            total += (long)Integer.parseInt(v.substring(v.indexOf(".") + 1));
        }
        return total;
    }

    private void attachCompanionFiles() throws IOException {
        Location parent = new Location(this.currentId).getAbsoluteFile().getParentFile();
        Location grandparent = parent.getParentFile();
        if (new Location(grandparent, parent.getName() + ".mif").exists()) {
            String[] list;
            for (String f : list = grandparent.list(true)) {
                Location file2 = new Location(grandparent, f);
                if (file2.isDirectory()) continue;
                this.companionFiles.add(file2.getAbsolutePath());
            }
        }
    }

    private void getTile(DicomTile tile, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        int ec = this.getRGBChannelCount();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int bytes = tile.region.width * tile.region.height * bpp * ec;
        try (RandomAccessInputStream stream = new RandomAccessInputStream(tile.file);){
            if (tile.fileOffset >= stream.length()) {
                LOGGER.error("attempted to read beyond end of file ({}, {})", (Object)tile.fileOffset, (Object)tile.file);
                return;
            }
            stream.seek(tile.fileOffset);
            LOGGER.debug("reading from offset = {}, file = {}", (Object)tile.fileOffset, (Object)tile.file);
            if (tile.isRLE) {
                CodecOptions options = new CodecOptions();
                options.maxBytes = tile.region.width * tile.region.height;
                block15: for (int c = 0; c < ec; ++c) {
                    PackbitsCodec codec = new PackbitsCodec();
                    byte[] t = null;
                    if (bpp > 1) {
                        int i;
                        int plane = bytes / (bpp * ec);
                        byte[][] tmp = new byte[bpp][];
                        long start = stream.getFilePointer();
                        for (i = 0; i < bpp; ++i) {
                            tmp[i] = codec.decompress(stream, options);
                            if (i > 0 && tmp[i].length > options.maxBytes) {
                                stream.seek(start);
                                tmp[i] = codec.decompress(stream, options);
                            }
                            if (tile.last && i >= bpp - 1) continue;
                            start = stream.getFilePointer();
                            while (stream.read() == 0) {
                            }
                            long end = stream.getFilePointer();
                            stream.seek(end - 1L);
                        }
                        t = new byte[bytes / ec];
                        for (i = 0; i < plane; ++i) {
                            for (int j = 0; j < bpp; ++j) {
                                int byteIndex;
                                int n = byteIndex = this.isLittleEndian() ? bpp - j - 1 : j;
                                if (i >= tmp[byteIndex].length) continue;
                                t[i * bpp + j] = tmp[byteIndex][i];
                            }
                        }
                    } else {
                        t = codec.decompress(stream, options);
                        if (t.length < bytes / ec) {
                            byte[] tmp = t;
                            t = new byte[bytes / ec];
                            System.arraycopy(tmp, 0, t, 0, tmp.length);
                        }
                        if (!tile.last || c < ec - 1) {
                            while (stream.read() == 0) {
                            }
                            stream.seek(stream.getFilePointer() - 1L);
                        }
                    }
                    int rowLen = w * bpp;
                    int srcRowLen = tile.region.width * bpp;
                    for (int row = 0; row < h2; ++row) {
                        int src = (row + y) * srcRowLen + x * bpp;
                        int dest = (h2 * c + row) * rowLen;
                        int len = Math.min(rowLen, t.length - src - 1);
                        if (len < 0) continue block15;
                        System.arraycopy(t, src, buf, dest, len);
                    }
                }
            } else if (tile.isJPEG || tile.isJP2K) {
                byte[] tmp;
                int pt;
                byte[] b = new byte[(int)(tile.endOffset - stream.getFilePointer())];
                stream.read(b);
                if (b.length < 8) {
                    return;
                }
                if (b[2] != -1) {
                    byte[] tmp2 = new byte[b.length + 1];
                    tmp2[0] = b[0];
                    tmp2[1] = b[1];
                    tmp2[2] = -1;
                    System.arraycopy(b, 2, tmp2, 3, b.length - 2);
                    b = tmp2;
                }
                for (pt = b.length - 2; pt >= 0 && (b[pt] != -1 || b[pt + 1] != -39); --pt) {
                }
                if (pt < 0) {
                    tmp = b;
                    b = new byte[tmp.length + 2];
                    System.arraycopy(tmp, 0, b, 0, tmp.length);
                    b[b.length - 2] = -1;
                    b[b.length - 1] = -39;
                } else if (pt < b.length - 2) {
                    tmp = b;
                    b = new byte[pt + 2];
                    System.arraycopy(tmp, 0, b, 0, b.length);
                }
                WrappedCodec codec = null;
                CodecOptions options = new CodecOptions();
                options.littleEndian = this.isLittleEndian();
                options.interleaved = this.isInterleaved();
                codec = tile.isJPEG ? new JPEGCodec() : new JPEG2000Codec();
                b = codec.decompress(b, options);
                int rowLen = w * bpp;
                int srcRowLen = tile.region.width * bpp;
                if (this.isInterleaved()) {
                    rowLen *= ec;
                    srcRowLen *= ec;
                    for (int row = 0; row < h2; ++row) {
                        System.arraycopy(b, (row + y) * srcRowLen + x * bpp * ec, buf, row * rowLen, rowLen);
                    }
                } else {
                    int srcPlane = this.originalY * srcRowLen;
                    for (int c = 0; c < ec; ++c) {
                        for (int row = 0; row < h2; ++row) {
                            System.arraycopy(b, c * srcPlane + (row + y) * srcRowLen + x * bpp, buf, h2 * rowLen * c + row * rowLen, rowLen);
                        }
                    }
                }
            } else {
                if (tile.isDeflate) {
                    throw new UnsupportedCompressionException("Deflate data is not supported.");
                }
                int width = tile.region.width;
                int height = tile.region.height;
                this.readPlane(stream, x, y, w, h2, 0, width, height, buf);
            }
        }
    }

    private void parsePixelSpacing(String value) {
        this.pixelSizeY = value.substring(0, value.indexOf("\\"));
        this.pixelSizeX = value.substring(value.lastIndexOf("\\") + 1);
    }

    private void handleReferencedFile(DicomTag tag, String currentType) {
        if ("IMAGE".equals(currentType)) {
            int seriesIndex;
            if (this.fileList == null) {
                this.fileList = new HashMap<Integer, List<String>>();
            }
            if (this.fileList.get(seriesIndex = this.originalSeries) == null) {
                this.fileList.put(seriesIndex, new ArrayList());
            }
            this.fileList.get(seriesIndex).add(tag.getStringValue());
        } else {
            this.companionFiles.add(new Location(tag.getStringValue()).getAbsolutePath());
        }
    }

    private void calculatePixelsOffsets(long baseOffset) throws FormatException, IOException {
        this.zOffsets = new HashMap<Integer, List<Double>>();
        if (baseOffset == this.in.length()) {
            return;
        }
        int channelCount = this.getRGBChannelCount();
        if (this.lut != null || channelCount == 0) {
            channelCount = 1;
        }
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int plane = this.originalX * this.originalY * channelCount * bpp;
        this.in.seek(baseOffset - 12L);
        int len = this.in.readInt();
        if (len >= 0 && (long)len + this.in.getFilePointer() < this.in.length()) {
            this.in.skipBytes(len);
            int check = this.in.readShort() & 0xFFFF;
            if (check == 65534) {
                baseOffset = this.in.getFilePointer() + 2L;
            }
        }
        long offset = baseOffset;
        for (int i = 0; i < this.imagesPerFile; ++i) {
            if (this.isRLE) {
                if (i == 0) {
                    this.in.seek(baseOffset);
                } else {
                    this.in.seek(offset);
                    CodecOptions options = new CodecOptions();
                    options.maxBytes = plane / bpp;
                    for (int q = 0; q < bpp; ++q) {
                        new PackbitsCodec().decompress(this.in, options);
                        while (this.in.read() == 0) {
                        }
                        this.in.seek(this.in.getFilePointer() - 1L);
                    }
                }
                this.in.skipBytes(i == 0 ? 64 : 53);
                while (this.in.read() == 0) {
                }
                offset = this.in.getFilePointer() - 1L;
            } else if (this.isJPEG || this.isJP2K) {
                offset = i == 0 ? baseOffset : (offset += 3L);
                this.in.seek(offset);
                byte secondCheck = this.isJPEG ? (byte)-40 : 79;
                byte[] buf = new byte[(int)Math.min(8192L, this.in.length() - this.in.getFilePointer())];
                int n = this.in.read(buf);
                boolean found = false;
                boolean endFound = false;
                while (!found && n > 4) {
                    int q;
                    for (q = 0; q < n - 3; ++q) {
                        if (buf[q] == -1 && buf[q + 1] == secondCheck && buf[q + 2] == -1) {
                            if (!this.isJPEG && (!this.isJP2K || buf[q + 3] != 81)) continue;
                            if (!endFound && i != 0) break;
                            found = true;
                            offset = this.in.getFilePointer() + (long)q - (long)n;
                            break;
                        }
                        if (buf[q] != -1 || buf[q + 1] != -39) continue;
                        endFound = true;
                    }
                    if (found) continue;
                    for (q = 0; q < 4; ++q) {
                        buf[q] = buf[buf.length + q - 4];
                    }
                    n = this.in.read(buf, 4, buf.length - 4) + 4;
                }
            } else {
                offset = baseOffset + (long)(plane * i);
            }
            this.tilePositions.get((Object)Integer.valueOf((int)this.getCoreIndex())).get((int)i).fileOffset = offset;
            boolean bl = this.tilePositions.get((Object)Integer.valueOf((int)this.getCoreIndex())).get((int)i).last = i == this.imagesPerFile - 1;
            if (i > 0) {
                this.tilePositions.get((Object)Integer.valueOf((int)this.getCoreIndex())).get((int)(i - 1)).endOffset = this.tilePositions.get((Object)Integer.valueOf((int)this.getCoreIndex())).get((int)i).fileOffset;
            }
            if (i == this.imagesPerFile - 1) {
                this.tilePositions.get((Object)Integer.valueOf((int)this.getCoreIndex())).get((int)i).endOffset = this.in.length();
            }
            if (!this.zOffsets.containsKey(this.getCoreIndex())) {
                this.zOffsets.put(this.getCoreIndex(), new ArrayList());
            }
            Double z = this.tilePositions.get((Object)Integer.valueOf((int)this.getCoreIndex())).get((int)i).zOffset;
            if (this.zOffsets.get(this.getCoreIndex()).contains(z)) continue;
            this.zOffsets.get(this.getCoreIndex()).add(z);
        }
    }

    private DicomFileInfo createFileInfo(String file2) throws FormatException, IOException {
        if (new Location(file2).getAbsolutePath().equals(new Location(this.currentId).getAbsolutePath())) {
            DicomFileInfo info = new DicomFileInfo();
            info.file = new Location(file2).getAbsolutePath();
            info.concatenationIndex = this.getConcatenationIndex();
            info.coreMetadata = (CoreMetadata)this.core.get(0, 0);
            info.tiles = new ArrayList<DicomTile>();
            for (DicomTile t : this.getTiles()) {
                info.tiles.add(t);
            }
            info.imageType = this.getImageType();
            info.zOffsets = this.getZOffsets();
            info.edf = this.edf;
            info.pixelSizeX = this.getPixelSizeX();
            info.pixelSizeY = this.getPixelSizeY();
            info.pixelSizeZ = this.getPixelSizeZ();
            info.positionX = this.getPositionX();
            info.positionY = this.getPositionY();
            info.positionZ = this.getPositionZ();
            info.channelNames = this.getChannelNames();
            info.timestamp = this.getTimestamp();
            return info;
        }
        return new DicomFileInfo(new Location(file2).getAbsolutePath());
    }

    private void updateCoreMetadata(CoreMetadata ms) {
        if (ms.sizeC == 0) {
            ms.sizeC = 1;
        }
        ms.sizeT = 1;
        ms.dimensionOrder = "XYCZT";
        ms.metadataComplete = true;
        ms.falseColor = false;
        if (this.isRLE) {
            ms.interleaved = false;
        }
        ms.imageCount = ms.sizeZ;
        if (!ms.rgb) {
            ms.imageCount *= ms.sizeC;
        }
    }

    public String getImageType() {
        return this.imageType;
    }

    public List<DicomTile> getTiles() {
        return this.tilePositions.get(0);
    }

    public List<Double> getZOffsets() {
        return this.zOffsets.get(0);
    }

    public int getConcatenationIndex() {
        if (this.concatenationNumber == null) {
            return 0;
        }
        return this.concatenationNumber.intValue() - 1;
    }

    public Length getPixelSizeX() {
        if (this.pixelSizeX == null) {
            return null;
        }
        return FormatTools.getPhysicalSizeX(new Double(this.pixelSizeX), UNITS.MILLIMETER);
    }

    public Length getPixelSizeY() {
        if (this.pixelSizeY == null) {
            return null;
        }
        return FormatTools.getPhysicalSizeY(new Double(this.pixelSizeY), UNITS.MILLIMETER);
    }

    public Length getPixelSizeZ() {
        if (this.pixelSizeZ == null) {
            return null;
        }
        return FormatTools.getPhysicalSizeZ(new Double(this.pixelSizeZ), UNITS.MILLIMETER);
    }

    public List<Double> getPositionX() {
        ArrayList<Double> rtn = new ArrayList<Double>();
        rtn.addAll(this.positionX);
        return rtn;
    }

    public List<Double> getPositionY() {
        ArrayList<Double> rtn = new ArrayList<Double>();
        rtn.addAll(this.positionY);
        return rtn;
    }

    public List<Double> getPositionZ() {
        ArrayList<Double> rtn = new ArrayList<Double>();
        rtn.addAll(this.positionZ);
        return rtn;
    }

    public List<String> getChannelNames() {
        ArrayList<String> rtn = new ArrayList<String>();
        rtn.addAll(this.channelNames);
        return rtn;
    }

    public boolean isExtendedDepthOfField() {
        return this.edf;
    }

    public Timestamp getTimestamp() {
        String stamp = null;
        if (this.date != null && this.time != null) {
            stamp = this.date + " " + this.time;
            stamp = DateTools.formatDate(stamp, "yyyy.MM.dd HH:mm:ss", ".");
        }
        if (stamp != null && !stamp.isEmpty()) {
            return new Timestamp(stamp);
        }
        return null;
    }

    public List<DicomTag> getTags() {
        return this.tags;
    }
}

