/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.CharacterEncoding;
import ch.systemsx.cisd.hdf5.CompoundTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5;
import ch.systemsx.cisd.hdf5.HDF5CompoundByteifyerFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundDataList;
import ch.systemsx.cisd.hdf5.HDF5CompoundDataMap;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5MemberByteifyer;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.PaddingUtils;
import ch.systemsx.cisd.hdf5.ReflectionUtils;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class HDF5ValueObjectByteifyer<T> {
    private final HDF5MemberByteifyer[] byteifyers;
    private final int recordSizeInMemory;
    private final int recordSizeOnDisk;
    private final int[] vlMemberIndices;
    private Class<?> cachedRecordClass;
    private Constructor<?> cachedDefaultConstructor;

    private static <T> T newMap(int size) {
        return (T)new HDF5CompoundDataMap(size);
    }

    private static <T> T newList(int size) {
        return (T)new HDF5CompoundDataList((Collection<? extends Object>)Collections.nCopies(size, null));
    }

    private static <T> T newArray(int size) {
        return (T)new Object[size];
    }

    HDF5ValueObjectByteifyer(Class<T> clazz, IFileAccessProvider fileInfoProvider, CompoundTypeInformation compoundTypeInfoOrNull, HDF5CompoundMemberMapping ... members) {
        int n;
        this.byteifyers = HDF5CompoundByteifyerFactory.createMemberByteifyers(clazz, fileInfoProvider, compoundTypeInfoOrNull, members);
        int numberOfVLMembers = 0;
        if (compoundTypeInfoOrNull != null) {
            this.recordSizeOnDisk = compoundTypeInfoOrNull.recordSizeOnDisk;
            this.recordSizeInMemory = compoundTypeInfoOrNull.recordSizeInMemory;
            numberOfVLMembers = compoundTypeInfoOrNull.getNumberOfVLMembers();
        } else if (this.byteifyers.length > 0) {
            this.recordSizeOnDisk = this.byteifyers[this.byteifyers.length - 1].getTotalSizeOnDisk();
            this.recordSizeInMemory = PaddingUtils.padOffset(this.byteifyers[this.byteifyers.length - 1].getTotalSizeInMemory(), PaddingUtils.findMaxElementSize(this.byteifyers));
            HDF5MemberByteifyer[] hDF5MemberByteifyerArray = this.byteifyers;
            n = this.byteifyers.length;
            int n2 = 0;
            while (n2 < n) {
                HDF5MemberByteifyer byteifyer = hDF5MemberByteifyerArray[n2];
                if (byteifyer.isVariableLengthType()) {
                    ++numberOfVLMembers;
                }
                ++n2;
            }
        } else {
            this.recordSizeOnDisk = 0;
            this.recordSizeInMemory = 0;
        }
        this.vlMemberIndices = new int[numberOfVLMembers];
        int idx = 0;
        HDF5MemberByteifyer[] hDF5MemberByteifyerArray = this.byteifyers;
        int n3 = this.byteifyers.length;
        n = 0;
        while (n < n3) {
            HDF5MemberByteifyer byteifyer = hDF5MemberByteifyerArray[n];
            if (byteifyer.isVariableLengthType()) {
                this.vlMemberIndices[idx++] = byteifyer.getOffsetInMemory();
            }
            ++n;
        }
    }

    public long insertMemberTypes(long dataTypeId) {
        HDF5MemberByteifyer[] hDF5MemberByteifyerArray = this.byteifyers;
        int n = this.byteifyers.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5MemberByteifyer byteifyer = hDF5MemberByteifyerArray[n2];
            byteifyer.insertType(dataTypeId);
            ++n2;
        }
        return dataTypeId;
    }

    public long insertNativeMemberTypes(long dataTypeId, HDF5 h5, ICleanUpRegistry registry) {
        HDF5MemberByteifyer[] hDF5MemberByteifyerArray = this.byteifyers;
        int n = this.byteifyers.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5MemberByteifyer byteifyer = hDF5MemberByteifyerArray[n2];
            byteifyer.insertNativeType(dataTypeId, h5, registry);
            ++n2;
        }
        return dataTypeId;
    }

    public byte[] byteify(long compoundDataTypeId, T[] arr) throws HDF5JavaException {
        byte[] barray = new byte[arr.length * this.recordSizeInMemory];
        int offset = 0;
        int counter = 0;
        T[] TArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            T obj = TArray[n2];
            HDF5MemberByteifyer[] hDF5MemberByteifyerArray = this.byteifyers;
            int n3 = this.byteifyers.length;
            int n4 = 0;
            while (n4 < n3) {
                HDF5MemberByteifyer byteifyer = hDF5MemberByteifyerArray[n4];
                try {
                    byte[] b = byteifyer.byteify(compoundDataTypeId, obj);
                    if (b.length > byteifyer.getSize() && !byteifyer.mayBeCut()) {
                        throw new HDF5JavaException("Compound " + byteifyer.describe() + " of array element " + counter + " must not exceed " + byteifyer.getSize() + " bytes, but is of size " + b.length + " bytes.");
                    }
                    System.arraycopy(b, 0, barray, offset + byteifyer.getOffsetInMemory(), Math.min(b.length, byteifyer.getSize()));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new HDF5JavaException("Error accessing " + byteifyer.describe());
                }
                ++n4;
            }
            offset += this.recordSizeInMemory;
            ++counter;
            ++n2;
        }
        return barray;
    }

    public byte[] byteify(long compoundDataTypeId, T obj) throws HDF5JavaException {
        byte[] barray = new byte[this.recordSizeInMemory];
        HDF5MemberByteifyer[] hDF5MemberByteifyerArray = this.byteifyers;
        int n = this.byteifyers.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5MemberByteifyer byteifyer = hDF5MemberByteifyerArray[n2];
            try {
                byte[] b = byteifyer.byteify(compoundDataTypeId, obj);
                if (b.length > byteifyer.getSize() && !byteifyer.mayBeCut()) {
                    throw new HDF5JavaException("Compound " + byteifyer.describe() + " must not exceed " + byteifyer.getSize() + " bytes, but is of size " + b.length + " bytes.");
                }
                System.arraycopy(b, 0, barray, byteifyer.getOffsetInMemory(), Math.min(b.length, byteifyer.getSize()));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new HDF5JavaException("Error accessing " + byteifyer.describe());
            }
            ++n2;
        }
        return barray;
    }

    public T[] arrayify(long compoundDataTypeId, byte[] byteArr, Class<T> recordClass) {
        int length = byteArr.length / this.recordSizeInMemory;
        if (length * this.recordSizeInMemory != byteArr.length) {
            throw new HDF5JavaException("Illegal byte array for compound type (length " + byteArr.length + " is not a multiple of record size " + this.recordSizeInMemory + ")");
        }
        T[] result = HDF5Utils.createArray(recordClass, length);
        int offset = 0;
        int i = 0;
        while (i < length) {
            result[i] = this.primArrayifyScalar(compoundDataTypeId, byteArr, recordClass, offset);
            offset += this.recordSizeInMemory;
            ++i;
        }
        return result;
    }

    public T arrayifyScalar(long compoundDataTypeId, byte[] byteArr, Class<T> recordClass) {
        if (byteArr.length < this.recordSizeInMemory) {
            throw new HDF5JavaException("Illegal byte array for scalar compound type (length " + byteArr.length + " is smaller than record size " + this.recordSizeInMemory + ")");
        }
        return this.primArrayifyScalar(compoundDataTypeId, byteArr, recordClass, 0);
    }

    private T primArrayifyScalar(long compoundDataTypeId, byte[] byteArr, Class<T> recordClass, int offset) {
        T result = this.newInstance(recordClass);
        HDF5MemberByteifyer[] hDF5MemberByteifyerArray = this.byteifyers;
        int n = this.byteifyers.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5MemberByteifyer byteifyer = hDF5MemberByteifyerArray[n2];
            try {
                byteifyer.setFromByteArray(compoundDataTypeId, result, byteArr, offset);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new HDF5JavaException("Error accessing " + byteifyer.describe());
            }
            ++n2;
        }
        return result;
    }

    private T newInstance(Class<?> recordClass) throws HDF5JavaException {
        if (Map.class.isAssignableFrom(recordClass)) {
            return HDF5ValueObjectByteifyer.newMap(this.byteifyers.length);
        }
        if (List.class.isAssignableFrom(recordClass)) {
            return HDF5ValueObjectByteifyer.newList(this.byteifyers.length);
        }
        if (recordClass == Object[].class) {
            return HDF5ValueObjectByteifyer.newArray(this.byteifyers.length);
        }
        try {
            if (recordClass != this.cachedRecordClass) {
                this.cachedRecordClass = recordClass;
                this.cachedDefaultConstructor = ReflectionUtils.getDefaultConstructor(recordClass);
            }
            return (T)this.cachedDefaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new HDF5JavaException("Creation of new object of class " + recordClass.getCanonicalName() + " by default constructor failed: " + ex.toString());
        }
    }

    public int getRecordSizeOnDisk() {
        return this.recordSizeOnDisk;
    }

    public int getRecordSizeInMemory() {
        return this.recordSizeInMemory;
    }

    public HDF5MemberByteifyer[] getByteifyers() {
        return this.byteifyers;
    }

    public boolean hasUnmappedMembers() {
        HDF5MemberByteifyer[] hDF5MemberByteifyerArray = this.byteifyers;
        int n = this.byteifyers.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5MemberByteifyer memberByteifyer = hDF5MemberByteifyerArray[n2];
            if (memberByteifyer.isDummy()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String[] getUnmappedMembers() {
        if (this.hasUnmappedMembers()) {
            ArrayList<String> unmappedMembers = new ArrayList<String>();
            HDF5MemberByteifyer[] hDF5MemberByteifyerArray = this.byteifyers;
            int n = this.byteifyers.length;
            int n2 = 0;
            while (n2 < n) {
                HDF5MemberByteifyer memberByteifyer = hDF5MemberByteifyerArray[n2];
                if (memberByteifyer.isDummy()) {
                    unmappedMembers.add(memberByteifyer.getMemberName());
                }
                ++n2;
            }
            return unmappedMembers.toArray(new String[unmappedMembers.size()]);
        }
        return new String[0];
    }

    boolean hasVLMembers() {
        return this.vlMemberIndices.length > 0;
    }

    int[] getVLMemberIndices() {
        return this.vlMemberIndices;
    }

    public String toString() {
        return "HDF5ValueObjectByteifyer [byteifyers=" + Arrays.toString(this.byteifyers) + "]";
    }

    static interface IFileAccessProvider {
        public long getBooleanDataTypeId();

        public long getStringDataTypeId(int var1);

        public long getVariableLengthStringDataTypeId();

        public long getArrayTypeId(long var1, int var3);

        public long getArrayTypeId(long var1, int[] var3);

        public HDF5EnumerationType getEnumType(String[] var1);

        public CharacterEncoding getCharacterEncoding(long var1);

        public byte[] createObjectReference(String var1);
    }
}

