/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDIntArray;
import ch.systemsx.cisd.hdf5.HDF5ArrayBlockParams;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5DataSet;
import ch.systemsx.cisd.hdf5.HDF5DataSetTemplate;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5UnsignedIntReader;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5IntWriter;
import ch.systemsx.cisd.hdf5.IndexMap;
import ch.systemsx.cisd.hdf5.MatrixUtils;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import java.util.Map;

class HDF5UnsignedIntWriter
extends HDF5UnsignedIntReader
implements IHDF5IntWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5UnsignedIntWriter(HDF5BaseWriter baseWriter) {
        super(baseWriter);
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    @Override
    public void setAttr(final String objectPath, final String name, final int value) {
        assert (objectPath != null);
        assert (name != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Object> addAttributeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                if (((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.useSimpleDataSpaceForAttributes) {
                    long dataSpaceId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.createSimpleDataSpace(new long[]{1L}, registry);
                    HDF5UnsignedIntWriter.this.baseWriter.setAttribute(objectPath, name, HDF5Constants.H5T_STD_U32LE, HDF5Constants.H5T_NATIVE_UINT32, dataSpaceId, new int[]{value}, registry);
                } else {
                    HDF5UnsignedIntWriter.this.baseWriter.setAttribute(objectPath, name, HDF5Constants.H5T_STD_U32LE, HDF5Constants.H5T_NATIVE_UINT32, -1L, new int[]{value}, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(addAttributeRunnable);
    }

    @Override
    public void setArrayAttr(final String objectPath, final String name, final int[] value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.useSimpleDataSpaceForAttributes) {
                    long dataSpaceId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.createSimpleDataSpace(new long[]{value.length}, registry);
                    HDF5UnsignedIntWriter.this.baseWriter.setAttribute(objectPath, name, HDF5Constants.H5T_STD_U32LE, HDF5Constants.H5T_NATIVE_UINT32, dataSpaceId, value, registry);
                } else {
                    long memoryTypeId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_UINT32, value.length, registry);
                    long storageTypeId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_U32LE, value.length, registry);
                    HDF5UnsignedIntWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, -1L, value, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    @Override
    public void setMDArrayAttr(final String objectPath, final String name, final MDIntArray value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> addAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.useSimpleDataSpaceForAttributes) {
                    long dataSpaceId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.createSimpleDataSpace(value.longDimensions(), registry);
                    HDF5UnsignedIntWriter.this.baseWriter.setAttribute(objectPath, name, HDF5Constants.H5T_STD_U32LE, HDF5Constants.H5T_NATIVE_UINT32, dataSpaceId, value.getAsFlatArray(), registry);
                } else {
                    long memoryTypeId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_UINT32, value.dimensions(), registry);
                    long storageTypeId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_U32LE, value.dimensions(), registry);
                    HDF5UnsignedIntWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, -1L, value.getAsFlatArray(), registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(addAttributeRunnable);
    }

    @Override
    public void setMatrixAttr(String objectPath, String name, int[][] value) {
        this.setMDArrayAttr(objectPath, name, new MDIntArray(value));
    }

    @Override
    public void write(String objectPath, int value) {
        assert (objectPath != null);
        this.baseWriter.checkOpen();
        this.baseWriter.writeScalar(objectPath, HDF5Constants.H5T_STD_U32LE, HDF5Constants.H5T_NATIVE_UINT32, value);
    }

    @Override
    public void writeArray(String objectPath, int[] data) {
        this.writeArray(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void writeArray(final String objectPath, final int[] data, final HDF5IntStorageFeatures features) {
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long dataSetId = HDF5UnsignedIntWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_STD_U32LE, new long[]{data.length}, 4, features, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_UINT32, (long)HDF5Constants.H5S_ALL, (long)HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeArray(final String objectPath, final int[] data, final HDF5DataSetTemplate template) {
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long dataSetId = HDF5UnsignedIntWriter.this.baseWriter.createDataSetFromTemplate(objectPath, template, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_UINT32, (long)HDF5Constants.H5S_ALL, (long)HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createArray(String objectPath, int size) {
        this.createArray(objectPath, size, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createArray(String objectPath, long size, int blockSize) {
        this.createArray(objectPath, size, blockSize, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public HDF5DataSet createArrayAndOpen(String objectPath, int size) {
        return this.createArrayAndOpen(objectPath, size, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public HDF5DataSet createArrayAndOpen(String objectPath, long size, int blockSize) {
        return this.createArrayAndOpen(objectPath, size, blockSize, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createArray(final String objectPath, final int size, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    HDF5UnsignedIntWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U32LE, features, new long[1], new long[]{size}, 4, registry);
                } else {
                    HDF5UnsignedIntWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U32LE, features, new long[]{size}, null, 4, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void createArray(final String objectPath, final HDF5DataSetTemplate template) {
        assert (objectPath != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5UnsignedIntWriter.this.baseWriter.createDataSetFromTemplate(objectPath, template, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public HDF5DataSet createArrayAndOpen(String objectPath, int size, HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        if (features.requiresChunking()) {
            return this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U32LE, features, new long[1], new long[]{size}, 4);
        }
        return this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U32LE, features, new long[]{size}, null, 4);
    }

    @Override
    public HDF5DataSet createArrayAndOpen(String objectPath, HDF5DataSetTemplate template) {
        assert (objectPath != null);
        this.baseWriter.checkOpen();
        long dataSetId = this.baseWriter.createDataSetFromTemplate(objectPath, template, null);
        return new HDF5DataSet(this.baseWriter, objectPath, dataSetId, template.getDataspaceId(), template.getDimensions(), template.getMaxDimensions(), template.getLayout(), false);
    }

    @Override
    public void createArray(final String objectPath, final long size, final int blockSize, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0L);
        assert (blockSize >= 0 && ((long)blockSize <= size || size == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5UnsignedIntWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U32LE, features, new long[]{size}, new long[]{blockSize}, 4, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public HDF5DataSet createArrayAndOpen(String objectPath, long size, int blockSize, HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0L);
        assert (blockSize >= 0 && ((long)blockSize <= size || size == 0L));
        this.baseWriter.checkOpen();
        return this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U32LE, features, new long[]{size}, new long[]{blockSize}, 4);
    }

    @Override
    public HDF5DataSetTemplate createArrayTemplate(long size, int blockSize, HDF5IntStorageFeatures features) {
        assert (size >= 0L);
        assert (blockSize >= 0 && ((long)blockSize <= size || size == 0L));
        this.baseWriter.checkOpen();
        return this.baseWriter.createDataSetTemplate(HDF5Constants.H5T_STD_U32LE, features, new long[]{size}, new long[]{blockSize}, 4);
    }

    @Override
    public void writeArrayBlock(String objectPath, int[] data, long blockNumber) {
        this.writeArrayBlockWithOffset(objectPath, data, data.length, (long)data.length * blockNumber);
    }

    @Override
    public void writeArrayBlock(HDF5DataSet dataSet, int[] data, long blockNumber) {
        this.writeArrayBlockWithOffset(dataSet, data, data.length, (long)data.length * blockNumber);
    }

    @Override
    public void writeArrayBlockWithOffset(final String objectPath, final int[] data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                long dataSetId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.fileId, objectPath, ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, false, registry);
                long dataSpaceId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                long memorySpaceId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_UINT32, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeArrayBlockWithOffset(final HDF5DataSet dataSet, final int[] data, final int dataSize, final long offset) {
        assert (dataSet != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        this.baseWriter.h5.checkRank(1, dataSet.getRank());
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                long[] requiredDimensions = new long[]{offset + (long)dataSize};
                if (((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.extendDataSet(dataSet, requiredDimensions, false, registry)) {
                    dataSet.setDimensions(requiredDimensions);
                }
                long dataSpaceId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSet.getDataSetId(), registry);
                ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                long memorySpaceId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5.H5Dwrite(dataSet.getDataSetId(), HDF5Constants.H5T_NATIVE_UINT32, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeMatrix(String objectPath, int[][] data) {
        this.writeMatrix(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void writeMatrix(String objectPath, int[][] data, HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        assert (HDF5Utils.areMatrixDimensionsConsistent(data));
        this.writeMDArray(objectPath, new MDIntArray(data), features);
    }

    @Override
    public void createMatrix(String objectPath, int sizeX, int sizeY) {
        assert (objectPath != null);
        assert (sizeX >= 0);
        assert (sizeY >= 0);
        this.createMDArray(objectPath, new int[]{sizeX, sizeY});
    }

    @Override
    public void createMatrix(String objectPath, int sizeX, int sizeY, HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (sizeX >= 0);
        assert (sizeY >= 0);
        this.createMDArray(objectPath, new int[]{sizeX, sizeY}, features);
    }

    @Override
    public void createMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY) {
        assert (objectPath != null);
        assert (sizeX >= 0L);
        assert (sizeY >= 0L);
        assert (blockSizeX >= 0 && ((long)blockSizeX <= sizeX || sizeX == 0L));
        assert (blockSizeY >= 0 && ((long)blockSizeY <= sizeY || sizeY == 0L));
        this.createMDArray(objectPath, new long[]{sizeX, sizeY}, new int[]{blockSizeX, blockSizeY});
    }

    @Override
    public void createMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY, HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (sizeX >= 0L);
        assert (sizeY >= 0L);
        assert (blockSizeX >= 0 && ((long)blockSizeX <= sizeX || sizeX == 0L));
        assert (blockSizeY >= 0 && ((long)blockSizeY <= sizeY || sizeY == 0L));
        this.createMDArray(objectPath, new long[]{sizeX, sizeY}, new int[]{blockSizeX, blockSizeY}, features);
    }

    @Override
    public void writeMatrixBlock(String objectPath, int[][] data, long blockNumberX, long blockNumberY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeMDArrayBlock(objectPath, new MDIntArray(data), new long[]{blockNumberX, blockNumberY});
    }

    @Override
    public void writeMatrixBlockWithOffset(String objectPath, int[][] data, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeMDArrayBlockWithOffset(objectPath, new MDIntArray(data, new int[]{data.length, data[0].length}), new long[]{offsetX, offsetY});
    }

    @Override
    public void writeMatrixBlockWithOffset(String objectPath, int[][] data, int dataSizeX, int dataSizeY, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeMDArrayBlockWithOffset(objectPath, new MDIntArray(data, new int[]{dataSizeX, dataSizeY}), new long[]{offsetX, offsetY});
    }

    @Override
    public void writeMDArray(String objectPath, MDIntArray data) {
        this.writeMDArray(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void writeMDArraySlice(String objectPath, MDIntArray data, IndexMap boundIndices) {
        this.baseWriter.checkOpen();
        int fullRank = this.baseWriter.getRank(objectPath);
        int[] fullBlockDimensions = new int[fullRank];
        long[] fullOffset = new long[fullRank];
        MatrixUtils.createFullBlockDimensionsAndOffset(data.dimensions(), null, (Map<Integer, Long>)boundIndices, fullRank, fullBlockDimensions, fullOffset);
        this.writeMDArrayBlockWithOffset(objectPath, new MDIntArray(data.getAsFlatArray(), fullBlockDimensions), fullOffset);
    }

    @Override
    public void writeMDArraySlice(HDF5DataSet dataSet, MDIntArray data, IndexMap boundIndices) {
        this.baseWriter.checkOpen();
        int fullRank = dataSet.getFullRank();
        int[] fullBlockDimensions = new int[fullRank];
        long[] fullOffset = new long[fullRank];
        MatrixUtils.createFullBlockDimensionsAndOffset(data.dimensions(), null, (Map<Integer, Long>)boundIndices, fullRank, fullBlockDimensions, fullOffset);
        this.writeMDArrayBlockWithOffset(dataSet, new MDIntArray(data.getAsFlatArray(), fullBlockDimensions), fullOffset);
    }

    @Override
    public void writeMDArraySlice(String objectPath, MDIntArray data, long[] boundIndices) {
        this.baseWriter.checkOpen();
        int fullRank = this.baseWriter.getRank(objectPath);
        int[] fullBlockDimensions = new int[fullRank];
        long[] fullOffset = new long[fullRank];
        MatrixUtils.createFullBlockDimensionsAndOffset(data.dimensions(), null, boundIndices, fullRank, fullBlockDimensions, fullOffset);
        this.writeMDArrayBlockWithOffset(objectPath, new MDIntArray(data.getAsFlatArray(), fullBlockDimensions), fullOffset);
    }

    @Override
    public void writeMDArraySlice(HDF5DataSet dataSet, MDIntArray data, long[] boundIndices) {
        this.baseWriter.checkOpen();
        int fullRank = dataSet.getFullRank();
        int[] fullBlockDimensions = new int[fullRank];
        long[] fullOffset = new long[fullRank];
        MatrixUtils.createFullBlockDimensionsAndOffset(data.dimensions(), null, boundIndices, fullRank, fullBlockDimensions, fullOffset);
        this.writeMDArrayBlockWithOffset(dataSet, new MDIntArray(data.getAsFlatArray(), fullBlockDimensions), fullOffset);
    }

    @Override
    public void writeMDArray(final String objectPath, final MDIntArray data, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long dataSetId = HDF5UnsignedIntWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_STD_U32LE, data.longDimensions(), 4, features, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_UINT32, (long)HDF5Constants.H5S_ALL, (long)HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeMDArray(final String objectPath, final MDIntArray data, final HDF5DataSetTemplate template) {
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long dataSetId = HDF5UnsignedIntWriter.this.baseWriter.createDataSetFromTemplate(objectPath, template, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_UINT32, (long)HDF5Constants.H5S_ALL, (long)HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createMDArray(String objectPath, int[] dimensions) {
        this.createMDArray(objectPath, dimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public HDF5DataSet createMDArrayAndOpen(String objectPath, long[] dimensions, int[] blockDimensions) {
        return this.createMDArrayAndOpen(objectPath, dimensions, blockDimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.createMDArray(objectPath, dimensions, blockDimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createMDArray(final String objectPath, final int[] dimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    long[] nullDimensions = new long[dimensions.length];
                    HDF5UnsignedIntWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U32LE, features, nullDimensions, MDArray.toLong(dimensions), 4, registry);
                } else {
                    HDF5UnsignedIntWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U32LE, features, MDArray.toLong(dimensions), null, 4, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public HDF5DataSet createMDArrayAndOpen(String objectPath, int[] dimensions) {
        return this.createMDArrayAndOpen(objectPath, dimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public HDF5DataSet createMDArrayAndOpen(final String objectPath, final int[] dimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<HDF5DataSet> createRunnable = new ICallableWithCleanUp<HDF5DataSet>(){

            @Override
            public HDF5DataSet call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    long[] nullDimensions = new long[dimensions.length];
                    return HDF5UnsignedIntWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U32LE, features, nullDimensions, MDArray.toLong(dimensions), 4);
                }
                return HDF5UnsignedIntWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U32LE, features, MDArray.toLong(dimensions), null, 4);
            }
        };
        return this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void createMDArray(final String objectPath, final long[] dimensions, final int[] blockDimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        assert (blockDimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5UnsignedIntWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U32LE, features, dimensions, MDArray.toLong(blockDimensions), 4, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void createMDArray(final String objectPath, final HDF5DataSetTemplate template) {
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5UnsignedIntWriter.this.baseWriter.createDataSetFromTemplate(objectPath, template, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public HDF5DataSet createMDArrayAndOpen(final String objectPath, final long[] dimensions, final int[] blockDimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        assert (blockDimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<HDF5DataSet> createRunnable = new ICallableWithCleanUp<HDF5DataSet>(){

            @Override
            public HDF5DataSet call(ICleanUpRegistry registry) {
                return HDF5UnsignedIntWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U32LE, features, dimensions, MDArray.toLong(blockDimensions), 4);
            }
        };
        return this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public HDF5DataSet createMDArrayAndOpen(final String objectPath, final HDF5DataSetTemplate template) {
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<HDF5DataSet> createRunnable = new ICallableWithCleanUp<HDF5DataSet>(){

            @Override
            public HDF5DataSet call(ICleanUpRegistry registry) {
                long dataSetId = HDF5UnsignedIntWriter.this.baseWriter.createDataSetFromTemplate(objectPath, template, null);
                return new HDF5DataSet(HDF5UnsignedIntWriter.this.baseWriter, objectPath, dataSetId, template.getDataspaceId(), template.getDimensions(), template.getMaxDimensions(), template.getLayout(), false);
            }
        };
        return this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public HDF5DataSetTemplate createMDArrayTemplate(long[] dimensions, int[] blockDimensions, HDF5IntStorageFeatures features) {
        assert (dimensions != null);
        assert (blockDimensions != null);
        this.baseWriter.checkOpen();
        return this.baseWriter.createDataSetTemplate(HDF5Constants.H5T_STD_U32LE, features, dimensions, MDArray.toLong(blockDimensions), 4);
    }

    @Override
    public void writeMDArrayBlock(String objectPath, MDIntArray data, long[] blockNumber) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeMDArrayBlockWithOffset(objectPath, data, offset);
    }

    @Override
    public void writeSlicedMDArrayBlock(String objectPath, MDIntArray data, long[] blockNumber, IndexMap boundIndices) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeSlicedMDArrayBlockWithOffset(objectPath, data, offset, boundIndices);
    }

    @Override
    public void writeSlicedMDArrayBlock(HDF5DataSet dataSet, MDIntArray data, long[] blockNumber, IndexMap boundIndices) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeSlicedMDArrayBlockWithOffset(dataSet, data, offset, boundIndices);
    }

    @Override
    public void writeSlicedMDArrayBlock(String objectPath, MDIntArray data, long[] blockNumber, long[] boundIndices) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeSlicedMDArrayBlockWithOffset(objectPath, data, offset, boundIndices);
    }

    @Override
    public void writeSlicedMDArrayBlock(HDF5DataSet dataSet, MDIntArray data, long[] blockNumber, long[] boundIndices) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeSlicedMDArrayBlockWithOffset(dataSet, data, offset, boundIndices);
    }

    @Override
    public void writeMDArray(HDF5DataSet dataSet, MDIntArray data, HDF5ArrayBlockParams params) {
        assert (dataSet != null);
        assert (data != null);
        assert (params != null);
        if (params.hasBlock()) {
            if (params.hasSlice()) {
                if (params.getBoundIndexArray() != null) {
                    this.writeSlicedMDArrayBlockWithOffset(dataSet, data, params.getOffset(data.dimensions()), params.getBoundIndexArray());
                } else {
                    this.writeSlicedMDArrayBlockWithOffset(dataSet, data, params.getOffset(data.dimensions()), params.getBoundIndexMap());
                }
                return;
            }
            this.writeMDArrayBlockWithOffset(dataSet, data, params.getOffset(data.dimensions()));
            return;
        }
        if (params.hasSlice()) {
            if (params.getBoundIndexArray() != null) {
                this.writeMDArraySlice(dataSet, data, params.getBoundIndexArray());
            } else {
                this.writeMDArraySlice(dataSet, data, params.getBoundIndexMap());
            }
            return;
        }
        this.writeMDArrayBlockWithOffset(dataSet, data, new long[data.rank()]);
    }

    @Override
    public void writeMDArrayBlockWithOffset(final String objectPath, final MDIntArray data, final long[] offset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = data.longDimensions();
                if (!$assertionsDisabled && dimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[dimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + dimensions[i];
                    ++i;
                }
                long dataSetId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.fileId, objectPath, ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.fileFormat, dataSetDimensions, false, registry);
                long dataSpaceId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, dimensions);
                long memorySpaceId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_UINT32, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeMDArrayBlock(HDF5DataSet dataSet, MDIntArray data, long[] blockNumber) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeMDArrayBlockWithOffset(dataSet, data, offset);
    }

    @Override
    public void writeMDArrayBlockWithOffset(final HDF5DataSet dataSet, final MDIntArray data, final long[] offset) {
        assert (dataSet != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        this.baseWriter.h5.checkRank(data.rank(), offset.length);
        this.baseWriter.h5.checkRank(data.rank(), dataSet.getRank());
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = data.longDimensions();
                if (!$assertionsDisabled && dimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[dimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + dimensions[i];
                    ++i;
                }
                dataSet.extend(dataSetDimensions);
                long dataSpaceId = dataSet.getDataSpaceId();
                ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, dimensions);
                long memorySpaceId = dataSet.getMemorySpaceId(dimensions);
                H5.H5Dwrite(dataSet.getDataSetId(), HDF5Constants.H5T_NATIVE_UINT32, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeSlicedMDArrayBlockWithOffset(String objectPath, MDIntArray data, long[] offset, IndexMap boundIndices) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        int fullRank = this.baseWriter.getRank(objectPath);
        int[] fullBlockDimensions = new int[fullRank];
        long[] fullOffset = new long[fullRank];
        MatrixUtils.createFullBlockDimensionsAndOffset(data.dimensions(), offset, (Map<Integer, Long>)boundIndices, fullRank, fullBlockDimensions, fullOffset);
        this.writeMDArrayBlockWithOffset(objectPath, new MDIntArray(data.getAsFlatArray(), fullBlockDimensions), fullOffset);
    }

    @Override
    public void writeSlicedMDArrayBlockWithOffset(HDF5DataSet dataSet, MDIntArray data, long[] offset, IndexMap boundIndices) {
        assert (dataSet != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        int fullRank = dataSet.getFullRank();
        int[] fullBlockDimensions = new int[fullRank];
        long[] fullOffset = new long[fullRank];
        MatrixUtils.createFullBlockDimensionsAndOffset(data.dimensions(), offset, (Map<Integer, Long>)boundIndices, fullRank, fullBlockDimensions, fullOffset);
        this.writeMDArrayBlockWithOffset(dataSet, new MDIntArray(data.getAsFlatArray(), fullBlockDimensions), fullOffset);
    }

    @Override
    public void writeSlicedMDArrayBlockWithOffset(String objectPath, MDIntArray data, long[] offset, long[] boundIndices) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        int fullRank = this.baseWriter.getRank(objectPath);
        int[] fullBlockDimensions = new int[fullRank];
        long[] fullOffset = new long[fullRank];
        MatrixUtils.createFullBlockDimensionsAndOffset(data.dimensions(), offset, boundIndices, fullRank, fullBlockDimensions, fullOffset);
        this.writeMDArrayBlockWithOffset(objectPath, new MDIntArray(data.getAsFlatArray(), fullBlockDimensions), fullOffset);
    }

    @Override
    public void writeSlicedMDArrayBlockWithOffset(HDF5DataSet dataSet, MDIntArray data, long[] offset, long[] boundIndices) {
        assert (dataSet != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        int fullRank = dataSet.getFullRank();
        int[] fullBlockDimensions = new int[fullRank];
        long[] fullOffset = new long[fullRank];
        MatrixUtils.createFullBlockDimensionsAndOffset(data.dimensions(), offset, boundIndices, fullRank, fullBlockDimensions, fullOffset);
        this.writeMDArrayBlockWithOffset(dataSet, new MDIntArray(data.getAsFlatArray(), fullBlockDimensions), fullOffset);
    }

    @Override
    public void writeMDArrayBlockWithOffset(final String objectPath, final MDIntArray data, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] memoryDimensions = data.longDimensions();
                if (!$assertionsDisabled && memoryDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] longBlockDimensions = MDArray.toLong(blockDimensions);
                if (!$assertionsDisabled && longBlockDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[blockDimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + (long)blockDimensions[i];
                    ++i;
                }
                long dataSetId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.fileId, objectPath, ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.fileFormat, dataSetDimensions, false, registry);
                long dataSpaceId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, longBlockDimensions);
                long memorySpaceId = ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.createSimpleDataSpace(memoryDimensions, registry);
                ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.setHyperslabBlock(memorySpaceId, MDArray.toLong(memoryOffset), longBlockDimensions);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_UINT32, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeMDArrayBlockWithOffset(final HDF5DataSet dataSet, final MDIntArray data, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (dataSet != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] memoryDimensions = data.longDimensions();
                if (!$assertionsDisabled && memoryDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] longBlockDimensions = MDArray.toLong(blockDimensions);
                if (!$assertionsDisabled && longBlockDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[blockDimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + (long)blockDimensions[i];
                    ++i;
                }
                long dataSetId = dataSet.getDataSetId();
                long dataSpaceId = dataSet.getDataSpaceId();
                ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, longBlockDimensions);
                long memorySpaceId = dataSet.getMemorySpaceId(memoryDimensions);
                ((HDF5UnsignedIntWriter)HDF5UnsignedIntWriter.this).baseWriter.h5.setHyperslabBlock(memorySpaceId, MDArray.toLong(memoryOffset), longBlockDimensions);
                H5.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_UINT32, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }
}

