# coding: utf-8

"""
    Mail-in-a-Box

    Mail-in-a-Box API HTTP specification.  # Introduction This API is documented in [**OpenAPI format**](http://spec.openapis.org/oas/v3.0.3). ([View the full HTTP specification](https://raw.githubusercontent.com/mail-in-a-box/mailinabox/api-spec/api/mailinabox.yml).)  All endpoints are relative to `https://{host}/admin` and are secured with [`Basic Access` authentication](https://en.wikipedia.org/wiki/Basic_access_authentication). If you have multi-factor authentication enabled, authentication with a `user:password` combination will fail unless a valid OTP is supplied via the `x-auth-token` header. Authentication via a `user:user_key` pair is possible without the header being present.   # noqa: E501

    The version of the OpenAPI document: 0.51.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailinabox_api.configuration import Configuration


class SystemBackupStatusResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "backups": "list[SystemBackupStatus]",
        "unmatched_file_size": "int",
        "error": "str",
    }

    attribute_map = {
        "backups": "backups",
        "unmatched_file_size": "unmatched_file_size",
        "error": "error",
    }

    def __init__(
        self,
        backups=None,
        unmatched_file_size=None,
        error=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """SystemBackupStatusResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._backups = None
        self._unmatched_file_size = None
        self._error = None
        self.discriminator = None

        if backups is not None:
            self.backups = backups
        self.unmatched_file_size = unmatched_file_size
        if error is not None:
            self.error = error

    @property
    def backups(self):
        """Gets the backups of this SystemBackupStatusResponse.  # noqa: E501


        :return: The backups of this SystemBackupStatusResponse.  # noqa: E501
        :rtype: list[SystemBackupStatus]
        """
        return self._backups

    @backups.setter
    def backups(self, backups):
        """Sets the backups of this SystemBackupStatusResponse.


        :param backups: The backups of this SystemBackupStatusResponse.  # noqa: E501
        :type: list[SystemBackupStatus]
        """

        self._backups = backups

    @property
    def unmatched_file_size(self):
        """Gets the unmatched_file_size of this SystemBackupStatusResponse.  # noqa: E501


        :return: The unmatched_file_size of this SystemBackupStatusResponse.  # noqa: E501
        :rtype: int
        """
        return self._unmatched_file_size

    @unmatched_file_size.setter
    def unmatched_file_size(self, unmatched_file_size):
        """Sets the unmatched_file_size of this SystemBackupStatusResponse.


        :param unmatched_file_size: The unmatched_file_size of this SystemBackupStatusResponse.  # noqa: E501
        :type: int
        """
        if (
            self.local_vars_configuration.client_side_validation
            and unmatched_file_size is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `unmatched_file_size`, must not be `None`"
            )  # noqa: E501

        self._unmatched_file_size = unmatched_file_size

    @property
    def error(self):
        """Gets the error of this SystemBackupStatusResponse.  # noqa: E501


        :return: The error of this SystemBackupStatusResponse.  # noqa: E501
        :rtype: str
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this SystemBackupStatusResponse.


        :param error: The error of this SystemBackupStatusResponse.  # noqa: E501
        :type: str
        """

        self._error = error

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SystemBackupStatusResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SystemBackupStatusResponse):
            return True

        return self.to_dict() != other.to_dict()
