# coding: utf-8

# flake8: noqa

"""
    Mail-in-a-Box

    Mail-in-a-Box API HTTP specification.  # Introduction This API is documented in [**OpenAPI format**](http://spec.openapis.org/oas/v3.0.3). ([View the full HTTP specification](https://raw.githubusercontent.com/mail-in-a-box/mailinabox/api-spec/api/mailinabox.yml).)  All endpoints are relative to `https://{host}/admin` and are secured with [`Basic Access` authentication](https://en.wikipedia.org/wiki/Basic_access_authentication). If you have multi-factor authentication enabled, authentication with a `user:password` combination will fail unless a valid OTP is supplied via the `x-auth-token` header. Authentication via a `user:user_key` pair is possible without the header being present.   # noqa: E501

    The version of the OpenAPI document: 0.51.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

__version__ = "0.51.1"

# import apis into sdk package
from mailinabox_api.api.dns_api import DNSApi
from mailinabox_api.api.mfa_api import MFAApi
from mailinabox_api.api.mail_api import MailApi
from mailinabox_api.api.ssl_api import SSLApi
from mailinabox_api.api.system_api import SystemApi
from mailinabox_api.api.user_api import UserApi
from mailinabox_api.api.web_api import WebApi

# import ApiClient
from mailinabox_api.api_client import ApiClient
from mailinabox_api.configuration import Configuration
from mailinabox_api.exceptions import OpenApiException
from mailinabox_api.exceptions import ApiTypeError
from mailinabox_api.exceptions import ApiValueError
from mailinabox_api.exceptions import ApiKeyError
from mailinabox_api.exceptions import ApiException

# import models into sdk package
from mailinabox_api.models.dns_custom_record import DNSCustomRecord
from mailinabox_api.models.dns_custom_records_response import DNSCustomRecordsResponse
from mailinabox_api.models.dns_dump_domain_record import DNSDumpDomainRecord
from mailinabox_api.models.dns_dump_domain_records import DNSDumpDomainRecords
from mailinabox_api.models.dns_dump_domains import DNSDumpDomains
from mailinabox_api.models.dns_dump_response import DNSDumpResponse
from mailinabox_api.models.dns_record_type import DNSRecordType
from mailinabox_api.models.dns_secondary_nameserver_add_request import (
    DNSSecondaryNameserverAddRequest,
)
from mailinabox_api.models.dns_secondary_nameserver_response import (
    DNSSecondaryNameserverResponse,
)
from mailinabox_api.models.dns_update_request import DNSUpdateRequest
from mailinabox_api.models.dns_zones_response import DNSZonesResponse
from mailinabox_api.models.mail_alias import MailAlias
from mailinabox_api.models.mail_alias_by_domain import MailAliasByDomain
from mailinabox_api.models.mail_alias_remove_request import MailAliasRemoveRequest
from mailinabox_api.models.mail_alias_upsert_request import MailAliasUpsertRequest
from mailinabox_api.models.mail_aliases_response_format import MailAliasesResponseFormat
from mailinabox_api.models.mail_user import MailUser
from mailinabox_api.models.mail_user_add_privilege_request import (
    MailUserAddPrivilegeRequest,
)
from mailinabox_api.models.mail_user_add_request import MailUserAddRequest
from mailinabox_api.models.mail_user_by_domain import MailUserByDomain
from mailinabox_api.models.mail_user_privilege import MailUserPrivilege
from mailinabox_api.models.mail_user_remove_privilege_request import (
    MailUserRemovePrivilegeRequest,
)
from mailinabox_api.models.mail_user_remove_request import MailUserRemoveRequest
from mailinabox_api.models.mail_user_set_password_request import (
    MailUserSetPasswordRequest,
)
from mailinabox_api.models.mail_user_status import MailUserStatus
from mailinabox_api.models.mail_users_response import MailUsersResponse
from mailinabox_api.models.mail_users_response_format import MailUsersResponseFormat
from mailinabox_api.models.me_auth_status import MeAuthStatus
from mailinabox_api.models.me_response import MeResponse
from mailinabox_api.models.mfa_disable_request import MfaDisableRequest
from mailinabox_api.models.mfa_enable_request import MfaEnableRequest
from mailinabox_api.models.mfa_status_response import MfaStatusResponse
from mailinabox_api.models.mfa_status_response_enabled_mfa import (
    MfaStatusResponseEnabledMfa,
)
from mailinabox_api.models.mfa_status_response_new_mfa import MfaStatusResponseNewMfa
from mailinabox_api.models.sslcsr_generate_request import SSLCSRGenerateRequest
from mailinabox_api.models.ssl_certificate_install_request import (
    SSLCertificateInstallRequest,
)
from mailinabox_api.models.ssl_certificates_provision_response import (
    SSLCertificatesProvisionResponse,
)
from mailinabox_api.models.ssl_certificates_provision_response_requests import (
    SSLCertificatesProvisionResponseRequests,
)
from mailinabox_api.models.ssl_status import SSLStatus
from mailinabox_api.models.ssl_status_response import SSLStatusResponse
from mailinabox_api.models.ssl_status_type import SSLStatusType
from mailinabox_api.models.status_entry import StatusEntry
from mailinabox_api.models.status_entry_extra import StatusEntryExtra
from mailinabox_api.models.status_entry_type import StatusEntryType
from mailinabox_api.models.system_backup_config_response import (
    SystemBackupConfigResponse,
)
from mailinabox_api.models.system_backup_config_update_request import (
    SystemBackupConfigUpdateRequest,
)
from mailinabox_api.models.system_backup_status import SystemBackupStatus
from mailinabox_api.models.system_backup_status_response import (
    SystemBackupStatusResponse,
)
from mailinabox_api.models.system_privacy_status import SystemPrivacyStatus
from mailinabox_api.models.system_privacy_update_request import (
    SystemPrivacyUpdateRequest,
)
from mailinabox_api.models.system_status_response import SystemStatusResponse
from mailinabox_api.models.web_domain import WebDomain
