from .features import Dictionary, RegexMatches, Stopwords

name = "galician"


try:
    import enchant
    dictionary = enchant.Dict("gl")
except enchant.errors.DictNotFoundError:
    raise ImportError("No enchant-compatible dictionary found for 'gl'.  " +
                      "Consider installing 'hunspell-gl'.")


dictionary = Dictionary(name + ".dictionary", dictionary.check)
"""
:class:`~revscoring.languages.features.Dictionary` features via
:class:`enchant.Dict` "gl".  Provided by `hunspell-gl`
"""

stopwords = [
    r'abril',
    r'ademais',
    r'alg',
    r'america',
    r'and',
    r'ano',
    r'anos',
    r'antes',
    r'aos',
    r'artigo',
    r'artigos',
    r'ata',
    r'autoridades',
    r'baixo',
    r'base',
    r'ben',
    r'bibliograf',
    r'cada',
    r'cal',
    r'cando',
    r'cara',
    r'caracter',
    r'casa',
    r'case',
    r'categor',
    r'category',
    r'catro',
    r'centro',
    r'cidade',
    r'cita',
    r'coa',
    r'coas',
    r'coma',
    r'como',
    r'con',
    r'contra',
    r'control',
    r'coordenadas',
    r'cos',
    r'culo',
    r'cu',
    r'cun',
    r'cunha',
    r'das',
    r'data',
    r'decembro',
    r'defaultsort',
    r'del',
    r'dende',
    r'densidade',
    r'dereita',
    r'desde',
    r'despois',
    r'deste',
    r'dos',
    r'dous',
    r'dun',
    r'dunha',
    r'durante',
    r'entre',
    r'era',
    r'escudo',
    r'españa',
    r'esquerda',
    r'est',
    r'esta',
    r'estado',
    r'estados',
    r'este',
    r'estes',
    r'externas',
    r'febreiro',
    r'ficheiro',
    r'fico',
    r'file',
    r'finados',
    r'foi',
    r'forma',
    r'foron',
    r'galega',
    r'galego',
    r'galicia',
    r'gran',
    r'grande',
    r'grupo',
    r'hai',
    r'historia',
    r'hom',
    r'htm',
    r'html',
    r'http',
    r'idade',
    r'igrexa',
    r'imaxe',
    r'imaxes',
    r'inclu',
    r'isto',
    r'lenda',
    r'libro',
    r'ligaz',
    r'lingua',
    r'listaref',
    r'lle',
    r'localizaci',
    r'logo',
    r'los',
    r'lugar',
    r'lugares',
    r'maio',
    r'maior',
    r'mais',
    r'mapa',
    r'mar',
    r'marzo',
    r'medio',
    r'mentres',
    r'mero',
    r'mesmo',
    r'mica',
    r'miniatura',
    r'moi',
    r'mundo',
    r'nado',
    r'nados',
    r'name',
    r'nas',
    r'nbsp',
    r'nda',
    r'ndose',
    r'nica',
    r'nico',
    r'nimos',
    r'nome',
    r'non',
    r'nos',
    r'notas',
    r'nova',
    r'novembro',
    r'novo',
    r'nun',
    r'nunha',
    r'ocultas',
    r'odo',
    r'oficial',
    r'old',
    r'onde',
    r'ordenar',
    r'orixe',
    r'outra',
    r'outras',
    r'outro',
    r'outros',
    r'outroshom',
    r'outubro',
    r'para',
    r'parroquias',
    r'parte',
    r'partir',
    r'per',
    r'pero',
    r'personalidades',
    r'poboaci',
    r'pode',
    r'poder',
    r'pol',
    r'pola',
    r'polo',
    r'polos',
    r'por',
    r'primeira',
    r'primeiro',
    r'principal',
    r'progreso',
    r'provincia',
    r'publicaci',
    r'que',
    r'rica',
    r'ronse',
    r'san',
    r'segunda',
    r'segundo',
    r'sen',
    r'sendo',
    r'ser',
    r'setembro',
    r'seu',
    r'seus',
    r'sica',
    r'situaci',
    r'sobre',
    r'son',
    r'states',
    r'stica',
    r'sticas',
    r'style',
    r'superficie',
    r'sur',
    r'tam',
    r'tanto',
    r'tempo',
    r'ten',
    r'ter',
    r'teñen',
    r'tica',
    r'tico',
    r'ticos',
    r'tipo',
    r'title',
    r'tiña',
    r'todo',
    r'todos',
    r'traxectoria',
    r'tres',
    r'tulo',
    r'unha',
    r'unidos',
    r'united',
    r'url',
    r'varios',
    r'ver',
    r'vez',
    r'vida',
    r'xaneiro',
    r'xase',
    r'xeral',
    r'xina',
    r'xullo',
    r'xunto',
    r'xuño',
]

stopwords = Stopwords(name + ".stopwords", stopwords)
"""
:class:`~revscoring.languages.features.Stopwords` features copied from
"common words" in https://meta.wikimedia.org/wiki/?oldid=18399646
"""

badword_regexes = [
    r'tetas',
    r'pis',
    r'pedo',
    r'zorra',
    r'cabron',
    r'cabrón',
    r'caca',
    r'caga',
    r'carallo',
    r'coño',
    r'follar',
    r'fuck',
    r'maricon',
    r'maricón',
    r'merda',
    r'mierda',
    r'pendejo',
    r'polla',
    r'pollas',
    r'puta',
    r'putas',
    r'puto',
    r'putos',
    r'stupid',
    r'tonto',
    r'verga',
    r'porno',
    r'estupido',
    r'estupidos',
    r'estupida',
    r'estupidas',
    r'estúpido',
    r'estúpidos',
    r'estúpida',
    r'estúpidas',
    r'chúpame',
    r'cerdo',
    r'cerdos',
    r'cerda',
    r'cerdas',
    r'imbecil',
    r'imbécil',
    r'cagada',
    r'mamada',
    r'concha',
    r'gilipollas',
]

badwords = RegexMatches(name + ".badwords", badword_regexes,
                        wrapping=(r'^|[^\w\u0980-\u09FF]',
                                  r'$|[^\w\u0980-\u09FF]'))
"""
:class:`~revscoring.languages.features.RegexMatches` features via a list of
badword detecting regexes.
"""

informal_regexes = [
    r'jajaja',
    r'jajajaja',
    r'ola',
    r'adeus'
]

informals = RegexMatches(name + ".informals", informal_regexes)
"""
:class:`~revscoring.languages.features.RegexMatches` features via a list of
informal word detecting regexes.
"""
