import click

from sdccli.cli.scanning.vulnerability.bundle import bundle
import sdccli.usecases.scanning.vulnerability as use_case


@click.group(name='vulnerability', short_help='Vulnerability operations')
def vulnerability():
    pass


@vulnerability.command(name='get_info', short_help="Retrieves information about a vulnerability")
@click.argument('cve', nargs=1)
@click.pass_obj
def add(cnf, cve):
    """
    CVE: The CVE from which more info should be retrieved.
    """
    try:
        res = use_case.get_vulnerability_details(cnf.sdscanning, cve)
        cnf.formatter.format(res, "vulnerabilityDetails")
    except Exception as ex:
        print(ex)


@vulnerability.command(name='add_exception', short_help="Adds a vulnerability exception to a bundle")
@click.argument('bundleid', nargs=1)
@click.argument('cve', nargs=1)
@click.option('--notes', nargs=1, help="Notes for the vulnerability exception")
@click.option('--expiration-date', nargs=1, help="Expiration date in Unix time format")
@click.pass_obj
def add(cnf, bundleid, cve, notes=None, expiration_date=None):
    """
    BUNDLEID: The Bundle ID to add the CVE exception to.
    CVE: The CVE that should be added
    """
    try:
        res = use_case.add_vulnerability_exception(cnf.sdscanning, bundleid, cve, notes, expiration_date)
        cnf.formatter.format(res, "vulnerabilityExceptionAdded")

    except Exception as ex:
        print(ex)


@vulnerability.command(name='del_exception', short_help="Deletes a vulnerability exception from a bundle")
@click.argument('bundleid', nargs=1)
@click.argument('cve', nargs=1)
@click.pass_obj
def delete(cnf, bundleid, cve):
    """
    BUNDLEID: The Bundle ID to remove the CVE exception from.
    CVE: The CVE that should be deleted
    """
    try:
        res = use_case.delete_vulnerability_exception(cnf.sdscanning, bundleid, cve)
        print("Succeed")

    except Exception as ex:
        print(ex)


vulnerability.add_command(bundle)