# Generated by Django 5.0 on 2023-12-22 22:25

import cast.blocks
import wagtail.blocks
import wagtail.embeds.blocks
import wagtail.fields
import wagtail.images.blocks
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("cast", "0051_use_own_image_chooser_block"),
    ]

    operations = [
        migrations.AlterField(
            model_name="blog",
            name="template_base_dir",
            field=models.CharField(
                blank=True,
                choices=[
                    ("bootstrap4", "Bootstrap 4"),
                    ("plain", "Just HTML"),
                    ("vue", "Vue.js"),
                    ("bootstrap5", "Bootstrap 5"),
                ],
                default=None,
                help_text="The theme to use for this blog implemented as a template base directory. If not set, the template base directory will be determined by a site setting.",
                max_length=128,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="post",
            name="body",
            field=wagtail.fields.StreamField(
                [
                    (
                        "overview",
                        wagtail.blocks.StreamBlock(
                            [
                                (
                                    "heading",
                                    wagtail.blocks.CharBlock(
                                        form_classname="full title"
                                    ),
                                ),
                                ("paragraph", wagtail.blocks.RichTextBlock()),
                                (
                                    "code",
                                    wagtail.blocks.StructBlock(
                                        [
                                            (
                                                "language",
                                                wagtail.blocks.CharBlock(
                                                    help_text="The language of the code block"
                                                ),
                                            ),
                                            (
                                                "source",
                                                wagtail.blocks.TextBlock(
                                                    help_text="The source code of the block",
                                                    rows=8,
                                                ),
                                            ),
                                        ],
                                        icon="code",
                                    ),
                                ),
                                (
                                    "image",
                                    cast.blocks.CastImageChooserBlock(
                                        template="cast/image/image.html"
                                    ),
                                ),
                                (
                                    "gallery",
                                    wagtail.blocks.StructBlock(
                                        [
                                            (
                                                "gallery",
                                                cast.blocks.GalleryBlock(
                                                    wagtail.images.blocks.ImageChooserBlock()
                                                ),
                                            ),
                                            (
                                                "layout",
                                                wagtail.blocks.ChoiceBlock(
                                                    choices=[
                                                        (
                                                            "web_component",
                                                            "Web Component with Modal",
                                                        ),
                                                        ("htmx", "HTMX based layout"),
                                                    ]
                                                ),
                                            ),
                                        ]
                                    ),
                                ),
                                ("embed", wagtail.embeds.blocks.EmbedBlock()),
                                (
                                    "video",
                                    cast.blocks.VideoChooserBlock(
                                        icon="media", template="cast/video/video.html"
                                    ),
                                ),
                                (
                                    "audio",
                                    cast.blocks.AudioChooserBlock(
                                        icon="media", template="cast/audio/audio.html"
                                    ),
                                ),
                            ]
                        ),
                    ),
                    (
                        "detail",
                        wagtail.blocks.StreamBlock(
                            [
                                (
                                    "heading",
                                    wagtail.blocks.CharBlock(
                                        form_classname="full title"
                                    ),
                                ),
                                ("paragraph", wagtail.blocks.RichTextBlock()),
                                (
                                    "code",
                                    wagtail.blocks.StructBlock(
                                        [
                                            (
                                                "language",
                                                wagtail.blocks.CharBlock(
                                                    help_text="The language of the code block"
                                                ),
                                            ),
                                            (
                                                "source",
                                                wagtail.blocks.TextBlock(
                                                    help_text="The source code of the block",
                                                    rows=8,
                                                ),
                                            ),
                                        ],
                                        icon="code",
                                    ),
                                ),
                                (
                                    "image",
                                    cast.blocks.CastImageChooserBlock(
                                        template="cast/image/image.html"
                                    ),
                                ),
                                (
                                    "gallery",
                                    wagtail.blocks.StructBlock(
                                        [
                                            (
                                                "gallery",
                                                cast.blocks.GalleryBlock(
                                                    wagtail.images.blocks.ImageChooserBlock()
                                                ),
                                            ),
                                            (
                                                "layout",
                                                wagtail.blocks.ChoiceBlock(
                                                    choices=[
                                                        (
                                                            "web_component",
                                                            "Web Component with Modal",
                                                        ),
                                                        ("htmx", "HTMX based layout"),
                                                    ]
                                                ),
                                            ),
                                        ]
                                    ),
                                ),
                                ("embed", wagtail.embeds.blocks.EmbedBlock()),
                                (
                                    "video",
                                    cast.blocks.VideoChooserBlock(
                                        icon="media", template="cast/video/video.html"
                                    ),
                                ),
                                (
                                    "audio",
                                    cast.blocks.AudioChooserBlock(
                                        icon="media", template="cast/audio/audio.html"
                                    ),
                                ),
                            ]
                        ),
                    ),
                ],
                use_json_field=True,
            ),
        ),
        migrations.AlterField(
            model_name="templatebasedirectory",
            name="name",
            field=models.CharField(
                choices=[
                    ("bootstrap4", "Bootstrap 4"),
                    ("plain", "Just HTML"),
                    ("vue", "Vue.js"),
                    ("bootstrap5", "Bootstrap 5"),
                ],
                default="bootstrap4",
                help_text="The theme to use for this site implemented as a template base directory. It's possible to overwrite this setting for each blog.If you want to use a custom theme, you have to create a new directory in your template directory named cast/<your-theme-name>/ and put all required templates in there.",
                max_length=128,
            ),
        ),
    ]
